/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.schema;

import com.mongodb.spark.sql.connector.exceptions.DataException;
import com.mongodb.spark.sql.connector.interop.JavaScala;
import com.mongodb.spark.sql.connector.schema.InternalRowToRowFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.json.JsonParseException;
import org.bson.types.Decimal128;
import org.jetbrains.annotations.NotNull;
import scala.collection.Map;
import scala.collection.Seq;

@NotNull
public final class RowToBsonDocumentConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final InternalRowToRowFunction internalRowToRowFunction;
    private final boolean convertJson;
    private static final String BSON_TEMPLATE = "{v: %s}";

    public RowToBsonDocumentConverter(StructType schema, boolean convertJson) {
        this.internalRowToRowFunction = new InternalRowToRowFunction(schema);
        this.convertJson = convertJson;
    }

    public BsonDocument fromRow(InternalRow row) {
        return this.fromRow(this.internalRowToRowFunction.apply(row));
    }

    public BsonDocument fromRow(Row row) {
        if (row.schema() == null) {
            throw new DataException("Cannot convert Row without schema");
        }
        return this.toBsonValue((DataType)row.schema(), row).asDocument();
    }

    public BsonValue toBsonValue(DataType dataType, Object data) {
        try {
            if (data == null) {
                return BsonNull.VALUE;
            }
            if (DataTypes.BinaryType.acceptsType(dataType)) {
                return new BsonBinary((byte[])data);
            }
            if (DataTypes.BooleanType.acceptsType(dataType)) {
                return new BsonBoolean(((Boolean)data).booleanValue());
            }
            if (DataTypes.DoubleType.acceptsType(dataType)) {
                return new BsonDouble(((Number)data).doubleValue());
            }
            if (DataTypes.FloatType.acceptsType(dataType)) {
                return new BsonDouble((double)((Number)data).floatValue());
            }
            if (DataTypes.IntegerType.acceptsType(dataType)) {
                return new BsonInt32(((Number)data).intValue());
            }
            if (DataTypes.ShortType.acceptsType(dataType)) {
                return new BsonInt32(((Number)data).intValue());
            }
            if (DataTypes.ByteType.acceptsType(dataType)) {
                return new BsonInt32(((Number)data).intValue());
            }
            if (DataTypes.LongType.acceptsType(dataType)) {
                return new BsonInt64(((Number)data).longValue());
            }
            if (DataTypes.StringType.acceptsType(dataType)) {
                return this.processString((String)data);
            }
            if (DataTypes.DateType.acceptsType(dataType) || DataTypes.TimestampType.acceptsType(dataType)) {
                return new BsonDateTime(((Date)data).getTime());
            }
            if (DataTypes.NullType.acceptsType(dataType)) {
                return BsonNull.VALUE;
            }
            if (dataType instanceof DecimalType) {
                BigDecimal bigDecimal = data instanceof BigDecimal ? (BigDecimal)data : ((Decimal)data).toBigDecimal().bigDecimal();
                return new BsonDecimal128(new Decimal128(bigDecimal));
            }
            if (dataType instanceof ArrayType) {
                DataType elementType = ((ArrayType)dataType).elementType();
                BsonArray bsonArray = new BsonArray();
                List<Object> listData = data instanceof List ? (List<Object>)data : (data instanceof Object[] ? Arrays.asList((Object[])data) : JavaScala.asJava((Seq)data));
                listData.forEach(d -> bsonArray.add(this.toBsonValue(elementType, d)));
                return bsonArray;
            }
            if (dataType instanceof MapType) {
                DataType keyType = ((MapType)dataType).keyType();
                DataType valueType = ((MapType)dataType).valueType();
                if (!(keyType instanceof StringType)) {
                    throw new DataException(String.format("Cannot cast %s into a BsonValue. Invalid key type %s.", data, keyType));
                }
                BsonDocument bsonDocument = new BsonDocument();
                java.util.Map<String, Object> mapData = data instanceof java.util.Map ? (java.util.Map<String, Object>)data : JavaScala.asJava((Map)data);
                mapData.forEach((k, v) -> bsonDocument.put(k, this.toBsonValue(valueType, v)));
                return bsonDocument;
            }
            if (dataType instanceof StructType) {
                Row row = (Row)data;
                BsonDocument bsonDocument = new BsonDocument();
                for (StructField field : row.schema().fields()) {
                    int fieldIndex = row.fieldIndex(field.name());
                    bsonDocument.append(field.name(), this.toBsonValue(field.dataType(), row.get(fieldIndex)));
                }
                return bsonDocument;
            }
        }
        catch (Exception e) {
            throw new DataException(String.format("Cannot cast %s into a BsonValue. %s has no matching BsonValue. Error: %s", data, dataType, e.getMessage()));
        }
        throw new DataException(String.format("Cannot cast %s into a BsonValue. %s data type has no matching BsonValue.", data, dataType));
    }

    private BsonValue processString(String data) {
        if (this.convertJson) {
            try {
                return BsonDocument.parse((String)String.format(BSON_TEMPLATE, data)).get((Object)"v");
            }
            catch (JsonParseException e) {
                return new BsonString(data);
            }
        }
        return new BsonString(data);
    }
}

