/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.write;

import com.mongodb.spark.sql.connector.config.WriteConfig;
import com.mongodb.spark.sql.connector.write.MongoDataWriter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.streaming.StreamingDataWriterFactory;
import org.apache.spark.sql.types.StructType;

final class MongoDataWriterFactory
implements DataWriterFactory,
StreamingDataWriterFactory {
    static final long serialVersionUID = 1L;
    private final StructType schema;
    private final WriteConfig writeConfig;

    MongoDataWriterFactory(StructType schema, WriteConfig writeConfig) {
        this.schema = schema;
        this.writeConfig = writeConfig;
    }

    public DataWriter<InternalRow> createWriter(int partitionId, long taskId) {
        return new MongoDataWriter(partitionId, taskId, this.schema, this.writeConfig, -1L);
    }

    public DataWriter<InternalRow> createWriter(int partitionId, long taskId, long epochId) {
        return new MongoDataWriter(partitionId, taskId, this.schema, this.writeConfig, epochId);
    }
}

