/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;

public abstract class JarScanner {
    public abstract void processEntry(URL var1, JarEntry var2);

    public void scan(Pattern pattern, ClassLoader loader, boolean isNullInclusive, boolean visitParent) throws Exception {
        String[] patterns = pattern == null ? null : pattern.pattern().split(",");
        ArrayList<Pattern> subPatterns = new ArrayList<Pattern>();
        for (int i = 0; patterns != null && i < patterns.length; ++i) {
            subPatterns.add(Pattern.compile(patterns[i]));
        }
        if (subPatterns.isEmpty()) {
            subPatterns.add(pattern);
        }
        while (loader != null) {
            URL[] urls;
            if (loader instanceof URLClassLoader && (urls = ((URLClassLoader)loader).getURLs()) != null) {
                if (subPatterns.isEmpty()) {
                    this.processJars(null, urls, isNullInclusive);
                } else {
                    for (Pattern p : subPatterns) {
                        this.processJars(p, urls, isNullInclusive);
                    }
                }
            }
            if (visitParent) {
                loader = loader.getParent();
                continue;
            }
            loader = null;
        }
    }

    public void processJars(Pattern pattern, URL[] urls, boolean isNullInclusive) throws Exception {
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].toString().toLowerCase().endsWith(".jar")) continue;
            String jar = urls[i].toString();
            int slash = jar.lastIndexOf(47);
            jar = jar.substring(slash + 1);
            if ((pattern != null || !isNullInclusive) && (pattern == null || !pattern.matcher(jar).matches())) continue;
            this.processJar(urls[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processJar(URL url) throws Exception {
        Log.debug((String)"Search of {}", (Object)url);
        InputStream in = Resource.newResource((URL)url).getInputStream();
        if (in == null) {
            return;
        }
        JarInputStream jar_in = new JarInputStream(in);
        try {
            JarEntry entry = jar_in.getNextJarEntry();
            while (entry != null) {
                this.processEntry(url, entry);
                entry = jar_in.getNextJarEntry();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            jar_in.close();
            throw throwable;
        }
        jar_in.close();
    }
}

