/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.parser;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.module.db.internal.domain.param.QueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.module.db.internal.parser.QueryTemplateParser;
import org.mule.module.db.internal.parser.QueryTemplateParsingException;
import org.mule.util.StringUtils;

public class SimpleQueryTemplateParser
implements QueryTemplateParser {
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};
    private static final String[] BEGIN_SKIP = new String[]{"'", "\"", "--", "/*"};
    private static final String[] END_SKIP = new String[]{"'", "\"", "\n", "*/"};
    private static final Log logger = LogFactory.getLog(SimpleQueryTemplateParser.class);
    private static final String STORED_PROCEDURE_REGEX = "(?ms)(\\{\\s*)?(:\\S+\\s*=)?\\s*CALL\\s* \\s*.*";
    private static final String OPERATION_REGEX_TEMPLATE = "(?ms)%s\\s++.+";
    private static final String UPDATE_REGEX = String.format("(?ms)%s\\s++.+", "UPDATE");
    private static final String SELECT_REGEX = String.format("(?ms)%s\\s++.+", "SELECT");
    private static final String INSERT_REGEX = String.format("(?ms)%s\\s++.+", "INSERT");
    private static final String DELETE = String.format("(?ms)%s\\s++.+", "DELETE");
    private static final String TRUNCATE = String.format("(?ms)%s\\s++.+", "TRUNCATE TABLE");
    private static final String MERGE_REGEX = String.format("(?ms)%s\\s++.+", "MERGE");
    private final Pattern storedProcedureMatcher = Pattern.compile("(?ms)(\\{\\s*)?(:\\S+\\s*=)?\\s*CALL\\s* \\s*.*");
    private final Pattern updateMatcher = Pattern.compile(UPDATE_REGEX);
    private final Pattern selectMatcher = Pattern.compile(SELECT_REGEX);
    private final Pattern insertMatcher = Pattern.compile(INSERT_REGEX);
    private final Pattern deleteMatcher = Pattern.compile(DELETE);
    private final Pattern truncateMatcher = Pattern.compile(TRUNCATE);
    private final Pattern mergeMatcher = Pattern.compile(MERGE_REGEX);

    @Override
    public QueryTemplate parse(String sql) {
        sql = sql.trim();
        QueryType queryType = this.getQueryType(sql);
        return this.doParse(sql, queryType);
    }

    private QueryType getQueryType(String sql) {
        QueryType queryType = this.isSelect(sql = sql.toUpperCase()) ? QueryType.SELECT : (this.isInsert(sql) ? QueryType.INSERT : (this.isDelete(sql) ? QueryType.DELETE : (this.isUpdate(sql) ? QueryType.UPDATE : (this.isStoredProcedureCall(sql) ? QueryType.STORE_PROCEDURE_CALL : (this.isTruncate(sql) ? QueryType.TRUNCATE : (this.isMerge(sql) ? QueryType.MERGE : QueryType.DDL))))));
        return queryType;
    }

    private QueryTemplate doParse(String sqlText, QueryType queryType) {
        if (StringUtils.isEmpty((String)sqlText)) {
            throw new QueryTemplateParsingException("SQL text cannot be empty");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Parsing SQL: " + sqlText));
        }
        String sqlToUse = "";
        ArrayList<QueryParam> parameterList = new ArrayList<QueryParam>();
        char[] sqlTextChars = sqlText.toCharArray();
        int tokenStart = 0;
        int paramIndex = 1;
        while (tokenStart < sqlTextChars.length) {
            int skipToPosition;
            while (tokenStart < sqlTextChars.length && tokenStart != (skipToPosition = SimpleQueryTemplateParser.skipCommentsAndQuotes(sqlTextChars, tokenStart))) {
                sqlToUse = sqlToUse + sqlText.substring(tokenStart, skipToPosition);
                tokenStart = skipToPosition;
            }
            if (tokenStart >= sqlTextChars.length) break;
            char currentChar = sqlTextChars[tokenStart];
            int tokenEnd = tokenStart + 1;
            if (tokenEnd < sqlTextChars.length && currentChar == '#' && sqlTextChars[tokenEnd] == '[') {
                int openBrackets = 0;
                while (tokenEnd < sqlTextChars.length) {
                    if (sqlTextChars[tokenEnd] == ']') {
                        --openBrackets;
                    } else if (sqlTextChars[tokenEnd] == '[') {
                        ++openBrackets;
                    }
                    if (openBrackets == 0) break;
                    ++tokenEnd;
                }
                if (tokenEnd == sqlTextChars.length) {
                    throw new QueryTemplateParsingException("Invalid Mule expression: " + sqlText.substring(tokenStart));
                }
                String value = sqlText.substring(tokenStart, ++tokenEnd);
                DefaultInputQueryParam inputParam = new DefaultInputQueryParam(paramIndex++, UnknownDbType.getInstance(), (Object)value);
                parameterList.add(inputParam);
                sqlToUse = sqlToUse + "?";
                tokenStart = tokenEnd;
                continue;
            }
            if (currentChar == ':') {
                while (tokenEnd < sqlTextChars.length && !SimpleQueryTemplateParser.isParameterSeparator(sqlTextChars[tokenEnd])) {
                    ++tokenEnd;
                }
                if (tokenEnd - tokenStart > 1) {
                    sqlToUse = sqlToUse + "?";
                    String parameter = sqlText.substring(tokenStart + 1, tokenEnd);
                    DefaultInputQueryParam inputParam = new DefaultInputQueryParam(paramIndex++, UnknownDbType.getInstance(), null, parameter);
                    parameterList.add(inputParam);
                }
                tokenStart = tokenEnd;
                continue;
            }
            if (this.isParamChar(currentChar)) {
                DefaultInputQueryParam inputParam = new DefaultInputQueryParam(paramIndex++, UnknownDbType.getInstance(), (Object)null);
                parameterList.add(inputParam);
                ++tokenStart;
                sqlToUse = sqlToUse + currentChar;
                continue;
            }
            sqlToUse = sqlToUse + currentChar;
            ++tokenStart;
        }
        return new QueryTemplate(sqlToUse, queryType, parameterList);
    }

    private boolean isParamChar(char c) {
        return c == '?';
    }

    private boolean isStoredProcedureCall(String sqlText) {
        Matcher m = this.storedProcedureMatcher.matcher(sqlText);
        return m.matches();
    }

    private boolean isTruncate(String sqlText) {
        Matcher m = this.truncateMatcher.matcher(sqlText);
        return m.matches();
    }

    private boolean isMerge(String sqlText) {
        Matcher m = this.mergeMatcher.matcher(sqlText);
        return m.matches();
    }

    private boolean isUpdate(String sqlText) {
        Matcher m = this.updateMatcher.matcher(sqlText);
        return m.matches();
    }

    private boolean isInsert(String sqlText) {
        Matcher m = this.insertMatcher.matcher(sqlText);
        return m.matches();
    }

    private boolean isDelete(String sqlText) {
        Matcher m = this.deleteMatcher.matcher(sqlText);
        return m.matches();
    }

    private boolean isSelect(String sqlText) {
        Matcher m = this.selectMatcher.matcher(sqlText);
        return m.matches();
    }

    private static boolean isParameterSeparator(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        for (char separator : PARAMETER_SEPARATORS) {
            if (c != separator) continue;
            return true;
        }
        return false;
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        for (int i = 0; i < BEGIN_SKIP.length; ++i) {
            if (statement[position] != BEGIN_SKIP[i].charAt(0)) continue;
            boolean match = true;
            for (int j = 1; j < BEGIN_SKIP[i].length(); ++j) {
                if (statement[position + j] == BEGIN_SKIP[i].charAt(j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            int offset = BEGIN_SKIP[i].length();
            for (int m = position + offset; m < statement.length; ++m) {
                if (statement[m] != END_SKIP[i].charAt(0)) continue;
                boolean endMatch = true;
                int endPos = m;
                for (int n = 1; n < END_SKIP[i].length(); ++n) {
                    if (m + n >= statement.length) {
                        return statement.length;
                    }
                    if (statement[m + n] != END_SKIP[i].charAt(n)) {
                        endMatch = false;
                        break;
                    }
                    endPos = m + n;
                }
                if (!endMatch) continue;
                return endPos + 1;
            }
            return statement.length;
        }
        return position;
    }
}

