/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel;

import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.el.VariableAssignmentCallback;
import org.mule.api.transport.PropertyScope;
import org.mule.el.context.MessageContext;
import org.mule.el.context.MessagePropertyMapContext;
import org.mule.el.mvel.MuleBaseVariableResolverFactory;
import org.mule.el.mvel.MuleImmutableVariableResolver;
import org.mule.el.mvel.MuleVariableResolver;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.integration.VariableResolver;
import org.mule.mvel2.integration.VariableResolverFactory;

public class MessageVariableResolverFactory
extends MuleBaseVariableResolverFactory {
    private static final long serialVersionUID = -6819292692339684915L;
    private static final String MESSAGE = "message";
    private static final String EXCEPTION = "exception";
    public static final String PAYLOAD = "payload";
    public static final String MESSAGE_PAYLOAD = "message.payload";
    public static final String FLOW_VARS = "flowVars";
    public static final String SESSION_VARS = "sessionVars";
    private MuleMessage muleMessage;

    public MessageVariableResolverFactory(ParserConfiguration parserConfiguration, MuleContext muleContext, MuleMessage message) {
        this.muleMessage = message;
    }

    public MessageVariableResolverFactory(ParserConfiguration parserConfiguration, MuleContext muleContext, MuleMessage message, VariableResolverFactory next) {
        this(parserConfiguration, muleContext, message);
        this.setNextFactory(next);
    }

    @Override
    public boolean isTarget(String name) {
        return MESSAGE.equals(name) || PAYLOAD.equals(name) || FLOW_VARS.equals(name) || EXCEPTION.equals(name) || SESSION_VARS.equals(name) || "_muleMessage".equals(name);
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        if (this.muleMessage != null) {
            if (MESSAGE.equals(name)) {
                return new MuleImmutableVariableResolver<MessageContext>(MESSAGE, new MessageContext(this.muleMessage), null);
            }
            if (PAYLOAD.equals(name)) {
                return new MuleVariableResolver<Object>(PAYLOAD, new MessageContext(this.muleMessage).getPayload(), null, new VariableAssignmentCallback<Object>(){

                    @Override
                    public void assignValue(String name, Object value, Object newValue) {
                        MessageVariableResolverFactory.this.muleMessage.setPayload(newValue);
                    }
                });
            }
            if (FLOW_VARS.equals(name)) {
                return new MuleImmutableVariableResolver<MessagePropertyMapContext>(FLOW_VARS, new MessagePropertyMapContext(this.muleMessage, PropertyScope.INVOCATION), null);
            }
            if (EXCEPTION.equals(name)) {
                if (this.muleMessage.getExceptionPayload() != null) {
                    return new MuleImmutableVariableResolver<Throwable>(EXCEPTION, this.muleMessage.getExceptionPayload().getException(), null);
                }
                return new MuleImmutableVariableResolver<Object>(EXCEPTION, null, null);
            }
            if (SESSION_VARS.equals(name)) {
                return new MuleImmutableVariableResolver<MessagePropertyMapContext>(SESSION_VARS, new MessagePropertyMapContext(this.muleMessage, PropertyScope.SESSION), null);
            }
            if ("_muleMessage".equals(name)) {
                return new MuleImmutableVariableResolver<MuleMessage>("_muleMessage", this.muleMessage, null);
            }
        }
        return super.getNextFactoryVariableResolver(name);
    }
}

