/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.exception.MessageRedeliveredException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.api.processor.MessageProcessor;
import org.mule.exception.RedeliveryExceeded;
import org.mule.exception.TemplateMessagingExceptionStrategy;

public class RollbackMessagingExceptionStrategy
extends TemplateMessagingExceptionStrategy {
    private RedeliveryExceeded redeliveryExceeded;
    private Integer maxRedeliveryAttempts;

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.redeliveryExceeded);
        super.doInitialise(muleContext);
    }

    public void setRedeliveryExceeded(RedeliveryExceeded redeliveryExceeded) {
        this.redeliveryExceeded = redeliveryExceeded;
    }

    public void setMaxRedeliveryAttempts(Integer maxRedeliveryAttempts) {
        this.maxRedeliveryAttempts = maxRedeliveryAttempts;
    }

    public Integer getMaxRedeliveryAttempts() {
        return this.maxRedeliveryAttempts;
    }

    public boolean hasMaxRedeliveryAttempts() {
        return this.maxRedeliveryAttempts != null;
    }

    @Override
    protected MuleEvent beforeRouting(Exception exception, MuleEvent event) {
        if (!this.isRedeliveryExhausted(exception)) {
            this.rollback(exception);
        }
        return event;
    }

    @Override
    protected List<MessageProcessor> getOwnedMessageProcessors() {
        ArrayList<MessageProcessor> messageProcessors = new ArrayList<MessageProcessor>(super.getMessageProcessors().size() + (this.redeliveryExceeded == null ? 0 : this.redeliveryExceeded.getMessageProcessors().size()));
        messageProcessors.addAll(super.getMessageProcessors());
        if (this.redeliveryExceeded != null) {
            messageProcessors.addAll(this.redeliveryExceeded.getMessageProcessors());
        }
        return messageProcessors;
    }

    private boolean isRedeliveryExhausted(Exception exception) {
        return exception instanceof MessageRedeliveredException;
    }

    @Override
    protected boolean acceptsEvent(MuleEvent event) {
        return event.getMessage().getExceptionPayload().getException() instanceof MessageRedeliveredException && this.hasMaxRedeliveryAttempts();
    }

    @Override
    protected MuleEvent route(MuleEvent event, Exception t) {
        MuleEvent resultEvent = event;
        if (this.isRedeliveryExhausted(t)) {
            if (this.redeliveryExceeded != null) {
                try {
                    this.markExceptionAsHandled(t);
                    resultEvent = this.redeliveryExceeded.process(event);
                }
                catch (MuleException e) {
                    this.logFatal(event, t);
                }
            } else {
                this.logger.info((Object)"Message redelivery exhausted. No redelivery exhausted actions configured. Message consumed.");
            }
        } else {
            resultEvent = super.route(event, t);
        }
        return resultEvent;
    }

    @Override
    protected void processReplyTo(MuleEvent event, Exception e) {
        if (this.isRedeliveryExhausted(e)) {
            super.processReplyTo(event, e);
        }
    }
}

