/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import org.mule.DefaultMuleEvent;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.context.notification.ExceptionStrategyNotification;
import org.mule.exception.AbstractExceptionListener;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.message.DefaultExceptionPayload;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.requestreply.ReplyToPropertyRequestReplyReplier;
import org.mule.transaction.TransactionCoordination;

public abstract class TemplateMessagingExceptionStrategy
extends AbstractExceptionListener
implements MessagingExceptionHandlerAcceptor {
    private MessageProcessorChain configuredMessageProcessors;
    private MessageProcessor replyToMessageProcessor = new ReplyToPropertyRequestReplyReplier();
    private String when;
    private boolean handleException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final MuleEvent handleException(Exception exception, MuleEvent event) {
        try {
            boolean nonBlocking = event.isAllowNonBlocking();
            this.muleContext.getNotificationManager().fireNotification(new ExceptionStrategyNotification(event, 2001));
            FlowConstruct flowConstruct = event.getFlowConstruct();
            this.fireNotification(exception);
            this.logException(exception, event);
            this.processStatistics(event);
            event.getMessage().setExceptionPayload(new DefaultExceptionPayload(exception));
            if (nonBlocking) {
                event = new DefaultMuleEvent(event, event.getFlowConstruct(), null, null, true);
            }
            event = this.beforeRouting(exception, event);
            event = this.route(event, exception);
            this.processOutboundRouterStatistics(flowConstruct);
            event = this.afterRouting(exception, event);
            this.markExceptionAsHandledIfRequired(exception);
            if (event != null && !VoidMuleEvent.getInstance().equals(event)) {
                if (!nonBlocking) {
                    this.processReplyTo(event, exception);
                }
                this.closeStream(event.getMessage());
                this.nullifyExceptionPayloadIfRequired(event);
            }
            MuleEvent muleEvent = event;
            return muleEvent;
        }
        catch (Exception e) {
            MessagingException messagingException = e instanceof MessagingException ? (MessagingException)e : new MessagingException(event, (Throwable)e);
            try {
                this.logger.error((Object)"Exception during exception strategy execution");
                this.doLogException(e);
                TransactionCoordination.getInstance().rollbackCurrentTransaction();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            event.getMessage().setExceptionPayload(new DefaultExceptionPayload(messagingException));
            MuleEvent muleEvent = event;
            return muleEvent;
        }
        finally {
            this.muleContext.getNotificationManager().fireNotification(new ExceptionStrategyNotification(event, 2002));
        }
    }

    private void markExceptionAsHandledIfRequired(Exception exception) {
        if (this.handleException) {
            this.markExceptionAsHandled(exception);
        }
    }

    protected void markExceptionAsHandled(Exception exception) {
        if (exception instanceof MessagingException) {
            ((MessagingException)exception).setHandled(true);
        }
    }

    protected void processReplyTo(MuleEvent event, Exception e) {
        try {
            this.replyToMessageProcessor.process(event);
        }
        catch (MuleException ex) {
            this.logFatal(event, ex);
        }
    }

    protected void nullifyExceptionPayloadIfRequired(MuleEvent event) {
        if (this.handleException) {
            event.getMessage().setExceptionPayload(null);
        }
    }

    private void processStatistics(MuleEvent event) {
        FlowConstructStatistics statistics = event.getFlowConstruct().getStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incExecutionError();
        }
    }

    protected MuleEvent route(MuleEvent event, Exception t) {
        if (!this.getMessageProcessors().isEmpty()) {
            try {
                event.getMessage().setExceptionPayload(new DefaultExceptionPayload(t));
                MuleEvent result = this.configuredMessageProcessors.process(event);
                return result;
            }
            catch (Exception e) {
                this.logFatal(event, e);
            }
        }
        return event;
    }

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        super.doInitialise(muleContext);
        DefaultMessageProcessorChainBuilder defaultMessageProcessorChainBuilder = new DefaultMessageProcessorChainBuilder(this.flowConstruct);
        try {
            this.configuredMessageProcessors = defaultMessageProcessorChainBuilder.chain(this.getMessageProcessors()).build();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void setWhen(String when) {
        this.when = when;
    }

    @Override
    public boolean accept(MuleEvent event) {
        return this.acceptsAll() || this.acceptsEvent(event) || this.muleContext.getExpressionManager().evaluateBoolean(this.when, event);
    }

    protected boolean acceptsEvent(MuleEvent event) {
        return false;
    }

    @Override
    public boolean acceptsAll() {
        return this.when == null;
    }

    protected MuleEvent afterRouting(Exception exception, MuleEvent event) {
        return event;
    }

    protected MuleEvent beforeRouting(Exception exception, MuleEvent event) {
        return event;
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
    }

    public void setHandleException(boolean handleException) {
        this.handleException = handleException;
    }
}

