/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.streaming;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallbackOutputStream
extends OutputStream {
    private static final Log logger = LogFactory.getLog(CallbackOutputStream.class);
    private OutputStream delegate;
    private Callback callback;

    public CallbackOutputStream(OutputStream delegate, Callback callback) {
        this.delegate = delegate;
        this.callback = callback;
    }

    @Override
    public void write(int b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        finally {
            this.closeCallback();
        }
    }

    private void closeCallback() {
        if (null != this.callback) {
            try {
                this.callback.onClose();
            }
            catch (Exception e) {
                logger.debug((Object)("Suppressing exception while releasing resources: " + e.getMessage()));
            }
        }
    }

    public static interface Callback {
        public void onClose() throws Exception;
    }
}

