/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.MessageExchangePattern;
import org.mule.OptimizedRequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NonBlockingSupported;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.processor.StageNameSource;
import org.mule.api.processor.StageNameSourceProvider;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.util.ClassUtils;
import org.mule.util.NotificationUtils;
import org.mule.work.AbstractMuleEventWork;

public class AsyncDelegateMessageProcessor
extends AbstractMessageProcessorOwner
implements MessageProcessor,
Initialisable,
Startable,
Stoppable,
NonBlockingSupported {
    protected Log logger = LogFactory.getLog(this.getClass());
    private AtomicBoolean consumablePayloadWarned = new AtomicBoolean(false);
    protected MessageProcessor delegate;
    protected List<MessageProcessor> processors;
    protected ProcessingStrategy processingStrategy;
    protected String name;
    private MessageProcessor target;

    public AsyncDelegateMessageProcessor(MessageProcessor delegate, ProcessingStrategy processingStrategy, String name) {
        this.delegate = delegate;
        this.processingStrategy = processingStrategy;
        this.name = name;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.delegate == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("delegate message processor"), (Initialisable)this);
        }
        if (this.processingStrategy == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("processingStrategy"), (Initialisable)this);
        }
        this.validateFlowConstruct();
        StageNameSource nameSource = null;
        nameSource = this.name != null ? ((StageNameSourceProvider)((Object)this.flowConstruct)).getAsyncStageNameSource(this.name) : ((StageNameSourceProvider)((Object)this.flowConstruct)).getAsyncStageNameSource();
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder(this.flowConstruct);
        this.processingStrategy.configureProcessors(Collections.singletonList(this.delegate), nameSource, builder, this.muleContext);
        try {
            this.target = builder.build();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        super.initialise();
    }

    private void validateFlowConstruct() {
        if (this.flowConstruct == null) {
            throw new IllegalArgumentException("FlowConstruct cannot be null");
        }
        if (!(this.flowConstruct instanceof StageNameSourceProvider)) {
            throw new IllegalArgumentException(String.format("FlowConstuct must implement the %s interface. However, the type %s does not implement it", StageNameSourceProvider.class.getCanonicalName(), this.flowConstruct.getClass().getCanonicalName()));
        }
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (event.isTransacted()) {
            throw new MessagingException(CoreMessages.asyncDoesNotSupportTransactions(), event, (MessageProcessor)this);
        }
        MuleMessage message = event.getMessage();
        if (this.consumablePayloadWarned.compareAndSet(false, true) && ClassUtils.isConsumable(message.getPayload().getClass())) {
            this.logger.warn((Object)String.format("Using 'async' router with consumable payload (%s) may lead to unexpected results. Please ensure that only one of the branches actually consumes the payload, or transform it by using an <object-to-byte-array-transformer>.", message.getPayload().getClass().getName()));
        }
        if (this.target != null) {
            DefaultMuleEvent newEvent = new DefaultMuleEvent((MuleMessage)((Object)((ThreadSafeAccess)((Object)message)).newThreadCopy()), event, false, false, MessageExchangePattern.ONE_WAY);
            OptimizedRequestContext.unsafeSetEvent(newEvent);
            this.target.process(newEvent);
        }
        if (this.muleContext.getConfiguration().isFlowEndingWithOneWayEndpointReturnsNull()) {
            return event;
        }
        return VoidMuleEvent.getInstance();
    }

    public void setDelegate(MessageProcessor delegate) {
        this.delegate = delegate;
    }

    @Override
    protected List<MessageProcessor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.target);
    }

    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    @Override
    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        if (this.delegate instanceof MessageProcessorContainer) {
            ((MessageProcessorContainer)((Object)this.delegate)).addMessageProcessorPathElements(pathElement);
        } else {
            NotificationUtils.addMessageProcessorPathElements(Collections.singletonList(this.delegate), pathElement);
        }
    }

    @Deprecated
    class AsyncMessageProcessorWorker
    extends AbstractMuleEventWork {
        public AsyncMessageProcessorWorker(MuleEvent event) {
            super(event);
        }

        @Override
        protected void doRun() {
            try {
                AsyncDelegateMessageProcessor.this.delegate.process(this.event);
            }
            catch (MuleException e) {
                this.event.getFlowConstruct().getExceptionListener().handleException(e, this.event);
            }
        }
    }
}

