/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.serialization.SerializationException;
import org.mule.api.store.ObjectStoreException;
import org.mule.routing.AbstractAggregator;
import org.mule.routing.AggregationException;
import org.mule.routing.EventGroup;
import org.mule.routing.correlation.CollectionCorrelatorCallback;
import org.mule.routing.correlation.CorrelationSequenceComparator;
import org.mule.routing.correlation.EventCorrelatorCallback;

public class MessageChunkAggregator
extends AbstractAggregator {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    protected Comparator eventComparator = new CorrelationSequenceComparator();

    @Override
    protected EventCorrelatorCallback getCorrelatorCallback(MuleContext muleContext) {
        return new CollectionCorrelatorCallback(muleContext, this.storePrefix){

            @Override
            public MuleEvent aggregateEvents(EventGroup events) throws AggregationException {
                MuleEvent[] collectedEvents;
                try {
                    collectedEvents = events.toArray(false);
                }
                catch (ObjectStoreException e) {
                    throw new AggregationException(events, (MessageProcessor)MessageChunkAggregator.this, (Throwable)e);
                }
                MuleEvent firstEvent = collectedEvents[0];
                Arrays.sort(collectedEvents, MessageChunkAggregator.this.eventComparator);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
                try {
                    DefaultMuleMessage message;
                    for (MuleEvent event : collectedEvents) {
                        baos.write(event.getMessageAsBytes());
                    }
                    try {
                        Object deserialized = this.muleContext.getObjectSerializer().deserialize(baos.toByteArray());
                        message = new DefaultMuleMessage(deserialized, firstEvent.getMessage(), this.muleContext);
                    }
                    catch (SerializationException e) {
                        message = new DefaultMuleMessage((Object)baos.toByteArray(), firstEvent.getMessage(), this.muleContext);
                    }
                    message.setCorrelationGroupSize(-1);
                    message.setCorrelationSequence(-1);
                    DefaultMuleEvent defaultMuleEvent = new DefaultMuleEvent((MuleMessage)message, firstEvent, this.getMergedSession(events.toArray()));
                    return defaultMuleEvent;
                }
                catch (Exception e) {
                    throw new AggregationException(events, (MessageProcessor)MessageChunkAggregator.this, (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)baos);
                }
            }
        };
    }
}

