/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.main;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.mvel.MVELTemplateRegistry;
import org.mvel.TemplateInterpreter;
import org.mvel.TemplateRegistry;
import org.mvel.tests.main.res.Bar;
import org.mvel.tests.main.res.Base;
import org.mvel.tests.main.res.Foo;

public class TemplateConfidenceTests
extends TestCase {
    Foo foo = new Foo();
    Map<String, Object> map = new HashMap<String, Object>();
    Base base = new Base();

    public TemplateConfidenceTests() {
        this.foo.setBar(new Bar());
        this.map.put("foo", this.foo);
        this.map.put("a", null);
        this.map.put("b", null);
        this.map.put("c", "cat");
        this.map.put("BWAH", "");
        this.map.put("pi", "3.14");
        this.map.put("hour", "60");
        this.map.put("zero", new Integer(0));
        this.map.put("doubleTen", new Double(10.0));
        this.map.put("variable_with_underscore", "HELLO");
        this.map.put("testImpl", new TestInterface(){

            public String getName() {
                return "FOOBAR!";
            }

            public boolean isFoo() {
                return true;
            }
        });
    }

    public void testPassThru2() {
        TemplateConfidenceTests.assertEquals((Object)"foo@bar.com", (Object)TemplateInterpreter.eval("foo@bar.com", this.map));
    }

    public void testMethodOnValue() {
        TemplateConfidenceTests.assertEquals((Object)"DOG", (Object)this.parse("@{foo.bar.name.toUpperCase()}"));
    }

    public void testSimpleProperty() {
        TemplateConfidenceTests.assertEquals((Object)"dog", (Object)this.parse("@{foo.bar.name}"));
    }

    public void testBooleanOperator() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{foo.bar.woof == true}"));
    }

    public void testBooleanOperator2() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.parse("@{foo.bar.woof == false}"));
    }

    public void testTextComparison() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{foo.bar.name == 'dog'}"));
    }

    public void testNETextComparison() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{foo.bar.name != 'foo'}"));
    }

    public void testChor() {
        TemplateConfidenceTests.assertEquals((Object)"cat", (Object)this.parse("@{a or b or c}"));
    }

    public void testChorWithLiteral() {
        TemplateConfidenceTests.assertEquals((Object)"fubar", (Object)this.parse("@{a or 'fubar'}"));
    }

    public void testNullCompare() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{c != null}"));
    }

    public void testAnd() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{c != null && foo.bar.name == 'dog' && foo.bar.woof}"));
    }

    public void testMath() {
        TemplateConfidenceTests.assertEquals((Object)new Float(188.4f), (Object)this.parse("@{pi * hour}"));
    }

    public void testTemplating() {
        TemplateConfidenceTests.assertEquals((Object)"dogDOGGIE133.5", (Object)this.parse("@{foo.bar.name}DOGGIE@{hour*2.225+1-1}"));
    }

    public void testComplexAnd() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{(pi * hour) > 0 && foo.happy() == 'happyBar'}"));
    }

    public void testModulus() {
        TemplateConfidenceTests.assertEquals((Object)new Integer(0), (Object)this.parse("@{38392 % 2}"));
    }

    public void testLessThan() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{pi < 3.15}"));
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{pi <= 3.14}"));
        TemplateConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.parse("@{pi > 3.14}"));
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{pi >= 3.14}"));
    }

    public void testMethodAccess() {
        TemplateConfidenceTests.assertEquals((Object)"happyBar", (Object)this.parse("@{foo.happy()}"));
    }

    public void testMethodAccess2() {
        TemplateConfidenceTests.assertEquals((Object)"FUBAR", (Object)this.parse("@{foo.toUC('fubar')}"));
    }

    public void testMethodAccess3() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{equalityCheck(c, 'cat')}"));
    }

    public void testMethodAccess4() {
        TemplateConfidenceTests.assertEquals(null, (Object)this.parse("@{readBack(null)}"));
    }

    public void testMethodAccess5() {
        TemplateConfidenceTests.assertEquals((Object)"nulltest", (Object)this.parse("@{appendTwoStrings(null, 'test')}"));
    }

    public void testMethodAccess6() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.parse("@{!foo.bar.isWoof()}"));
    }

    public void testNegation() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{!fun && !fun}"));
    }

    public void testNegation2() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.parse("@{fun && !fun}"));
    }

    public void testNegation3() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{!(fun && fun)}"));
    }

    public void testNegation4() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.parse("@{(fun && fun)}"));
    }

    public void testMultiStatement() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{populate(); barfoo == 'sarah'}"));
    }

    public void testAssignment2() {
        TemplateConfidenceTests.assertEquals((Object)"sarah", (Object)this.parse("@{populate(); blahfoo = barfoo}"));
    }

    public void testOr() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{fun || true}"));
    }

    public void testLiteralPassThrough() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{true}"));
    }

    public void testLiteralPassThrough2() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.parse("@{false}"));
    }

    public void testLiteralPassThrough3() {
        TemplateConfidenceTests.assertEquals(null, (Object)this.parse("@{null}"));
    }

    public void testControlLoopList() {
        TemplateConfidenceTests.assertEquals((Object)"HappyHappy!JoyJoy!", (Object)this.parse("@foreach{list as fun}@{fun}@end{}"));
    }

    public void testControlLoopArray() {
        TemplateConfidenceTests.assertEquals((Object)"Happy0Happy!1Joy2Joy!3", (Object)this.parse("@foreach{array as fun}@{fun}@{i0}@end{}"));
    }

    public void testMultiCollectionControlLoop() {
        TemplateConfidenceTests.assertEquals((Object)"0=Happy:Happy,1=Happy!:Happy!,2=Joy:Joy,3=Joy!:Joy!", (Object)this.parse("@foreach{list, array as listItem}@{i0}=@{item}:@{listItem}@end{','}"));
    }

    public void testControlLoopListMultiple() {
        int i = 0;
        while (i < 100) {
            this.testControlLoopList();
            ++i;
        }
    }

    public void testControlLoopArrayMultiple() {
        int i = 0;
        while (i < 100) {
            this.testControlLoopArray();
            ++i;
        }
    }

    public void testControlLoop2() {
        TemplateConfidenceTests.assertEquals((Object)"HappyHappy!JoyJoy!", (Object)this.parse("@foreach{list}@{item}@end{}"));
    }

    public void testControlLoop3() {
        TemplateConfidenceTests.assertEquals((Object)"HappyHappy!JoyJoy!", (Object)this.parse("@foreach{ list }@{item}@end{}"));
    }

    public void testIfStatement() {
        TemplateConfidenceTests.assertEquals((Object)"sarah", (Object)this.parse("@if{'fun' == 'fun'}sarah@end{}"));
    }

    public void testIfStatement2() {
        TemplateConfidenceTests.assertEquals((Object)"poo", (Object)this.parse("@if{'fun' == 'bar'}sarah@else{}poo@end{}"));
    }

    public void testRegEx() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{foo.bar.name ~= '[a-z].+'}"));
    }

    public void testRegExNegate() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.parse("@{!(foo.bar.name ~= '[a-z].+')}"));
    }

    public void testRegEx2() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{foo.bar.name ~= '[a-z].+' && foo.bar.name != null}"));
    }

    public void testBlank() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{'' == empty}"));
    }

    public void testBlank2() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{BWAH == empty}"));
    }

    public void testTernary() {
        TemplateConfidenceTests.assertEquals((Object)"foobie", (Object)this.parse("@{zero==0?'foobie':zero}"));
    }

    public void testTernary2() {
        TemplateConfidenceTests.assertEquals((Object)"blimpie", (Object)this.parse("@{zero==1?'foobie':'blimpie'}"));
    }

    public void testTernary3() {
        TemplateConfidenceTests.assertEquals((Object)"foobiebarbie", (Object)this.parse("@{zero==1?'foobie':'foobie'+'barbie'}"));
    }

    public void testTernary4() {
        TemplateConfidenceTests.assertEquals((Object)"no", (Object)this.parse("@{ackbar ? 'yes' : 'no'}"));
    }

    public void testStrAppend() {
        TemplateConfidenceTests.assertEquals((Object)"foobarcar", (Object)this.parse("@{'foo' + 'bar' + 'car'}"));
    }

    public void testStrAppend2() {
        TemplateConfidenceTests.assertEquals((Object)"foobarcar1", (Object)this.parse("@{'foobar' + 'car' + 1}"));
    }

    public void testInstanceCheck1() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{c is 'java.lang.String'}"));
    }

    public void testInstanceCheck2() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.parse("@{pi is 'java.lang.Integer'}"));
    }

    public void testBitwiseOr1() {
        TemplateConfidenceTests.assertEquals((Object)new Integer(6), (Object)this.parse("@{2 | 4}"));
    }

    public void testBitwiseOr2() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{(2 | 1) > 0}"));
    }

    public void testBitwiseOr3() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{(2 | 1) == 3}"));
    }

    public void testBitwiseAnd1() {
        TemplateConfidenceTests.assertEquals((Object)new Integer(2), (Object)this.parse("@{2 & 3}"));
    }

    public void testShiftLeft() {
        TemplateConfidenceTests.assertEquals((Object)new Integer(4), (Object)this.parse("@{2 << 1}"));
    }

    public void testUnsignedShiftLeft() {
        TemplateConfidenceTests.assertEquals((Object)new Integer(2), (Object)this.parse("@{-2 <<< 0}"));
    }

    public void testShiftRight() {
        TemplateConfidenceTests.assertEquals((Object)new Integer(128), (Object)this.parse("@{256 >> 1}"));
    }

    public void testXOR() {
        TemplateConfidenceTests.assertEquals((Object)new Integer(3), (Object)this.parse("@{1 ^ 2}"));
    }

    public void testContains1() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{list contains 'Happy!'}"));
    }

    public void testContains2() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.parse("@{list contains 'Foobie'}"));
    }

    public void testContains3() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{sentence contains 'fox'}"));
    }

    public void testContains4() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(false), (Object)this.parse("@{sentence contains 'mike'}"));
    }

    public void testContains5() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{!(sentence contains 'mike')}"));
    }

    public void testTokenMethodAccess() {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TemplateConfidenceTests.assertEquals(clazz, (Object)this.parse("@{a = 'foo'; a.getClass()}"));
    }

    public void testArrayCreationWithLength() {
        TemplateConfidenceTests.assertEquals((Object)new Integer(2), (Object)this.parse("@{Array.getLength({'foo', 'bar'})}"));
    }

    public void testMapCreation() {
        TemplateConfidenceTests.assertEquals((Object)"sarah", (Object)this.parse("@{map = ['mike':'sarah','tom':'jacquelin']; map['mike']}"));
    }

    public void testProjectionSupport() {
        TemplateConfidenceTests.assertEquals((Object)new Boolean(true), (Object)this.parse("@{(name in things) contains 'Bob'}"));
    }

    public void testProjectionSupport2() {
        TemplateConfidenceTests.assertEquals((Object)new Integer(3), (Object)this.parse("@{(name in things).size()}"));
    }

    public void testObjectInstantiation() {
        TemplateConfidenceTests.assertEquals((Object)"foobie", (Object)this.parse("@{new java.lang.String('foobie')}"));
    }

    public void testObjectInstantiationWithMethodCall() {
        TemplateConfidenceTests.assertEquals((Object)"foobie", (Object)this.parse("@{new String('foobie').toString()}"));
    }

    public void testObjectInstantiation2() {
        this.parse("@{new String() is String}");
    }

    public void testArrayCoercion() {
        TemplateConfidenceTests.assertEquals((Object)"gonk", (Object)this.parse("@{funMethod( {'gonk', 'foo'} )}"));
    }

    public void testMapAccess() {
        TemplateConfidenceTests.assertEquals((Object)"dog", (Object)this.parse("@{funMap['foo'].bar.name}"));
    }

    public void testMapAccess2() {
        TemplateConfidenceTests.assertEquals((Object)"dog", (Object)this.parse("@{funMap.foo.bar.name}"));
    }

    public void testSoundex() {
        TemplateConfidenceTests.assertTrue((boolean)((Boolean)this.parse("@{'foobar' soundslike 'fubar'}")));
    }

    public void testSoundex2() {
        TemplateConfidenceTests.assertFalse((boolean)((Boolean)this.parse("@{'flexbar' soundslike 'fubar'}")));
    }

    public void testThisReference() {
        TemplateConfidenceTests.assertEquals((boolean)true, (boolean)(this.parse("@{this}") instanceof Base));
    }

    public void testIncludeByRef() {
        MVELTemplateRegistry registry = new MVELTemplateRegistry();
        registry.registerTemplate("templateName", "@{var1}@{var2}");
        TemplateConfidenceTests.assertEquals((Object)"xvalue1catx", (Object)this.parse("x@includeByRef{templateName(var1 = \"value1\", var2 = c)}x", registry));
    }

    public void testIncludeByRefNoParams() {
        MVELTemplateRegistry registry = new MVELTemplateRegistry();
        registry.registerTemplate("templateName", "hello");
        TemplateConfidenceTests.assertEquals((Object)"xhellox", (Object)this.parse("x@includeByRef{templateName()}x", registry));
    }

    public void testIncludeByRefNoSpaces() {
        MVELTemplateRegistry registry = new MVELTemplateRegistry();
        registry.registerTemplate("templateName", "@{var1}@{var2}");
        TemplateConfidenceTests.assertEquals((Object)"xvalue1catx", (Object)this.parse("x@includeByRef{templateName(var1=\"value1\", var2=c)}x", registry));
    }

    public void testRegisterTemplateGroup() {
        StringReader reader = new StringReader("myTemplate1() ::=<<@{var1}>>=::  myTemplate2() ::=<<@{var2}>>=::");
        MVELTemplateRegistry registry = new MVELTemplateRegistry();
        registry.registerTemplate(reader);
        TemplateConfidenceTests.assertEquals((Object)"xvalue1catx", (Object)this.parse("x@includeByRef{myTemplate1(var1 = \"value1\")}@includeByRef{myTemplate2(var2 = c)}x", registry));
    }

    public void testRecursiveRegisterTemplateGroup() {
        StringReader reader = new StringReader("myTemplate1() ::=<<@{var1}@includeByRef{myTemplate2(var2 = var2)}>>=::  myTemplate2() ::=<<@{var2}>>=::");
        MVELTemplateRegistry registry = new MVELTemplateRegistry();
        registry.registerTemplate(reader);
        TemplateConfidenceTests.assertEquals((Object)"xvalue1catx", (Object)this.parse("x@includeByRef{myTemplate1(var1 = \"value1\", var2 = c)}x", registry));
    }

    public void testIfLoopInTemplate() {
        TemplateConfidenceTests.assertEquals((Object)"ONETWOTHREE", (Object)this.parse("@foreach{things}@if{item.name=='Bob'}ONE@elseif{item.name=='Smith'}TWO@elseif{item.name=='Cow'}THREE@end{}@end{}"));
    }

    public void testStringEscaping() {
        TemplateConfidenceTests.assertEquals((Object)"\"Mike Brock\"", (Object)this.parse("@{\"\\\"Mike Brock\\\"\"}"));
    }

    public void testStringEscaping2() {
        TemplateConfidenceTests.assertEquals((Object)"MVEL's Parser is Fast", (Object)this.parse("@{'MVEL\\'s Parser is Fast'}"));
    }

    public void testNestedAtSymbol() {
        TemplateConfidenceTests.assertEquals((Object)"email:foo@foo.com", (Object)this.parse("email:@{'foo@foo.com'}"));
    }

    public void testIteration1() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a1");
        list.add("a2");
        list.add("a3");
        String template = "@foreach{list}a@end{}";
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("list", list);
        String r = TemplateInterpreter.evalToString(template, map);
        System.out.println("r: " + r);
        TemplateConfidenceTests.assertEquals((String)"aaa", (String)r);
    }

    public void testIteration2() {
        Folder f1 = new Folder("f1", null);
        String template = "@{name} @foreach{children}a@end{}";
        String r = TemplateInterpreter.evalToString(template, f1);
        System.out.println("r: " + r);
    }

    public void testIteration3() {
        Folder f = new Folder("a1", null);
        List<Page> list = f.getChildren();
        String template = "@foreach{list}a@end{}";
        HashMap<String, List<Page>> map = new HashMap<String, List<Page>>();
        map.put("list", list);
        String r = TemplateInterpreter.evalToString(template, map);
        System.out.println("r: " + r);
        TemplateConfidenceTests.assertEquals((String)"aaa", (String)r);
    }

    public void testIteration4() {
        Folder f = new Folder("a1", null);
        String template = "@foreach{f.children}a@end{}";
        HashMap<String, Folder> map = new HashMap<String, Folder>();
        map.put("f", f);
        String r = TemplateInterpreter.evalToString(template, map);
        System.out.println("r: " + r);
        TemplateConfidenceTests.assertEquals((String)"aaa", (String)r);
    }

    public Object parse(String ex, TemplateRegistry registry) {
        return TemplateInterpreter.parse(ex, (Object)this.base, this.map, registry);
    }

    public Object parse(String ex) {
        return TemplateInterpreter.parse(ex, (Object)this.base, this.map);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Folder
    extends Page {
        Folder(String name, Folder parent) {
            super(name, parent);
        }

        public List<Page> getChildren() {
            ArrayList<Page> list = new ArrayList<Page>();
            list.add(new Page("a1", this));
            list.add(new Page("a2", this));
            list.add(new Page("a3", this));
            return list;
        }
    }

    class Page {
        String name;
        Folder parent;

        Page(String name, Folder parent) {
            this.name = name;
            this.parent = parent;
        }

        public String getName() {
            return this.name;
        }

        public Folder getParent() {
            return this.parent;
        }
    }

    public static interface TestInterface {
        public String getName();

        public boolean isFoo();
    }
}

