/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.io.Serializable;
import java.util.Map;
import org.mvel.CompiledExpression;
import org.mvel.CompiledSetExpression;
import org.mvel.DataConversion;
import org.mvel.EndWithValue;
import org.mvel.ExecutableStatement;
import org.mvel.ExpressionCompiler;
import org.mvel.MVELInterpretedRuntime;
import org.mvel.MVELRuntime;
import org.mvel.Macro;
import org.mvel.MacroProcessor;
import org.mvel.ParserContext;
import org.mvel.PreProcessor;
import org.mvel.PropertyAccessor;
import org.mvel.TemplateInterpreter;
import org.mvel.integration.Interceptor;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.MapVariableResolverFactory;
import org.mvel.optimizers.impl.refl.GetterAccessor;
import org.mvel.optimizers.impl.refl.ReflectiveAccessorOptimizer;
import org.mvel.util.ParseTools;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVEL {
    public static final String NAME = "MVEL (MVFLEX Expression Language)";
    public static final String VERSION = "1.2";
    public static final String VERSION_SUB = "beta16";
    public static final String CODENAME = "horizon";
    static boolean DEBUG_FILE = Boolean.getBoolean("mvel.debug.fileoutput");
    static String ADVANCED_DEBUGGING_FILE = System.getProperty("mvel.debugging.file") == null ? "mvel_debug.txt" : System.getProperty("mvel.debugging.file");
    static boolean ADVANCED_DEBUG = Boolean.getBoolean("mvel.advanced_debugging");
    static boolean THREAD_SAFE = Boolean.getBoolean("mvel.threadsafety");
    static boolean WEAK_CACHE = Boolean.getBoolean("mvel.weak_caching");
    static boolean NO_JIT = Boolean.getBoolean("mvel.disable.jit");
    static boolean OPTIMIZER = true;

    static {
        if (System.getProperty("mvel.optimizer") != null) {
            OPTIMIZER = Boolean.getBoolean("mvel.optimizer");
        }
    }

    public static void setThreadSafe(boolean threadSafe) {
        THREAD_SAFE = threadSafe;
        PropertyAccessor.configureFactory();
        TemplateInterpreter.configureFactory();
        MVELInterpretedRuntime.configureFactory();
    }

    public static boolean isThreadSafe() {
        return THREAD_SAFE;
    }

    public static boolean isAdvancedDebugging() {
        return ADVANCED_DEBUG;
    }

    public static String getDebuggingOutputFileName() {
        return ADVANCED_DEBUGGING_FILE;
    }

    public static boolean isFileDebugging() {
        return DEBUG_FILE;
    }

    public static boolean isOptimizationEnabled() {
        return OPTIMIZER;
    }

    public static Object eval(String expression, Object ctx) {
        return new MVELInterpretedRuntime(expression, ctx).parse();
    }

    public static Object eval(String expression, VariableResolverFactory resolverFactory) {
        return new MVELInterpretedRuntime(expression, resolverFactory).parse();
    }

    public static Object eval(char[] expression, Object ctx, VariableResolverFactory resolverFactory) {
        return new MVELInterpretedRuntime(expression, ctx, resolverFactory).parse();
    }

    public static Object eval(String expression, Object ctx, VariableResolverFactory resolverFactory) {
        return new MVELInterpretedRuntime(expression, ctx, resolverFactory).parse();
    }

    public static Object eval(String expression, Map tokens) {
        return new MVELInterpretedRuntime(expression, null, (Map<String, Object>)tokens).parse();
    }

    public static Object eval(String expression, Object ctx, Map tokens) {
        return new MVELInterpretedRuntime(expression, ctx, (Map<String, Object>)tokens).parse();
    }

    public static Serializable compileExpression(String expression, Map<String, Object> imports, Map<String, Interceptor> interceptors, String sourceName) {
        return ParseTools.optimizeTree(new ExpressionCompiler(expression).compile(new ParserContext(imports, interceptors, sourceName)));
    }

    public static Serializable compileExpression(String expression) {
        return MVEL.compileExpression(expression, null, null, null);
    }

    public static Serializable compileExpression(String expression, Map<String, Object> imports) {
        return MVEL.compileExpression(expression, imports, null, null);
    }

    public static Serializable compileExpression(String expression, Map<String, Object> imports, Map<String, Interceptor> interceptors) {
        return MVEL.compileExpression(expression, imports, interceptors, null);
    }

    public static Serializable compileExpression(char[] expression, Map<String, Object> imports, Map<String, Interceptor> interceptors, String sourceName) {
        return ParseTools.optimizeTree(new ExpressionCompiler(expression).compile(new ParserContext(imports, interceptors, sourceName)));
    }

    public static Serializable compileExpression(char[] expression) {
        return MVEL.compileExpression(expression, null, null, null);
    }

    public static Serializable compileExpression(char[] expression, Map<String, Object> imports) {
        return MVEL.compileExpression(expression, imports, null, null);
    }

    public static Serializable compileExpression(char[] expression, Map<String, Object> imports, Map<String, Interceptor> interceptors) {
        return MVEL.compileExpression(expression, imports, interceptors, null);
    }

    public static Serializable compileSetExpression(String expression) {
        return new CompiledSetExpression(expression.toCharArray());
    }

    public static Serializable compileSetExpression(char[] expression) {
        return new CompiledSetExpression(expression);
    }

    public static void executeSetExpression(Serializable compiledSet, Object ctx, Object value) {
        ((CompiledSetExpression)compiledSet).setValue(ctx, null, value);
    }

    public static void executeSetExpression(Serializable compiledSet, Object ctx, VariableResolverFactory vrf, Object value) {
        ((CompiledSetExpression)compiledSet).setValue(ctx, vrf, value);
    }

    public static Object executeExpression(Object compiledExpression) {
        return ((ExecutableStatement)compiledExpression).getValue(null, null);
    }

    public static Object executeExpression(Object compiledExpression, Object ctx, Map vars) {
        try {
            return ((ExecutableStatement)compiledExpression).getValue(ctx, new MapVariableResolverFactory(vars));
        }
        catch (EndWithValue end) {
            return ParseTools.handleParserEgress(end.getValue(), false);
        }
    }

    public static Object executeExpression(Object compiledExpression, Object ctx, VariableResolverFactory resolverFactory) {
        try {
            return ((ExecutableStatement)compiledExpression).getValue(ctx, resolverFactory);
        }
        catch (EndWithValue end) {
            return ParseTools.handleParserEgress(end.getValue(), false);
        }
    }

    public static Object executeExpression(Object compiledExpression, VariableResolverFactory factory) {
        try {
            return ((ExecutableStatement)compiledExpression).getValue(null, factory);
        }
        catch (EndWithValue end) {
            return ParseTools.handleParserEgress(end.getValue(), false);
        }
    }

    public static Object executeExpression(Object compiledExpression, Object ctx) {
        try {
            return ((ExecutableStatement)compiledExpression).getValue(ctx, null);
        }
        catch (EndWithValue end) {
            return ParseTools.handleParserEgress(end.getValue(), false);
        }
    }

    public static Object executeExpression(Object compiledExpression, Map vars) {
        try {
            return ((ExecutableStatement)compiledExpression).getValue(null, new MapVariableResolverFactory(vars));
        }
        catch (EndWithValue end) {
            return ParseTools.handleParserEgress(end.getValue(), false);
        }
    }

    public static <T> T executeExpression(Object compiledExpression, Object ctx, Map vars, Class<T> toType) {
        try {
            return DataConversion.convert(MVEL.executeExpression(compiledExpression, ctx, vars), toType);
        }
        catch (EndWithValue end) {
            return DataConversion.convert(ParseTools.handleParserEgress(end.getValue(), false), toType);
        }
    }

    public static <T> T executeExpression(Object compiledExpression, Map vars, Class<T> toType) {
        try {
            return DataConversion.convert(MVEL.executeExpression(compiledExpression, vars), toType);
        }
        catch (EndWithValue end) {
            return DataConversion.convert(ParseTools.handleParserEgress(end.getValue(), false), toType);
        }
    }

    public static <T> T executeExpression(Object compiledExpression, Object ctx, Class<T> toType) {
        try {
            return DataConversion.convert(MVEL.executeExpression(compiledExpression, ctx), toType);
        }
        catch (EndWithValue end) {
            return DataConversion.convert(ParseTools.handleParserEgress(end.getValue(), false), toType);
        }
    }

    public static Object[] executeAllExpression(Serializable[] compiledExpressions, Object ctx, VariableResolverFactory vars) {
        if (compiledExpressions == null) {
            return GetterAccessor.EMPTY;
        }
        Object[] o = new Object[compiledExpressions.length];
        int i = 0;
        while (i < compiledExpressions.length) {
            o[i] = MVEL.executeExpression((Object)compiledExpressions[i], ctx, vars);
            ++i;
        }
        return o;
    }

    public static Object executeDebugger(CompiledExpression expression, Object ctx, VariableResolverFactory vars) {
        try {
            return MVELRuntime.execute(true, expression, ctx, vars);
        }
        catch (EndWithValue e) {
            return ParseTools.handleParserEgress(e.getValue(), false);
        }
    }

    public static <T> T eval(char[] expression, Object ctx, Map vars, Class<T> toType) {
        try {
            return DataConversion.convert(new MVELInterpretedRuntime(expression, ctx, (Map<String, Object>)vars).parse(), toType);
        }
        catch (EndWithValue end) {
            return DataConversion.convert(ParseTools.handleParserEgress(end.getValue(), false), toType);
        }
    }

    public static <T> T eval(char[] expression, Object ctx, Class<T> toType) {
        try {
            return DataConversion.convert(new MVELInterpretedRuntime(expression, ctx).parse(), toType);
        }
        catch (EndWithValue end) {
            return DataConversion.convert(ParseTools.handleParserEgress(end.getValue(), false), toType);
        }
    }

    public static <T> T eval(String expression, Object ctx, Class<T> toType) {
        try {
            return DataConversion.convert(new MVELInterpretedRuntime(expression, ctx).parse(), toType);
        }
        catch (EndWithValue end) {
            return DataConversion.convert(ParseTools.handleParserEgress(end.getValue(), false), toType);
        }
    }

    public static <T> T eval(String expression, Object ctx, Map vars, Class<T> toType) {
        try {
            return DataConversion.convert(new MVELInterpretedRuntime(expression, ctx, (Map<String, Object>)vars).parse(), toType);
        }
        catch (EndWithValue end) {
            return DataConversion.convert(ParseTools.handleParserEgress(end.getValue(), false), toType);
        }
    }

    public static <T> T eval(char[] expression, Object ctx, VariableResolverFactory vars, Class<T> toType) {
        try {
            return DataConversion.convert(new MVELInterpretedRuntime(expression, ctx, vars).parse(), toType);
        }
        catch (EndWithValue end) {
            return DataConversion.convert(ParseTools.handleParserEgress(end.getValue(), false), toType);
        }
    }

    public static <T> T eval(String expression, Object ctx, VariableResolverFactory vars, Class<T> toType) {
        try {
            return DataConversion.convert(new MVELInterpretedRuntime(expression, ctx, vars).parse(), toType);
        }
        catch (EndWithValue end) {
            return DataConversion.convert(ParseTools.handleParserEgress(end.getValue(), false), toType);
        }
    }

    public static <T> T eval(String expression, Map vars, Class<T> toType) {
        try {
            return DataConversion.convert(new MVELInterpretedRuntime(expression, null, (Map<String, Object>)vars).parse(), toType);
        }
        catch (EndWithValue end) {
            return DataConversion.convert(ParseTools.handleParserEgress(end.getValue(), false), toType);
        }
    }

    public static <T> T eval(String expression, VariableResolverFactory vars, Class<T> toType) {
        try {
            return DataConversion.convert(new MVELInterpretedRuntime(expression, null, vars).parse(), toType);
        }
        catch (EndWithValue end) {
            return DataConversion.convert(ParseTools.handleParserEgress(end.getValue(), false), toType);
        }
    }

    public static <T> T eval(char[] expression, Map vars, Class<T> toType) {
        try {
            return DataConversion.convert(new MVELInterpretedRuntime(expression, null, (Map<String, Object>)vars).parse(), toType);
        }
        catch (EndWithValue end) {
            return DataConversion.convert(ParseTools.handleParserEgress(end.getValue(), false), toType);
        }
    }

    public static Object eval(char[] expression, Object ctx, Map vars) {
        try {
            return new MVELInterpretedRuntime(expression, ctx, (Map<String, Object>)vars).parse();
        }
        catch (EndWithValue end) {
            return ParseTools.handleParserEgress(end.getValue(), false);
        }
    }

    public static String evalToString(String expression, Object ctx) {
        try {
            return String.valueOf(MVEL.eval(expression, ctx));
        }
        catch (EndWithValue end) {
            return String.valueOf(ParseTools.handleParserEgress(end.getValue(), false));
        }
    }

    public static String evalToString(String expression, Map vars) {
        return String.valueOf(MVEL.eval(expression, vars));
    }

    public static String evalToString(String expression, Object ctx, Map vars) {
        try {
            return String.valueOf(MVEL.eval(expression, ctx, vars));
        }
        catch (EndWithValue end) {
            return String.valueOf(ParseTools.handleParserEgress(end.getValue(), false));
        }
    }

    public static Boolean evalToBoolean(String expression, Object ctx, Map vars) {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (Boolean)MVEL.eval(expression, ctx, vars, clazz);
    }

    public static Boolean evalToBoolean(String expression, Object ctx) {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (Boolean)MVEL.eval(expression, ctx, clazz);
    }

    public static Boolean evalToBoolean(String expression, Object ctx, VariableResolverFactory factory) {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (Boolean)MVEL.eval(expression, ctx, factory, clazz);
    }

    public static Boolean evalToBoolean(String expression, VariableResolverFactory factory) {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (Boolean)MVEL.eval(expression, factory, clazz);
    }

    public static Boolean evalToBoolean(String expression, Map vars) {
        return MVEL.evalToBoolean(expression, null, vars);
    }

    public static String parseMacros(String input, Map<String, Macro> macros) {
        MacroProcessor macroProcessor = new MacroProcessor();
        macroProcessor.setMacros(macros);
        return macroProcessor.parse(input);
    }

    public static String preprocess(char[] input, PreProcessor[] preprocessors) {
        char[] ex = input;
        PreProcessor[] preProcessorArray = preprocessors;
        int n = 0;
        int n2 = preProcessorArray.length;
        while (n < n2) {
            PreProcessor proc = preProcessorArray[n];
            ex = proc.parse(ex);
            ++n;
        }
        return new String(ex);
    }

    public static String preprocess(String input, PreProcessor[] preprocessors) {
        return MVEL.preprocess(input.toCharArray(), preprocessors);
    }

    public static Object getProperty(String property, Object ctx) {
        return ReflectiveAccessorOptimizer.get(property, ctx);
    }

    public static void setProperty(Object ctx, String property, Object value) {
        PropertyAccessor.set(ctx, property, value);
    }
}

