/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import java.util.HashMap;
import java.util.Iterator;
import org.mvel.CompileException;
import org.mvel.ExecutableStatement;
import org.mvel.ast.BlockNode;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.DefaultLocalVariableResolverFactory;
import org.mvel.util.ParseTools;

public class ForEachNode
extends BlockNode {
    protected String item;
    protected ExecutableStatement condition;
    protected ExecutableStatement compiledBlock;

    public ForEachNode(char[] condition, char[] block, int fields) {
        super(condition, fields);
        this.handleCond(condition);
        this.block = block;
        this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(block);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Class<?> clazz;
        HashMap<String, Object> locals = new HashMap<String, Object>();
        DefaultLocalVariableResolverFactory local = new DefaultLocalVariableResolverFactory(locals);
        local.setNextFactory(factory);
        Object ret = null;
        Object iterCond = this.condition.getValue(ctx, thisValue, factory);
        if (iterCond instanceof Iterable) {
            Iterator iterator = ((Iterable)iterCond).iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                locals.put(this.item, o);
                ret = this.compiledBlock.getValue(ctx, thisValue, local);
            }
        } else if (iterCond instanceof Object[]) {
            Object[] objectArray = (Object[])iterCond;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object o = objectArray[n];
                locals.put(this.item, o);
                ret = this.compiledBlock.getValue(ctx, thisValue, local);
                ++n;
            }
        }
        if (ret == null) {
            try {
                clazz = Class.forName("java.lang.Void");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } else {
            clazz = ret;
        }
        return clazz;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    private void handleCond(char[] condition) {
        int cursor = 0;
        while (cursor < condition.length && condition[cursor] != ':') {
            ++cursor;
        }
        if (cursor == condition.length || condition[cursor] != ':') {
            throw new CompileException("expected : in foreach");
        }
        this.item = new String(condition, 0, cursor).trim();
        this.condition = (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(condition, ++cursor));
    }
}

