/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.inject.Named;
import javax.inject.Qualifier;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.cdi.Mapper;
import org.mybatis.cdi.MyBatisBean;
import org.mybatis.cdi.MybatisCdiConfigurationException;
import org.mybatis.cdi.SessionFactoryProvider;

public class MybatisExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(MybatisExtension.class.getName());
    private final Set<BeanKey> sessionProducers = new HashSet<BeanKey>();
    private final Set<Type> mapperTypes = new HashSet<Type>();
    private final Set<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();

    protected <T> void processAnnotatedType(@Observes @WithAnnotations(value={Mapper.class}) ProcessAnnotatedType<T> pat) {
        AnnotatedType at = pat.getAnnotatedType();
        if (at.isAnnotationPresent(Mapper.class)) {
            LOGGER.log(Level.INFO, "MyBatis CDI Module - Found class with @Mapper-annotation: {0}", at.getJavaClass().getSimpleName());
            this.mapperTypes.add(at.getBaseType());
        }
    }

    protected <T, X> void processProducer(@Observes ProcessProducer<T, X> pp) {
        AnnotatedMember am = pp.getAnnotatedMember();
        boolean isAnnotated = am.isAnnotationPresent(SessionFactoryProvider.class);
        boolean isSqlSessionFactory = am.getBaseType().equals(SqlSessionFactory.class);
        Object[] logData = new Object[]{am.getJavaMember().getDeclaringClass().getSimpleName(), am.getJavaMember().getName()};
        if (isAnnotated && isSqlSessionFactory) {
            LOGGER.log(Level.INFO, "MyBatis CDI Module - SqlSessionFactory producer {0}.{1}", logData);
            this.sessionProducers.add(new BeanKey(SqlSession.class, am.getAnnotations()));
        } else if (isAnnotated && !isSqlSessionFactory) {
            LOGGER.log(Level.SEVERE, "MyBatis CDI Module - Invalid return type (Must be SqlSessionFactory): {0}.{1}", logData);
            pp.addDefinitionError((Throwable)new MybatisCdiConfigurationException(String.format("SessionFactoryProvider producers must return SqlSessionFactory (%s.%s)", logData[0], logData[1])));
        } else if (!isAnnotated && isSqlSessionFactory) {
            LOGGER.log(Level.WARNING, "MyBatis CDI Module - Ignored SqlSessionFactory producer because it is not annotated with @SessionFactoryProvider: {0}.{1}", logData);
        }
    }

    protected <X> void processInjectionTarget(@Observes ProcessInjectionTarget<X> event) {
        InjectionTarget it = event.getInjectionTarget();
        for (InjectionPoint ip : it.getInjectionPoints()) {
            this.injectionPoints.add(ip);
        }
    }

    protected void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        LOGGER.log(Level.INFO, "MyBatis CDI Module - Activated");
        HashSet<BeanKey> mappers = new HashSet<BeanKey>();
        HashSet<BeanKey> sessionTargets = new HashSet<BeanKey>();
        for (InjectionPoint ip : this.injectionPoints) {
            if (this.mapperTypes.contains(ip.getAnnotated().getBaseType())) {
                LOGGER.log(Level.INFO, "MyBatis CDI Module - Found a bean, which needs a Mapper {0}", new Object[]{ip.getAnnotated().getBaseType()});
                mappers.add(new BeanKey((Class)ip.getAnnotated().getBaseType(), ip.getAnnotated().getAnnotations()));
                continue;
            }
            if (!SqlSession.class.equals((Object)ip.getAnnotated().getBaseType())) continue;
            sessionTargets.add(new BeanKey((Class)ip.getAnnotated().getBaseType(), ip.getAnnotated().getAnnotations()));
        }
        this.injectionPoints.clear();
        for (BeanKey key : mappers) {
            LOGGER.log(Level.INFO, "MyBatis CDI Module - Managed Mapper dependency: {0}, {1}", new Object[]{key.getKey(), key.type.getName()});
            abd.addBean(key.createBean(bm));
        }
        this.mapperTypes.clear();
        for (BeanKey key : this.sessionProducers) {
            LOGGER.log(Level.INFO, "MyBatis CDI Module - Managed SqlSession: {0}, {1}", new Object[]{key.getKey(), key.type.getName()});
            abd.addBean(key.createBean(bm));
            sessionTargets.remove(key);
        }
        this.sessionProducers.clear();
        for (BeanKey key : sessionTargets) {
            LOGGER.log(Level.WARNING, "MyBatis CDI Module - Unmanaged SqlSession: {0}, {1}", new Object[]{key.getKey(), key.type.getName()});
        }
    }

    private static final class BeanKey
    implements Comparable<BeanKey> {
        private final String key;
        private final List<Annotation> qualifiers;
        private final Class<Type> type;
        private final String sqlSessionManagerName;

        public BeanKey(Class<Type> type, Set<Annotation> annotations) {
            this.type = type;
            this.qualifiers = this.sort(this.filterQualifiers(annotations));
            StringBuilder sb = new StringBuilder();
            String name = null;
            sb.append(type.getName());
            for (Annotation q : this.qualifiers) {
                if (q instanceof Named) {
                    name = ((Named)q).value();
                    continue;
                }
                sb.append(".").append(q.annotationType().getSimpleName());
            }
            if (name != null) {
                sb.append("_").append(name);
            }
            this.key = sb.toString();
            this.sqlSessionManagerName = name;
        }

        private Set<Annotation> filterQualifiers(Set<Annotation> annotations) {
            HashSet<Annotation> set = new HashSet<Annotation>();
            for (Annotation a : annotations) {
                if (!a.annotationType().isAnnotationPresent(Qualifier.class)) continue;
                set.add(a);
            }
            return set;
        }

        private List<Annotation> sort(Set<Annotation> annotations) {
            ArrayList<Annotation> list = new ArrayList<Annotation>(annotations);
            Collections.sort(list, new Comparator<Annotation>(){

                @Override
                public int compare(Annotation a, Annotation b) {
                    return a.getClass().getName().compareTo(b.getClass().getName());
                }
            });
            return list;
        }

        @Override
        public int compareTo(BeanKey o) {
            return this.key.compareTo(o.key);
        }

        public int hashCode() {
            int hash = 3;
            hash = 43 * hash + (this.key != null ? this.key.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BeanKey other = (BeanKey)obj;
            return !(this.key != null ? !this.key.equals(other.key) : other.key != null);
        }

        public Bean createBean(BeanManager bm) {
            return new MyBatisBean(this.key, this.type, new HashSet<Annotation>(this.qualifiers), this.sqlSessionManagerName);
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.key;
        }
    }
}

