/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.cdi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.cdi.CDIUtils;
import org.mybatis.cdi.MyBatisBean;

public class SerializableMapperProxy
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Object mapper;
    private final MyBatisBean bean;
    private final CreationalContext creationalContext;

    public SerializableMapperProxy(MyBatisBean bean, CreationalContext creationalContext) {
        this.bean = bean;
        this.creationalContext = creationalContext;
        this.mapper = this.getMapper();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.mapper, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private Object getMapper() {
        SqlSessionFactory factory = CDIUtils.findSqlSessionFactory(this.bean.sqlSessionFactoryName, this.bean.qualifiers, this.creationalContext);
        return CDIUtils.getRegistry(this.creationalContext).getManager(factory).getMapper(this.bean.type);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        this.mapper = this.getMapper();
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
    }
}

