/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.ClientCertificate;
import org.neo4j.driver.RotatingClientCertificateManager;
import org.neo4j.driver.internal.InternalClientCertificate;

public final class InternalRotatingClientCertificateManager
implements RotatingClientCertificateManager {
    private CompletionStage<ClientCertificate> clientCertificateStage;
    private InternalClientCertificate clientCertificate;

    public InternalRotatingClientCertificateManager(ClientCertificate clientCertificate) {
        Objects.requireNonNull(clientCertificate);
        this.updateState(clientCertificate);
    }

    @Override
    public synchronized CompletionStage<ClientCertificate> getClientCertificate() {
        if (this.clientCertificate != null) {
            CompletionStage<ClientCertificate> stage = this.clientCertificateStage;
            this.updateState(null);
            return stage;
        }
        return this.clientCertificateStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotate(ClientCertificate clientCertificate) {
        Objects.requireNonNull(clientCertificate);
        InternalRotatingClientCertificateManager internalRotatingClientCertificateManager = this;
        synchronized (internalRotatingClientCertificateManager) {
            this.updateState(clientCertificate);
        }
    }

    private void updateState(ClientCertificate clientCertificate) {
        this.clientCertificateStage = CompletableFuture.completedStage(clientCertificate);
        this.clientCertificate = (InternalClientCertificate)clientCertificate;
    }
}

