/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.summary.Plan;

public class InternalPlan<T extends Plan>
implements Plan {
    private final String operatorType;
    private final List<String> identifiers;
    private final Map<String, Value> arguments;
    private final List<T> children;
    private static final PlanCreator<Plan> EXPLAIN_PLAN = (operatorType, arguments, identifiers, children, originalPlanValue) -> new InternalPlan(operatorType, arguments, identifiers, children);
    public static final Function<Value, Plan> EXPLAIN_PLAN_FROM_VALUE = new Converter<Plan>(EXPLAIN_PLAN);

    protected InternalPlan(String operatorType, Map<String, Value> arguments, List<String> identifiers, List<T> children) {
        this.operatorType = operatorType;
        this.identifiers = identifiers;
        this.arguments = arguments;
        this.children = children;
    }

    @Override
    public String operatorType() {
        return this.operatorType;
    }

    @Override
    public List<String> identifiers() {
        return this.identifiers;
    }

    @Override
    public Map<String, Value> arguments() {
        return this.arguments;
    }

    public List<T> children() {
        return this.children;
    }

    public String toString() {
        return String.format("SimplePlanTreeNode{operatorType='%s', arguments=%s, identifiers=%s, children=%s}", this.operatorType, this.arguments, this.identifiers, this.children);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalPlan that = (InternalPlan)o;
        return this.operatorType.equals(that.operatorType) && this.arguments.equals(that.arguments) && this.identifiers.equals(that.identifiers) && this.children.equals(that.children);
    }

    public int hashCode() {
        int result = this.operatorType.hashCode();
        result = 31 * result + this.identifiers.hashCode();
        result = 31 * result + this.arguments.hashCode();
        result = 31 * result + this.children.hashCode();
        return result;
    }

    static interface PlanCreator<T extends Plan> {
        public T create(String var1, Map<String, Value> var2, List<String> var3, List<T> var4, Value var5);
    }

    static class Converter<T extends Plan>
    implements Function<Value, T> {
        private final PlanCreator<T> planCreator;

        public Converter(PlanCreator<T> planCreator) {
            this.planCreator = planCreator;
        }

        @Override
        public T apply(Value plan) {
            String operatorType = plan.get("operatorType").asString();
            Value argumentsValue = plan.get("args");
            Map<String, Value> arguments = argumentsValue.isNull() ? Collections.emptyMap() : argumentsValue.asMap(Values.ofValue());
            Value identifiersValue = plan.get("identifiers");
            List<String> identifiers = identifiersValue.isNull() ? Collections.emptyList() : identifiersValue.asList(Values.ofString());
            Value childrenValue = plan.get("children");
            List children = childrenValue.isNull() ? Collections.emptyList() : childrenValue.asList(this);
            return this.planCreator.create(operatorType, arguments, identifiers, children, plan);
        }
    }
}

