/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.time.DateTimeException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.connection.values.Node;
import org.neo4j.bolt.connection.values.Path;
import org.neo4j.bolt.connection.values.Segment;
import org.neo4j.bolt.connection.values.ValueFactory;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.internal.value.BoltValue;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.internal.value.UnsupportedDateTimeValue;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;

public class BoltValueFactory
implements ValueFactory {
    private static final BoltValueFactory INSTANCE = new BoltValueFactory();

    public static BoltValueFactory getInstance() {
        return INSTANCE;
    }

    private BoltValueFactory() {
    }

    public org.neo4j.bolt.connection.values.Value value(Object value) {
        return ((InternalValue)Values.value(value)).asBoltValue();
    }

    public Node node(long id, String elementId, Collection<String> labels, Map<String, org.neo4j.bolt.connection.values.Value> properties) {
        return new InternalNode(id, elementId, labels, this.toDriverMap(properties));
    }

    public org.neo4j.bolt.connection.values.Relationship relationship(long id, String elementId, long start, String startElementId, long end, String endElementId, String type, Map<String, org.neo4j.bolt.connection.values.Value> properties) {
        return new InternalRelationship(id, elementId, start, startElementId, end, endElementId, type, this.toDriverMap(properties));
    }

    public Segment segment(Node start, org.neo4j.bolt.connection.values.Relationship relationship, Node end) {
        return new InternalPath.SelfContainedSegment((InternalNode)start, (InternalRelationship)relationship, (InternalNode)end);
    }

    public Path path(List<Segment> segments, List<Node> nodes, List<org.neo4j.bolt.connection.values.Relationship> relationships) {
        List<Path.Segment> segments0 = segments.stream().map(segment -> (Path.Segment)segment).toList();
        List<org.neo4j.driver.types.Node> nodes0 = nodes.stream().map(node -> (org.neo4j.driver.types.Node)node).toList();
        List<Relationship> relationships0 = relationships.stream().map(relationship -> (Relationship)relationship).toList();
        return new InternalPath(segments0, nodes0, relationships0);
    }

    public org.neo4j.bolt.connection.values.Value isoDuration(long months, long days, long seconds, int nanoseconds) {
        return ((InternalValue)Values.isoDuration(months, days, seconds, nanoseconds)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value point(int srid, double x, double y) {
        return ((InternalValue)Values.point(srid, x, y)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value point(int srid, double x, double y, double z) {
        return ((InternalValue)Values.point(srid, x, y, z)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value unsupportedDateTimeValue(DateTimeException e) {
        return new UnsupportedDateTimeValue(e).asBoltValue();
    }

    public Map<String, org.neo4j.bolt.connection.values.Value> toBoltMap(Map<String, Value> map) {
        HashMap<String, BoltValue> result = new HashMap<String, BoltValue>(map.size());
        for (Map.Entry<String, Value> entry : map.entrySet()) {
            BoltValue boltValue = ((InternalValue)entry.getValue()).asBoltValue();
            result.put(entry.getKey(), boltValue);
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, Value> toDriverMap(Map<String, org.neo4j.bolt.connection.values.Value> map) {
        HashMap<String, Value> result = new HashMap<String, Value>(map.size());
        for (Map.Entry<String, org.neo4j.bolt.connection.values.Value> entry : map.entrySet()) {
            Value boltValue = ((BoltValue)entry.getValue()).asDriverValue();
            result.put(entry.getKey(), boltValue);
        }
        return Collections.unmodifiableMap(result);
    }
}

