/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.util.Map;
import java.util.function.Function;
import org.neo4j.bolt.connection.values.Type;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.util.Format;
import org.neo4j.driver.internal.value.BoltValue;
import org.neo4j.driver.internal.value.ValueAdapter;

public class MapValue
extends ValueAdapter {
    private final Map<String, Value> val;

    public MapValue(Map<String, Value> val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot construct MapValue from null");
        }
        this.val = val;
    }

    @Override
    public boolean isEmpty() {
        return this.val.isEmpty();
    }

    @Override
    public Map<String, Object> asObject() {
        return this.asMap(Values.ofObject());
    }

    @Override
    public Map<String, Object> asMap() {
        return Extract.map(this.val, Values.ofObject());
    }

    @Override
    public <T> Map<String, T> asMap(Function<Value, T> mapFunction) {
        return Extract.map(this.val, mapFunction);
    }

    @Override
    public int size() {
        return this.val.size();
    }

    @Override
    public boolean containsKey(String key) {
        return this.val.containsKey(key);
    }

    @Override
    public Iterable<String> keys() {
        return this.val.keySet();
    }

    @Override
    public Iterable<Value> values() {
        return this.val.values();
    }

    @Override
    public <T> Iterable<T> values(Function<Value, T> mapFunction) {
        return Extract.map(this.val, mapFunction).values();
    }

    @Override
    public Value get(String key) {
        Value value = this.val.get(key);
        return value == null ? Values.NULL : value;
    }

    @Override
    public String toString() {
        return Format.formatPairs(this.asMap(Values.ofValue()));
    }

    @Override
    public org.neo4j.driver.types.Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.MAP();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapValue values = (MapValue)o;
        return this.val.equals(values.val);
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public BoltValue asBoltValue() {
        return new BoltValue(this, Type.MAP);
    }
}

