/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.ExposesPatternLengthAccessors;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipPattern;

@API(status=API.Status.STABLE, since="1.0")
public interface ExposesRelationships<T extends RelationshipPattern & ExposesPatternLengthAccessors<?>> {
    @NotNull
    @Contract(pure=true)
    public T relationshipTo(Node var1, String ... var2);

    @NotNull
    @Contract(pure=true)
    public T relationshipFrom(Node var1, String ... var2);

    @NotNull
    @Contract(pure=true)
    public T relationshipBetween(Node var1, String ... var2);

    default public T relationshipWith(Node other, Relationship.Direction direction, String ... types) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Relationship.Direction.LTR -> this.relationshipTo(other, types);
            case Relationship.Direction.RTL -> this.relationshipFrom(other, types);
            case Relationship.Direction.UNI -> this.relationshipBetween(other, types);
        };
    }
}

