/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.internal;

import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.ast.Visitor;

@API(status=API.Status.INTERNAL, since="1.0")
public final class RelationshipPatternCondition
implements Condition {
    private final boolean not;
    private final RelationshipPattern pathPattern;

    public static RelationshipPatternCondition of(RelationshipPattern pathPattern) {
        return new RelationshipPatternCondition(false, pathPattern);
    }

    public static RelationshipPatternCondition not(RelationshipPattern pathPattern) {
        return new RelationshipPatternCondition(true, pathPattern);
    }

    private RelationshipPatternCondition(boolean not, RelationshipPattern pathPattern) {
        this.not = not;
        this.pathPattern = pathPattern;
    }

    @Override
    @NotNull
    public Condition not() {
        return new RelationshipPatternCondition(!this.not, this.pathPattern);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        if (this.not) {
            Operator.NOT.accept(visitor);
        }
        this.pathPattern.accept(visitor);
        visitor.leave(this);
    }
}

