/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.kernel.impl.util.AbstractPrimitiveIntIterator;
import org.neo4j.kernel.impl.util.PrimitiveIntIterator;

public final class DiffApplyingPrimitiveIntIterator
extends AbstractPrimitiveIntIterator {
    private final PrimitiveIntIterator source;
    private final Iterator<?> addedElementsIterator;
    private final Set<?> addedElements;
    private final Set<?> removedElements;
    Phase phase;

    public DiffApplyingPrimitiveIntIterator(PrimitiveIntIterator source, Set<?> addedElements, Set<?> removedElements) {
        this.source = source;
        this.addedElements = addedElements;
        this.addedElementsIterator = addedElements.iterator();
        this.removedElements = removedElements;
        this.phase = Phase.FILTERED_SOURCE;
        this.computeNext();
    }

    @Override
    protected void computeNext() {
        this.phase.computeNext(this);
    }

    private void computeNextFromSourceAndFilter() {
        boolean hasNext = this.source.hasNext();
        while (hasNext) {
            int value = this.source.next();
            this.next(value);
            if (!this.removedElements.contains(value) && !this.addedElements.contains(value)) {
                return;
            }
            hasNext = this.source.hasNext();
        }
        this.transitionToAddedElements();
    }

    private void transitionToAddedElements() {
        this.phase = !this.addedElementsIterator.hasNext() ? Phase.NO_ADDED_ELEMENTS : Phase.ADDED_ELEMENTS;
        this.computeNext();
    }

    private void computeNextFromAddedElements() {
        if (this.addedElementsIterator.hasNext()) {
            this.next((Integer)this.addedElementsIterator.next());
        } else {
            this.endReached();
        }
    }

    private static enum Phase {
        FILTERED_SOURCE{

            @Override
            void computeNext(DiffApplyingPrimitiveIntIterator self) {
                self.computeNextFromSourceAndFilter();
            }
        }
        ,
        ADDED_ELEMENTS{

            @Override
            void computeNext(DiffApplyingPrimitiveIntIterator self) {
                self.computeNextFromAddedElements();
            }
        }
        ,
        NO_ADDED_ELEMENTS{

            @Override
            void computeNext(DiffApplyingPrimitiveIntIterator self) {
                self.endReached();
            }
        };


        abstract void computeNext(DiffApplyingPrimitiveIntIterator var1);
    }
}

