/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.transaction;

public interface Transaction
extends AutoCloseable {
    public void rollback();

    public void commit();

    public boolean canCommit();

    default public boolean canRollback() {
        Status status = this.status();
        return status == Status.ROLLBACK_PENDING || status == Status.COMMIT_PENDING || status == Status.OPEN || status == Status.PENDING;
    }

    public Status status();

    public boolean isReadOnly();

    public Type type();

    @Override
    public void close();

    public static enum Status {
        OPEN,
        PENDING,
        ROLLEDBACK,
        COMMITTED,
        CLOSED,
        ROLLBACK_PENDING,
        COMMIT_PENDING;

    }

    public static enum Type {
        READ_ONLY,
        READ_WRITE;

    }
}

