/*
 * Copyright (c) 2002-2018 "Neo Technology,"
 * Network Engine for Objects in Lund AB [http://neotechnology.com]
 *
 * This product is licensed to you under the Apache License, Version 2.0 (the "License").
 * You may not use this product except in compliance with the License.
 *
 * This product may include a number of subcomponents with
 * separate copyright notices and license terms. Your use of the source
 * code for these subcomponents is subject to the terms and
 *  conditions of the subcomponent's license, as noted in the LICENSE file.
 */

package org.neo4j.ogm.session.request;

import java.util.Map;

import org.neo4j.ogm.request.OptimisticLockingConfig;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;

/**
 * @author Luanne Misquitta
 */
public class RowStatementFactory implements StatementFactory {

    @Override
    public Statement statement(String statement, Map<String, Object> parameters) {
        return statement(statement, parameters, null);
    }

    @Override
    public RowDataStatement statement(String statement, Map<String, Object> parameters,
        OptimisticLockingConfig config) {

        return new RowDataStatement(statement, parameters, config);
    }
}
