/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.delegates.SessionDelegate;

public class LoadByInstancesDelegate
extends SessionDelegate {
    public LoadByInstancesDelegate(Neo4jSession session) {
        super(session);
    }

    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, Pagination pagination, int depth) {
        if (objects == null || objects.isEmpty()) {
            return objects;
        }
        ClassInfo commonClassInfo = this.findCommonClassInfo(objects);
        LinkedHashSet<Serializable> ids = new LinkedHashSet<Serializable>();
        for (T o : objects) {
            FieldInfo idField = commonClassInfo.hasPrimaryIndexField() ? commonClassInfo.primaryIndexField() : commonClassInfo.identityField();
            ids.add((Serializable)idField.readProperty(o));
        }
        return this.session.loadAll(commonClassInfo.getUnderlyingClass(), ids, sortOrder, pagination, depth);
    }

    public <T> Collection<T> loadAll(Collection<T> objects) {
        return this.loadAll(objects, new SortOrder(), null, 1);
    }

    public <T> Collection<T> loadAll(Collection<T> objects, int depth) {
        return this.loadAll(objects, new SortOrder(), null, depth);
    }

    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder) {
        return this.loadAll(objects, sortOrder, null, 1);
    }

    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, int depth) {
        return this.loadAll(objects, sortOrder, null, depth);
    }

    public <T> Collection<T> loadAll(Collection<T> objects, Pagination pagination) {
        return this.loadAll(objects, new SortOrder(), pagination, 1);
    }

    public <T> Collection<T> loadAll(Collection<T> objects, Pagination pagination, int depth) {
        return this.loadAll(objects, new SortOrder(), pagination, depth);
    }

    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(objects, sortOrder, pagination, 1);
    }

    private <T> ClassInfo findCommonClassInfo(Collection<T> objects) {
        MetaData metaData = this.session.metaData();
        Set infos = objects.stream().map(Object::getClass).distinct().map(metaData::classInfo).map(LoadByInstancesDelegate::getRootClassInfo).collect(Collectors.toSet());
        if (infos.size() != 1) {
            throw new MappingException("Can't find single supertype for " + infos);
        }
        return (ClassInfo)infos.iterator().next();
    }

    private static ClassInfo getRootClassInfo(ClassInfo classInfo) {
        ClassInfo current = classInfo;
        while (current.directSuperclass() != null) {
            current = current.directSuperclass();
        }
        return current;
    }
}

