/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.neo4j.ogm.metadata.schema.Node;
import org.neo4j.ogm.metadata.schema.Relationship;

class NodeImpl
implements Node {
    private final String label;
    private final Map<String, Relationship> relationships = new HashMap<String, Relationship>();
    private final Map<String, Set<String>> typesByRelationship = new HashMap<String, Set<String>>();

    NodeImpl(String label) {
        this.label = label;
    }

    @Override
    public Optional<String> label() {
        return Optional.ofNullable(this.label);
    }

    @Override
    public Map<String, Relationship> relationships() {
        return this.relationships;
    }

    @Override
    public Collection<String> types(String relationshipName) {
        return this.typesByRelationship.getOrDefault(relationshipName, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRelationship(String name, Relationship relationship) {
        if (this.relationships.containsKey(name)) {
            Relationship existingRelationship = this.relationships.get(name);
            Node existingStart = existingRelationship.start();
            Node existingEnd = existingRelationship.other(existingStart);
            Node newStart = relationship.start();
            Node newEnd = relationship.other(newStart);
            if (existingStart.equals(newStart) && existingEnd.equals(newEnd)) {
                Set types = this.typesByRelationship.computeIfAbsent(name, key -> new HashSet());
                types.add(relationship.type());
                return;
            }
        }
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            this.relationships.put(name, relationship);
            this.typesByRelationship.put(name, new HashSet<String>(Arrays.asList(relationship.type())));
        }
    }

    public String toString() {
        return "NodeImpl{label='" + this.label + "}";
    }
}

