/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.EOFException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageParser;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.ParsingException;

public class WarcParser
extends MessageParser {
    private int entryState;
    private int cs;
    private long position;
    private byte[] buf = new byte[256];
    private int bufPos;
    private int endOfText;
    private int major;
    private int minor;
    private String name;
    private String protocol = "WARC";
    private Map<String, List<String>> headerMap;
    private static final DateTimeFormatter arcTimeFormat = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final byte[] _warc_actions = WarcParser.init__warc_actions_0();
    private static final short[] _warc_key_offsets = WarcParser.init__warc_key_offsets_0();
    private static final char[] _warc_trans_keys = WarcParser.init__warc_trans_keys_0();
    private static final byte[] _warc_single_lengths = WarcParser.init__warc_single_lengths_0();
    private static final byte[] _warc_range_lengths = WarcParser.init__warc_range_lengths_0();
    private static final short[] _warc_index_offsets = WarcParser.init__warc_index_offsets_0();
    private static final byte[] _warc_indicies = WarcParser.init__warc_indicies_0();
    private static final byte[] _warc_trans_targs = WarcParser.init__warc_trans_targs_0();
    private static final byte[] _warc_trans_actions = WarcParser.init__warc_trans_actions_0();
    static final int warc_start = 1;
    static final int warc_first_final = 76;
    static final int warc_error = 0;
    static final int warc_en_warc_fields = 67;
    static final int warc_en_any_header = 1;

    public static WarcParser newWarcFieldsParser() {
        return new WarcParser(67);
    }

    public WarcParser() {
        this(1);
    }

    private WarcParser(int entryState) {
        this.entryState = entryState;
        this.reset();
    }

    public void reset() {
        this.cs = this.entryState;
        this.position = 0L;
        this.bufPos = 0;
        this.endOfText = 0;
        this.major = 0;
        this.minor = 0;
        this.name = null;
        this.headerMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        if (this.buf.length > 4096) {
            this.buf = new byte[4096];
        }
    }

    public boolean isFinished() {
        return this.cs >= 76;
    }

    public boolean isError() {
        return this.cs == 0;
    }

    /*
     * Unable to fully structure code
     */
    public void parse(ByteBuffer data) {
        p = data.position();
        pe = data.limit();
        _trans = 0;
        _goto_targ = 0;
        block21: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block21;
                    }
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block21;
                    }
                }
                case 1: {
                    _keys = WarcParser._warc_key_offsets[this.cs];
                    _trans = WarcParser._warc_index_offsets[this.cs];
                    _klen = WarcParser._warc_single_lengths[this.cs];
                    if (_klen <= 0) ** GOTO lbl33
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if ((data.get(p) & 255) < WarcParser._warc_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if ((data.get(p) & 255) > WarcParser._warc_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl47
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl33:
                    // 2 sources

                    if ((_klen = WarcParser._warc_range_lengths[this.cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if ((data.get(p) & 255) < WarcParser._warc_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if ((data.get(p) & 255) > WarcParser._warc_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl47
                        }
                        _trans += _klen;
                    }
lbl47:
                    // 5 sources

                    _trans = WarcParser._warc_indicies[_trans];
                    this.cs = WarcParser._warc_trans_targs[_trans];
                    if (WarcParser._warc_trans_actions[_trans] != 0) {
                        _acts = WarcParser._warc_trans_actions[_trans];
                        _nacts = WarcParser._warc_actions[_acts++];
                        while (_nacts-- > 0) {
                            switch (WarcParser._warc_actions[_acts++]) {
                                case 0: {
                                    this.push(data.get(p));
                                    break;
                                }
                                case 1: {
                                    this.major = this.major * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 2: {
                                    this.minor = this.minor * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 3: {
                                    this.endOfText = this.bufPos;
                                    break;
                                }
                                case 4: {
                                    if (this.bufPos <= 0) break;
                                    this.bufPos = this.endOfText;
                                    this.push((byte)32);
                                    break;
                                }
                                case 5: {
                                    this.name = new String(this.buf, 0, this.bufPos, StandardCharsets.US_ASCII);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 6: {
                                    value = new String(this.buf, 0, this.endOfText, StandardCharsets.UTF_8);
                                    this.headerMap.computeIfAbsent(this.name, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parse$0(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(value);
                                    this.bufPos = 0;
                                    this.endOfText = 0;
                                    break;
                                }
                                case 7: {
                                    url = new String(this.buf, 0, this.bufPos, StandardCharsets.ISO_8859_1);
                                    if (url.startsWith("filedesc://")) {
                                        this.setHeader("WARC-Type", "warcinfo");
                                        this.setHeader("WARC-Filename", url.substring("filedesc://".length()));
                                        this.setHeader("Content-Type", "text/plain");
                                    } else if (url.startsWith("dns:")) {
                                        this.setHeader("WARC-Type", "response");
                                        this.setHeader("Content-Type", "text/dns");
                                        this.setHeader("WARC-Target-URI", url);
                                    } else {
                                        this.setHeader("WARC-Type", "response");
                                        this.setHeader("Content-Type", "application/http;msgtype=response");
                                        this.setHeader("WARC-Target-URI", url);
                                    }
                                    this.bufPos = 0;
                                    break;
                                }
                                case 8: {
                                    this.setHeader("WARC-IP-Address", new String(this.buf, 0, this.bufPos, StandardCharsets.US_ASCII));
                                    this.bufPos = 0;
                                    break;
                                }
                                case 9: {
                                    arcDate = new String(this.buf, 0, this.bufPos, StandardCharsets.US_ASCII);
                                    instant = LocalDateTime.parse(arcDate, WarcParser.arcTimeFormat).toInstant(ZoneOffset.UTC);
                                    this.setHeader("WARC-Date", instant.toString());
                                    this.bufPos = 0;
                                    break;
                                }
                                case 10: {
                                    this.bufPos = 0;
                                    break;
                                }
                                case 11: {
                                    this.setHeader("Content-Length", new String(this.buf, 0, this.bufPos, StandardCharsets.US_ASCII));
                                    this.bufPos = 0;
                                    break;
                                }
                                case 12: {
                                    this.protocol = "ARC";
                                    this.major = 1;
                                    this.minor = 1;
                                    break;
                                }
                                case 13: {
                                    ++p;
                                    _goto_targ = 5;
                                    continue block21;
                                }
                            }
                        }
                    }
                }
                case 2: {
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block21;
                    }
                    if (++p == pe) break block21;
                    _goto_targ = 1;
                    continue block21;
                }
            }
            break;
        }
        this.position += (long)(p - data.position());
        data.position(p);
    }

    public boolean parse(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int n;
        do {
            this.parse(buffer);
            if (this.isFinished()) {
                return true;
            }
            if (this.isError()) {
                throw new ParsingException("invalid WARC record at position " + this.position + ": " + WarcParser.getErrorContext(buffer, (int)this.position, 40));
            }
            buffer.compact();
            n = channel.read(buffer);
            buffer.flip();
        } while (n >= 0);
        if (this.position > 0L) {
            throw new EOFException();
        }
        return false;
    }

    private void push(byte b) {
        if (this.bufPos >= this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
        }
        this.buf[this.bufPos++] = b;
    }

    public MessageHeaders headers() {
        return new MessageHeaders(this.headerMap);
    }

    public MessageVersion version() {
        return new MessageVersion(this.protocol, this.major, this.minor);
    }

    public long position() {
        return this.position;
    }

    private void setHeader(String name, String value) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        this.headerMap.put(name, list);
    }

    private static byte[] init__warc_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 13, 2, 0, 10, 2, 3, 0, 2, 4, 0, 2, 6, 0, 3, 11, 12, 13};
    }

    private static short[] init__warc_key_offsets_0() {
        return new short[]{0, 0, 3, 4, 5, 6, 7, 9, 12, 14, 17, 18, 34, 35, 51, 57, 58, 76, 82, 88, 94, 97, 99, 101, 104, 106, 109, 111, 114, 116, 119, 121, 123, 125, 127, 129, 131, 133, 135, 137, 139, 141, 143, 145, 147, 148, 164, 166, 169, 184, 199, 217, 220, 237, 253, 268, 275, 278, 283, 287, 290, 291, 294, 295, 298, 299, 302, 303, 319, 320, 336, 342, 343, 361, 367, 373, 379, 379};
    }

    private static char[] init__warc_trans_keys_0() {
        return new char[]{'W', 'a', 'z', 'A', 'R', 'C', '/', '0', '9', '.', '0', '9', '0', '9', '\r', '0', '9', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '!', ':', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '\u007f', '\u0000', '\u001f', '\n', '\t', '\r', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '\u007f', '\u0000', '\u001f', '\t', '\r', ' ', '\u007f', '\u0000', '\u001f', '\t', '\r', ' ', '\u007f', '\u0000', '\u001f', ':', 'a', 'z', '\n', ' ', '0', '9', '.', '0', '9', '0', '9', '.', '0', '9', '0', '9', '.', '0', '9', '0', '9', ' ', '0', '9', '0', '9', '0', '9', '0', '9', '0', '9', '0', '9', '0', '9', '0', '9', '0', '9', '0', '9', '0', '9', '0', '9', '0', '9', '0', '9', '0', '9', ' ', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '0', '9', '\n', '0', '9', ' ', '!', '/', '|', '~', '#', '\'', '*', '+', '-', '9', 'A', 'Z', '^', 'z', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', '!', ';', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', ';', '\t', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '!', '=', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\"', '|', '~', '!', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\"', '\\', ' ', '~', '\u0080', '\u00ff', '\t', ' ', ';', '\t', ' ', ';', '0', '9', '\u0000', '\u00bf', '\u00c2', '\u00f4', ' ', '0', '9', ' ', '.', '0', '9', '.', '.', '0', '9', '.', '.', '0', '9', '.', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '!', ':', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '\u007f', '\u0000', '\u001f', '\n', '\t', '\r', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '\u007f', '\u0000', '\u001f', '\t', '\r', ' ', '\u007f', '\u0000', '\u001f', '\t', '\r', ' ', '\u007f', '\u0000', '\u001f', '\u0000'};
    }

    private static byte[] init__warc_single_lengths_0() {
        return new byte[]{0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 4, 1, 4, 4, 1, 6, 4, 4, 4, 1, 2, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 4, 0, 1, 5, 3, 6, 3, 5, 4, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 4, 4, 1, 6, 4, 4, 4, 0, 0};
    }

    private static byte[] init__warc_range_lengths_0() {
        return new byte[]{0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 6, 0, 6, 1, 0, 6, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 6, 1, 1, 5, 6, 6, 0, 6, 6, 6, 2, 0, 1, 2, 1, 0, 1, 0, 1, 0, 1, 0, 6, 0, 6, 1, 0, 6, 1, 1, 1, 0, 0};
    }

    private static short[] init__warc_index_offsets_0() {
        return new short[]{0, 0, 3, 5, 7, 9, 11, 13, 16, 18, 21, 23, 34, 36, 47, 53, 55, 68, 74, 80, 86, 89, 92, 94, 97, 99, 102, 104, 107, 109, 112, 114, 116, 118, 120, 122, 124, 126, 128, 130, 132, 134, 136, 138, 140, 142, 153, 155, 158, 169, 179, 192, 196, 208, 219, 229, 235, 239, 244, 247, 250, 252, 255, 257, 260, 262, 265, 267, 278, 280, 291, 297, 299, 312, 318, 324, 330, 331};
    }

    private static byte[] init__warc_indicies_0() {
        return new byte[]{0, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 7, 1, 9, 1, 10, 9, 1, 11, 1, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 1, 14, 1, 13, 15, 13, 13, 13, 13, 13, 13, 13, 13, 1, 16, 17, 16, 1, 1, 18, 19, 1, 20, 21, 20, 22, 22, 22, 22, 22, 22, 22, 22, 22, 1, 20, 23, 20, 1, 1, 24, 25, 26, 25, 1, 1, 18, 27, 17, 27, 1, 1, 18, 28, 2, 1, 1, 29, 28, 30, 1, 31, 32, 1, 33, 1, 34, 35, 1, 36, 1, 37, 38, 1, 39, 1, 40, 41, 1, 42, 1, 43, 1, 44, 1, 45, 1, 46, 1, 47, 1, 48, 1, 49, 1, 50, 1, 51, 1, 52, 1, 53, 1, 54, 1, 55, 1, 56, 1, 57, 58, 58, 58, 58, 58, 58, 58, 58, 58, 1, 59, 1, 60, 59, 1, 57, 58, 61, 58, 58, 58, 58, 58, 58, 58, 1, 62, 62, 62, 62, 62, 62, 62, 62, 62, 1, 63, 64, 62, 65, 62, 62, 62, 62, 62, 62, 62, 62, 1, 63, 63, 65, 1, 65, 65, 66, 66, 66, 66, 66, 66, 66, 66, 66, 1, 66, 67, 66, 66, 66, 66, 66, 66, 66, 66, 1, 68, 62, 62, 62, 62, 62, 62, 62, 62, 1, 68, 69, 70, 68, 68, 1, 63, 64, 65, 1, 63, 63, 65, 59, 1, 68, 68, 1, 40, 71, 1, 40, 1, 37, 72, 1, 37, 1, 34, 73, 1, 34, 1, 31, 74, 1, 31, 1, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 1, 77, 1, 76, 78, 76, 76, 76, 76, 76, 76, 76, 76, 1, 79, 80, 79, 1, 1, 81, 82, 1, 83, 84, 83, 85, 85, 85, 85, 85, 85, 85, 85, 85, 1, 83, 86, 83, 1, 1, 87, 88, 89, 88, 1, 1, 81, 90, 80, 90, 1, 1, 81, 1, 1, 0};
    }

    private static byte[] init__warc_trans_targs_0() {
        return new byte[]{2, 0, 20, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 76, 14, 14, 15, 18, 16, 17, 12, 13, 15, 18, 19, 15, 19, 21, 22, 23, 24, 65, 25, 26, 63, 27, 28, 61, 29, 30, 59, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 48, 47, 76, 49, 50, 51, 57, 52, 53, 54, 55, 56, 58, 60, 62, 64, 66, 68, 69, 77, 70, 70, 71, 74, 72, 73, 68, 69, 71, 74, 75, 71, 75};
    }

    private static byte[] init__warc_trans_actions_0() {
        return new byte[]{0, 0, 1, 0, 0, 0, 0, 3, 0, 5, 0, 0, 0, 1, 23, 11, 0, 0, 1, 0, 0, 13, 34, 9, 31, 28, 7, 1, 1, 15, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 17, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 19, 21, 1, 1, 37, 1, 1, 1, 25, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 11, 0, 0, 1, 0, 0, 13, 34, 9, 31, 28, 7, 1};
    }

    private static /* synthetic */ List lambda$parse$0(String n) {
        return new ArrayList();
    }
}

