/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.Channels;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.LengthedBody;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcPayload;
import org.netpreserve.jwarc.WarcRecord;

public class WarcRevisit
extends WarcCaptureRecord {
    public static final URI IDENTICAL_PAYLOAD_DIGEST_1_0 = URI.create("http://netpreserve.org/warc/1.0/revisit/identical-payload-digest");
    public static final URI IDENTICAL_PAYLOAD_DIGEST_1_1 = URI.create("http://netpreserve.org/warc/1.1/revisit/identical-payload-digest");
    public static final URI SERVER_NOT_MODIFIED_1_0 = URI.create("http://netpreserve.org/warc/1.0/revisit/server-not-modified");
    public static final URI SERVER_NOT_MODIFIED_1_1 = URI.create("http://netpreserve.org/warc/1.1/revisit/server-not-modified");
    private HttpResponse http;

    WarcRevisit(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    public HttpResponse http() throws IOException {
        if (this.http == null) {
            MessageBody body = this.body();
            if (body.position() != 0L) {
                throw new IllegalStateException("http() cannot be called after reading from body");
            }
            if (body instanceof LengthedBody) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                LengthedBody lengthed = (LengthedBody)body;
                this.http = HttpResponse.parseWithoutBody(lengthed.discardPushbackOnRead(), Channels.newChannel(baos));
                lengthed.pushback(baos.toByteArray());
            } else {
                this.http = HttpResponse.parseWithoutBody(body, null);
            }
        }
        return this.http;
    }

    @Override
    public Optional<WarcPayload> payload() throws IOException {
        return Optional.empty();
    }

    public Optional<URI> refersToTargetURI() {
        return this.headers().sole("WARC-Refers-To-Target-URI").map(URI::create);
    }

    public Optional<Instant> refersToDate() {
        return this.headers().sole("WARC-Refers-To-Date").map(Instant::parse);
    }

    public URI profile() {
        return this.headers().sole("WARC-Profile").map(URI::create).get();
    }

    public Optional<URI> refersTo() {
        return this.headers().sole("WARC-Refers-To").map(WarcRecord::parseRecordID);
    }

    public static class Builder
    extends WarcCaptureRecord.AbstractBuilder<WarcRevisit, Builder> {
        @Deprecated
        public Builder(URI profile) {
            super("revisit");
            this.setHeader("WARC-Profile", profile.toString());
        }

        public Builder(URI targetURI, URI profile) {
            super("revisit");
            this.setHeader("WARC-Target-URI", targetURI.toString());
            this.setHeader("WARC-Profile", profile.toString());
        }

        @Override
        public WarcRevisit build() {
            return this.build(WarcRevisit::new);
        }

        public Builder refersTo(URI recordId) {
            return (Builder)this.setHeader("WARC-Refers-To", WarcRecord.formatId(recordId));
        }

        public Builder refersTo(UUID recordId) {
            return (Builder)this.setHeader("WARC-Refers-To", WarcRecord.formatId(recordId));
        }

        public Builder refersTo(URI recordId, URI targetURI, Instant date) {
            this.setHeader("WARC-Refers-To-Target-URI", targetURI.toString());
            this.setHeader("WARC-Refers-To-Date", date.toString());
            return this.refersTo(recordId);
        }

        public Builder refersTo(UUID recordId, URI targetURI, Instant date) {
            this.setHeader("WARC-Refers-To-Target-URI", targetURI.toString());
            this.setHeader("WARC-Refers-To-Date", date.toString());
            return this.refersTo(recordId);
        }
    }
}

