/*
 * Decompiled with CFR 0.152.
 */
package hero.client.events;

import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JMSServicesClient {
    private static JMSServicesClient jms = null;
    private static String topicName = "testTopic";
    private static Context jndiContext = null;
    private static TopicConnectionFactory topicConnectionFactory = null;
    private static TopicSession topicSession = null;
    private static Topic topic = null;
    private static TopicConnection topicConnection = null;
    private static TopicSubscriber topicSubscriber = null;
    private static TopicPublisher topicPublisher = null;
    private static TextMessage message = null;
    private static ObjectMessage omessage = null;
    private static InputStreamReader inputStreamReader = null;

    public JMSServicesClient() throws Exception {
        try {
            jndiContext = new InitialContext();
        }
        catch (NamingException e) {
            throw new Exception(e.getMessage(), e);
        }
        try {
            topicConnectionFactory = (TopicConnectionFactory)jndiContext.lookup("JTCF");
            topic = (Topic)jndiContext.lookup(topicName);
        }
        catch (NamingException e) {
            System.out.println("JNDI lookup failed: " + e.toString());
            throw new Exception(e.getMessage(), e);
        }
        try {
            topicConnection = topicConnectionFactory.createTopicConnection();
            topicSession = topicConnection.createTopicSession(false, 1);
        }
        catch (JMSException e) {
            System.out.println("Exception occurred: " + e.toString());
        }
    }

    public static JMSServicesClient getInstance() throws Exception {
        if (jms == null) {
            jms = new JMSServicesClient();
        }
        return jms;
    }

    public void createSubscription(MessageListener listener, String evt) throws Exception {
        try {
            topicSubscriber = topicSession.createSubscriber(topic, evt, false);
            topicSubscriber.setMessageListener(listener);
            topicConnection.start();
        }
        catch (JMSException e) {
            e.printStackTrace();
            System.out.println("Exception occurred: " + e.toString());
        }
    }

    public static Hashtable getEvt(Message message) throws JMSException {
        Enumeration keys = message.getPropertyNames();
        Hashtable<String, Object> evt = new Hashtable<String, Object>();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            evt.put(key, message.getObjectProperty(key));
        }
        return evt;
    }

    public static Serializable getEvtObject(Message message) throws JMSException {
        return ((ObjectMessage)message).getObject();
    }

    public void closeConnection() {
        if (topicConnection != null) {
            try {
                topicConnection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

