/*
 * Decompiled with CFR 0.152.
 */
package hero.client.grapheditor;

import com.jgraph.JGraph;
import com.jgraph.graph.CellView;
import com.jgraph.graph.DefaultGraphModel;
import com.jgraph.graph.EdgeView;
import com.jgraph.graph.GraphModel;
import hero.client.grapheditor.WFGraph;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class GPGraphTools {
    public CostFunction createDefaultCostFunction() {
        return new DefaultCostFunction();
    }

    public int getComponentCount(WFGraph graph) {
        GraphModel m = graph.getModel();
        UnionFind uf = new UnionFind();
        Object[] all = graph.getAll();
        Object[] v = graph.getVertices(all);
        for (int i = 0; i < v.length; ++i) {
            uf.find(v[i]);
        }
        Object[] e = graph.getEdges(all);
        for (int i = 0; i < e.length; ++i) {
            Object source = graph.getSourceVertex(e[i]);
            Object target = graph.getTargetVertex(e[i]);
            uf.union(uf.find(source), uf.find(target));
        }
        return uf.getSetCount();
    }

    public Object[] getShortestPath(WFGraph graph, Object from, Object to, CostFunction cf) {
        if (cf == null) {
            cf = this.createDefaultCostFunction();
        }
        GraphModel model = graph.getModel();
        PriorityQueue q = new PriorityQueue();
        Hashtable<Object, Object> pred = new Hashtable<Object, Object>();
        q.setPrio(from, 0.0);
        Object[] all = graph.getAll();
        int jmax = graph.getVertices(all).length;
        for (int j = 0; j < jmax; ++j) {
            double prio = q.getPrio();
            Object obj = q.pop();
            if (obj == to) break;
            Object[] tmp = new Object[]{obj};
            Object[] e = DefaultGraphModel.getEdges((GraphModel)model, (Object[])tmp).toArray();
            if (e != null) {
                for (int i = 0; i < e.length; ++i) {
                    Object neighbour = graph.getNeighbour(e[i], obj);
                    double newPrio = prio + cf.getCost(graph, e[i]);
                    if (neighbour == null || neighbour == obj || !(newPrio < q.getPrio(neighbour))) continue;
                    pred.put(neighbour, e[i]);
                    q.setPrio(neighbour, newPrio);
                }
            }
            if (q.isEmpty()) break;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Object obj = to;
        while (obj != null) {
            list.add(obj);
            Object edge = pred.get(obj);
            if (edge != null) {
                list.add(edge);
                obj = graph.getNeighbour(edge, obj);
                continue;
            }
            obj = null;
        }
        return list.toArray();
    }

    public Object[] getSpanningTree(WFGraph graph, CostFunction cf) {
        if (cf == null) {
            cf = this.createDefaultCostFunction();
        }
        Object[] all = graph.getAll();
        SortedSet edges = this.sort(graph, graph.getEdges(all), cf);
        UnionFind uf = new UnionFind();
        HashSet result = new HashSet();
        while (!edges.isEmpty()) {
            Object edge = edges.first();
            edges.remove(edge);
            Object setA = uf.find(graph.getSourceVertex(edge));
            Object setB = uf.find(graph.getTargetVertex(edge));
            if (setA != null && setB != null && setA == setB) continue;
            uf.union(setA, setB);
            result.add(edge);
        }
        HashSet<Object> v = new HashSet<Object>();
        for (Object edge : result) {
            Object source = graph.getSourceVertex(edge);
            Object target = graph.getTargetVertex(edge);
            if (source != null) {
                v.add(source);
            }
            if (target == null) continue;
            v.add(target);
        }
        Object[] cells = new Object[result.size() + v.size()];
        System.arraycopy(result.toArray(), 0, cells, 0, result.size());
        System.arraycopy(v.toArray(), 0, cells, result.size(), v.size());
        return cells;
    }

    public SortedSet sort(final JGraph graph, Object[] cells, final CostFunction cf) {
        TreeSet<Object> set = new TreeSet<Object>(new Comparator(){

            public int compare(Object o1, Object o2) {
                Double d1 = new Double(cf.getCost(graph, o1));
                Double d2 = new Double(cf.getCost(graph, o2));
                return d1.compareTo(d2);
            }
        });
        for (int i = 0; i < cells.length; ++i) {
            set.add(cells[i]);
        }
        return set;
    }

    public static double getLength(CellView view) {
        double cost = 1.0;
        if (view instanceof EdgeView) {
            EdgeView edge = (EdgeView)view;
            Point last = null;
            Point current = null;
            for (int i = 0; i < edge.getPointCount(); ++i) {
                current = edge.getPoint(i);
                if (last != null) {
                    cost += last.distance(current);
                }
                last = current;
            }
        }
        return cost;
    }

    public class PriorityQueue {
        protected Hashtable prio = new Hashtable();
        protected HashSet data = new HashSet();
        protected double minPrio = Double.MAX_VALUE;
        protected Object minElt = null;

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public Object pop() {
            Object tmp = this.minElt;
            this.data.remove(tmp);
            this.update();
            return tmp;
        }

        public double getPrio() {
            return this.minPrio;
        }

        public double getPrio(Object obj) {
            Double d;
            if (obj != null && (d = (Double)this.prio.get(obj)) != null) {
                return d;
            }
            return Double.MAX_VALUE;
        }

        protected void update() {
            Iterator it = this.data.iterator();
            this.minElt = null;
            this.minPrio = Double.MAX_VALUE;
            while (it.hasNext()) {
                Object tmp = it.next();
                double prio = this.getPrio(tmp);
                if (!(prio < this.minPrio)) continue;
                this.minPrio = prio;
                this.minElt = tmp;
            }
        }

        public void setPrio(Object obj, double prio) {
            Double d = new Double(prio);
            this.prio.put(obj, d);
            this.data.add(obj);
            if (prio < this.minPrio) {
                this.minPrio = prio;
                this.minElt = obj;
            }
        }
    }

    public class UnionFind {
        protected Hashtable sets = new Hashtable();
        protected Hashtable cells = new Hashtable();

        public int getSetCount() {
            return this.sets.size();
        }

        public Object find(Object cell) {
            Object set = null;
            if (cell != null && (set = (Object)this.cells.get(cell)) == null) {
                set = cell;
                this.cells.put(cell, set);
                HashSet<Object> contents = new HashSet<Object>();
                contents.add(cell);
                this.sets.put(set, contents);
            }
            return set;
        }

        public Object union(Object set1, Object set2) {
            if (set1 != null && set2 != null && set1 != set2) {
                HashSet tmp1 = (HashSet)this.sets.get(set1);
                HashSet tmp2 = (HashSet)this.sets.get(set2);
                if (tmp1 != null && tmp2 != null) {
                    if (tmp1.size() < tmp2.size()) {
                        Object tmp = tmp1;
                        tmp1 = tmp2;
                        tmp2 = tmp;
                        tmp = set1;
                        set1 = set2;
                        set2 = tmp;
                    }
                    tmp1.addAll(tmp2);
                    this.sets.remove(set2);
                    Iterator it = tmp2.iterator();
                    while (it.hasNext()) {
                        this.cells.put(it.next(), set1);
                    }
                }
            }
            return set1;
        }
    }

    public class DefaultCostFunction
    implements CostFunction {
        public double getCost(JGraph graph, Object cell) {
            CellView view = graph.getView().getMapping(cell, false);
            return GPGraphTools.getLength(view);
        }
    }

    public static interface CostFunction {
        public double getCost(JGraph var1, Object var2);
    }
}

