/*
 * Decompiled with CFR 0.152.
 */
package hero.client.grapheditor;

import com.jgraph.graph.CellView;
import com.jgraph.graph.Edge;
import com.jgraph.graph.GraphConstants;
import hero.client.grapheditor.GPGraphTools;
import hero.client.grapheditor.WFGraph;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Map;

public class Touch
implements Runnable {
    private WFGraph graph;
    private Hashtable deltas = new Hashtable();
    private Hashtable positions = new Hashtable();
    private Thread relaxer;
    private boolean allowedToRun = false;
    private boolean repaintNeeded = false;
    private double damper = 1.0;
    private double maxMotion = 0.0;
    private double lastMaxMotion = 0.0;
    private double motionRatio = 0.0;
    private boolean damping = true;
    private double rigidity = 1.0;
    private double newRigidity = 1.0;

    public Touch(WFGraph graph) {
        this.graph = graph;
        this.relaxer = null;
    }

    void setRigidity(double r) {
        this.newRigidity = r;
    }

    private synchronized void relaxEdges() {
        try {
            Object[] edges = this.graph.getEdges(this.graph.getAll());
            for (int i = 0; i < edges.length; ++i) {
                CellView from = this.graph.getSourceView(edges[i]);
                CellView to = this.graph.getTargetView(edges[i]);
                CellView fromV = this.graph.getView().getMapping(((Edge)edges[i]).getSource(), false);
                CellView toV = this.graph.getView().getMapping(((Edge)edges[i]).getTarget(), false);
                if (from == null || to == null) continue;
                Rectangle bf = fromV.getBounds();
                Rectangle bt = toV.getBounds();
                double vx = bt.x - bf.x;
                double vy = bt.y - bf.y;
                double len = Math.sqrt(vx * vx + vy * vy);
                double dx = vx * this.rigidity;
                double dy = vy * this.rigidity;
                double length = this.getLength(edges[i]) * 100.0;
                this.moveView(to, -(dx /= length) * len, -(dy /= length) * len);
                this.moveView(from, dx * len, dy * len);
            }
        }
        catch (Exception e) {
            this.run();
        }
    }

    public double getLength(Object edge) {
        CellView view = this.graph.getView().getMapping(edge, false);
        return GPGraphTools.getLength(view);
    }

    private synchronized void avoidLabels() {
        Object[] vertices = this.graph.getVertices(this.graph.getAll());
        for (int i = 0; i < vertices.length; ++i) {
            for (int j = i + 1; j < vertices.length; ++j) {
                CellView from = this.graph.getView().getMapping(vertices[i], false);
                CellView to = this.graph.getView().getMapping(vertices[j], false);
                if (from == null || to == null) continue;
                Point2D.Double bf = this.getPosition(from);
                Point2D.Double bt = this.getPosition(to);
                double dx = 0.0;
                double dy = 0.0;
                double vx = bf.x - bt.x;
                double vy = bf.y - bt.y;
                double len = vx * vx + vy * vy;
                if (len == 0.0) {
                    dx = Math.random();
                    dy = Math.random();
                } else if (len < 40000.0) {
                    dx = vx / len;
                    dy = vy / len;
                }
                int repSum = 400;
                this.moveView(from, dx * (double)repSum, dy * (double)repSum);
                this.moveView(to, -dx * (double)repSum, -dy * (double)repSum);
            }
        }
    }

    public void startDamper() {
        this.damping = true;
    }

    public void stopDamper() {
        this.damping = false;
        this.damper = 1.0;
    }

    public void resetDamper() {
        this.damping = true;
        this.damper = 1.0;
    }

    public void setDamper(double newValue) {
        this.damper = newValue;
    }

    public void damp() {
        if (this.damping && this.motionRatio <= 0.001) {
            if ((this.maxMotion < 0.2 || this.maxMotion > 1.0 && this.damper < 0.9) && this.damper > 0.01) {
                this.damper -= 0.01;
            } else if (this.maxMotion < 0.4 && this.damper > 0.003) {
                this.damper -= 0.003;
            } else if (this.damper > 1.0E-4) {
                this.damper -= 1.0E-4;
            }
        }
        if (this.maxMotion < 0.001 && this.damping) {
            this.damper = 0.0;
        }
    }

    private synchronized void moveNodes() {
        this.lastMaxMotion = this.maxMotion;
        double maxMotionA = 0.0;
        Object[] vertices = this.graph.getVertices(this.graph.getAll());
        for (int i = 0; i < vertices.length; ++i) {
            CellView view = this.graph.getView().getMapping(vertices[i], false);
            if (view == null) continue;
            Rectangle bounds = GraphConstants.getBounds((Map)view.getAttributes());
            Point2D.Double delta = this.getDelta(view);
            Point2D.Double position = this.getPosition(view);
            double dx = delta.getX();
            double dy = delta.getY();
            delta.setLocation((dx *= this.damper) / 2.0, (dy *= this.damper) / 2.0);
            double distMoved = Math.sqrt(dx * dx + dy * dy);
            if (GraphConstants.isMoveable((Map)view.getAttributes()) && !this.graph.isCellSelected(vertices[i]) && (dx != 0.0 || dy != 0.0)) {
                position.x += Math.max(-5.0, Math.min(5.0, dx));
                position.y += Math.max(-5.0, Math.min(5.0, dy));
                bounds.x = Math.max(0, (int)position.x - bounds.width / 2);
                bounds.y = Math.max(0, (int)position.y - bounds.height / 2);
                this.repaintNeeded = true;
            }
            maxMotionA = Math.max(distMoved, maxMotionA);
        }
        this.maxMotion = maxMotionA;
        this.motionRatio = this.maxMotion > 0.0 ? this.lastMaxMotion / this.maxMotion - 1.0 : 0.0;
        this.damp();
    }

    private synchronized void relax() {
        for (int i = 0; i < 10; ++i) {
            this.relaxEdges();
            this.avoidLabels();
            this.moveNodes();
        }
        if (this.rigidity != this.newRigidity) {
            this.rigidity = this.newRigidity;
        }
        if (this.repaintNeeded) {
            this.graph.repaint();
            this.repaintNeeded = false;
        }
    }

    public void run() {
        Thread me = Thread.currentThread();
        while (this.relaxer == me && this.allowedToRun) {
            this.relax();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void start() {
        this.relaxer = new Thread(this);
        this.allowedToRun = true;
        this.relaxer.start();
    }

    public boolean isRunning() {
        if (this.relaxer != null) {
            return this.relaxer.isAlive();
        }
        return false;
    }

    public void stop() {
        this.allowedToRun = false;
        this.relaxer = null;
    }

    public Point2D.Double getPosition(CellView view) {
        Point2D.Double p1 = (Point2D.Double)this.positions.get(view);
        Rectangle rect = GraphConstants.getBounds((Map)view.getAttributes());
        Point2D.Double p2 = new Point2D.Double(rect.x + rect.width / 2, rect.y + rect.height / 2);
        if (p1 != null) {
            if (Math.abs(p1.x - p2.x) > 5.0 || Math.abs(p1.y - p2.y) > 5.0) {
                p1.setLocation(p2.x, p2.y);
            }
            return p1;
        }
        this.positions.put(view, p2);
        return p2;
    }

    public Point2D.Double getDelta(CellView view) {
        Point2D.Double p = (Point2D.Double)this.deltas.get(view);
        if (p == null) {
            p = new Point2D.Double(0.0, 0.0);
            this.deltas.put(view, p);
        }
        return p;
    }

    public void moveView(CellView view, double dx, double dy) {
        Point2D.Double p = this.getDelta(view);
        p.setLocation(p.getX() + dx, p.getY() + dy);
    }
}

