/*
 * Decompiled with CFR 0.152.
 */
package hero.client.grapheditor;

import com.jgraph.JGraph;
import com.jgraph.event.GraphModelEvent;
import com.jgraph.event.GraphModelListener;
import com.jgraph.event.GraphSelectionEvent;
import com.jgraph.event.GraphSelectionListener;
import com.jgraph.graph.BasicMarqueeHandler;
import com.jgraph.graph.CellMapper;
import com.jgraph.graph.CellView;
import com.jgraph.graph.ConnectionSet;
import com.jgraph.graph.DefaultEdge;
import com.jgraph.graph.DefaultGraphCell;
import com.jgraph.graph.DefaultGraphModel;
import com.jgraph.graph.DefaultPort;
import com.jgraph.graph.Edge;
import com.jgraph.graph.EdgeView;
import com.jgraph.graph.GraphConstants;
import com.jgraph.graph.GraphModel;
import com.jgraph.graph.GraphView;
import com.jgraph.graph.Port;
import com.jgraph.graph.PortView;
import com.jgraph.graph.VertexView;
import com.jgraph.plaf.GraphUI;
import hero.client.grapheditor.BonitaActivityCell;
import hero.client.grapheditor.BonitaActivityView;
import hero.client.grapheditor.BonitaGraphUI;
import hero.client.grapheditor.BrowserControl;
import hero.client.grapheditor.Frame;
import hero.client.grapheditor.Spring;
import hero.client.grapheditor.Touch;
import hero.client.grapheditor.WFContextMenu;
import hero.client.grapheditor.WFManager;
import hero.client.grapheditor.WFPersistence;
import hero.net.ProjectSession.BnIterationLightValue;
import hero.net.ProjectSession.StrutsNodeValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.tree.MutableTreeNode;

public class WFGraph
extends JGraph {
    static ResourceBundle resource = ResourceBundle.getBundle("resources.Traduction");
    private DefaultGraphModel model;
    private WFManager manager;
    private WFPersistence persistence;
    public Hashtable nodes;
    private Hashtable edges;
    private DefaultGraphCell sourceCell;
    private boolean NEWEDGE = false;
    private Touch layout2;
    private boolean automaticLayout = false;
    private LayoutThread expand;
    private Image background;
    public static final String imageBase = "images/";
    public static final ImageIcon icon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/icon.png"));

    public WFGraph(final WFManager manager, WFPersistence persist) {
        this.manager = manager;
        this.persistence = persist;
        this.nodes = new Hashtable();
        this.edges = new Hashtable();
        this.setMarqueeHandler(new WFMarqueeHandler());
        this.expand = new LayoutThread(this);
        this.layout2 = new Touch(this);
        WFListener listener = new WFListener();
        this.getView().addObserver((Observer)listener);
        this.addGraphSelectionListener(listener);
        this.getModel().addGraphModelListener((GraphModelListener)listener);
        this.setDragEnabled(false);
        this.setDropEnabled(false);
        this.setSizeable(false);
        this.setEditable(false);
        this.setConnectable(false);
        this.setDisconnectable(false);
        this.setBendable(false);
        this.setAntiAliased(true);
        this.setCloneable(false);
        this.setAutomaticLayout(true);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    try {
                        if (!((WFGraph)WFGraph.this).persistence.soapclient.getProjectName().equals(WFGraph.this.persistence.getProjectName())) {
                            WFGraph.this.persistence.openProject(WFGraph.this.persistence.getProjectName());
                        }
                    }
                    catch (Exception openProject) {
                        // empty catch block
                    }
                }
                if (e.getClickCount() == 2) {
                    Map props;
                    DefaultGraphCell myCell = (DefaultGraphCell)WFGraph.this.getFirstCellForLocation(e.getX(), e.getY());
                    if (myCell != null && WFGraph.this.isVertex(myCell)) {
                        props = myCell.getAttributes();
                        String subProcess = (String)props.get("subProcess");
                        if (subProcess.equals("no")) {
                            try {
                                BrowserControl.displayURL(System.getProperty("bonita.host") + "/bonita/protected/Action.jsp?projectname=" + WFGraph.this.persistence.getProjectName() + "&nodename=" + (String)myCell.getUserObject());
                            }
                            catch (Exception ex) {}
                        } else {
                            try {
                                Frame frame = new Frame((String)props.get("name"), ((WFGraph)WFGraph.this).persistence.soapclient, true);
                                frame.setSize(new Dimension(500, 400));
                                frame.setVisible(true);
                                frame.requestFocus();
                            }
                            catch (Exception exce) {
                                exce.printStackTrace();
                            }
                        }
                    }
                    if (myCell != null && WFGraph.this.isEdge(myCell)) {
                        try {
                            props = myCell.getAttributes();
                            manager.setEdgeCondition((String)props.get("name"));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        URL backgroundUrl = Thread.currentThread().getContextClassLoader().getResource("images/background.png");
        this.background = Toolkit.getDefaultToolkit().getImage(backgroundUrl);
        this.setUI((GraphUI)new BonitaGraphUI());
        this.setBackground(Color.decode("#F7F7F7"));
    }

    public Image getBackgroundImage() {
        return this.background;
    }

    public void setAutomaticLayout(boolean value) {
        this.automaticLayout = value;
        if (value) {
            this.layout2.start();
            this.layout2.resetDamper();
        } else {
            this.layout2.stop();
        }
    }

    protected VertexView createVertexView(Object v, CellMapper cm) {
        if (v instanceof BonitaActivityCell) {
            return new BonitaActivityView(v, this, cm);
        }
        return super.createVertexView(v, cm);
    }

    public void addNewNode(String name, int state, int type) {
        if (!this.nodes.containsKey(name)) {
            Hashtable<BonitaActivityCell, Map> attributes = new Hashtable<BonitaActivityCell, Map>();
            BonitaActivityCell vertex = new BonitaActivityCell(name);
            Map vertexAttrib = GraphConstants.createMap();
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("type", "node");
            props.put("state", new Integer(state).toString());
            props.put("name", name);
            props.put("iterate", "false");
            if (type != 5) {
                GraphConstants.setBounds((Map)vertexAttrib, (Rectangle)new Rectangle(20, 100, 85, 27));
                props.put("subProcess", "no");
            } else {
                GraphConstants.setBounds((Map)vertexAttrib, (Rectangle)new Rectangle(20, 100, 85, 33));
                props.put("subProcess", "yes");
            }
            GraphConstants.setBorder((Map)vertexAttrib, (Border)BorderFactory.createRaisedBevelBorder());
            GraphConstants.setForeground((Map)vertexAttrib, (Color)Color.white);
            GraphConstants.setFontStyle((Map)vertexAttrib, (int)1);
            GraphConstants.setFontSize((Map)vertexAttrib, (float)11.0f);
            GraphConstants.setOpaque((Map)vertexAttrib, (boolean)true);
            vertex.setAttributes(props);
            switch (state) {
                case 0: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.lightGray.darker());
                    break;
                }
                case 1: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.yellow.darker());
                    break;
                }
                case 3: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.green.darker());
                    break;
                }
                case 5: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.magenta.darker());
                    break;
                }
                case 6: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.red.darker());
                    break;
                }
                case 7: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.orange.darker());
                    break;
                }
                case 10: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.cyan.darker());
                    break;
                }
                case 12: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.blue.darker());
                    break;
                }
                case 13: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.gray.darker());
                    break;
                }
                case 2: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.blue.darker());
                }
            }
            GraphConstants.setSizeable((Map)vertexAttrib, (boolean)false);
            attributes.put(vertex, vertexAttrib);
            vertex.add((MutableTreeNode)new DefaultPort());
            this.nodes.put(name, vertex);
            Object[] cell = new Object[]{vertex};
            this.model.insert(cell, null, null, attributes);
        }
    }

    public void updateIterationNodes(String from, String to) {
        BonitaActivityCell vertexFrom = (BonitaActivityCell)((Object)this.nodes.get(from));
        if (this.nodes.containsKey(from)) {
            Hashtable attributes = new Hashtable();
            Map propsFrom = vertexFrom.getAttributes();
            propsFrom.put("iterate", "from");
            attributes.put(this.nodes.get(from), propsFrom);
            this.model.insert(null, null, null, propsFrom);
            this.repaint();
        }
        BonitaActivityCell vertexTo = (BonitaActivityCell)((Object)this.nodes.get(to));
        if (this.nodes.containsKey(to)) {
            Hashtable attributes = new Hashtable();
            Map propsTo = vertexTo.getAttributes();
            propsTo.put("iterate", "to");
            attributes.put(this.nodes.get(to), propsTo);
            this.model.insert(null, null, null, propsTo);
            this.repaint();
        }
    }

    public void addNewEdge(DefaultGraphCell in, DefaultGraphCell out, String name) {
        Hashtable<DefaultEdge, Map> attributes = new Hashtable<DefaultEdge, Map>();
        DefaultEdge e = new DefaultEdge();
        Map edgeAttrib = GraphConstants.createMap();
        GraphConstants.setLineBegin((Map)edgeAttrib, (int)2);
        GraphConstants.setBeginFill((Map)edgeAttrib, (boolean)true);
        GraphConstants.setBeginSize((Map)edgeAttrib, (int)8);
        GraphConstants.setBendable((Map)edgeAttrib, (boolean)false);
        GraphConstants.setDisconnectable((Map)edgeAttrib, (boolean)false);
        attributes.put(e, edgeAttrib);
        Map inn = in.getAttributes();
        Map outn = out.getAttributes();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("type", "edge");
        props.put("name", name);
        props.put("nodein", (String)inn.get("name"));
        props.put("nodeout", (String)outn.get("name"));
        e.setAttributes(props);
        ConnectionSet cs = new ConnectionSet();
        cs.connect((Object)e, (Object)((DefaultPort)in.getChildAt(0)), false);
        cs.connect((Object)e, (Object)((DefaultPort)out.getChildAt(0)), true);
        this.edges.put(name, e);
        Object[] cell = new Object[]{e};
        this.model.insert(cell, cs, null, attributes);
    }

    public void openGraph(String projectName) {
        try {
            this.newGraph();
            this.nodes.clear();
            this.edges.clear();
            Object[] nd = this.persistence.getNodes();
            for (int i = 0; i < nd.length; ++i) {
                String nodeName = (String)nd[i];
                int state = this.persistence.getNodeState(nodeName);
                int type = this.persistence.getNodeType(nodeName);
                this.addNewNode(nodeName, state, type);
            }
            Object[] ed = this.persistence.getEdges();
            for (int i = 0; i < ed.length; ++i) {
                String nEdge = (String)ed[i];
                String nodeIn = this.persistence.getEdgeInNode(nEdge);
                String nodeOut = this.persistence.getEdgeOutNode(nEdge);
                this.addNewEdge((DefaultGraphCell)this.nodes.get(nodeIn), (DefaultGraphCell)this.nodes.get(nodeOut), nEdge);
            }
            if (this.automaticLayout) {
                this.layout2.resetDamper();
            }
            Collection iterations = this.persistence.getIterations();
            for (BnIterationLightValue i : iterations) {
                this.updateIterationNodes(i.getFromNode(), i.getToNode());
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private ArrayList getItNodes(String prop) throws Exception {
        ArrayList<String> nodes = new ArrayList<String>();
        int index = prop.indexOf("iterate_");
        prop = prop.substring(index + 8);
        index = prop.indexOf("-");
        String to = prop.substring(index + 1);
        String from = prop.substring(0, index);
        nodes.add(from);
        nodes.add(to);
        return nodes;
    }

    public void newGraph() {
        this.nodes.clear();
        this.edges.clear();
        this.model = new DefaultGraphModel();
        this.setModel((GraphModel)this.model);
        this.manager.setStatusBar(" ");
    }

    public void setLayout1() {
        WFGraph.basicLayout(this);
    }

    public void setExpand() {
        this.expand.step();
    }

    public void setZoom(int value) {
        this.setScale(1.0);
    }

    public void zoomIn() {
        this.setScale(this.getScale() * 2.0);
    }

    public void zoomOut() {
        if (this.getScale() > 0.01) {
            this.setScale(this.getScale() / 2.0);
        }
    }

    public void fitWindow(JScrollPane scrollPane) {
        Dimension p = this.getPreferredSize();
        Dimension s = scrollPane.getViewport().getBounds().getSize();
        if (Math.abs(s.getWidth() - p.getWidth()) < Math.abs(s.getHeight() - p.getHeight())) {
            this.setScale(s.getWidth() / p.getWidth());
        } else {
            this.setScale(s.getHeight() / p.getHeight());
        }
    }

    public void selectAll() {
        this.addSelectionCells(this.getRoots());
    }

    public boolean isGroup(Object cell) {
        CellView view = this.getView().getMapping(cell, false);
        if (view != null) {
            return !view.isLeaf();
        }
        return false;
    }

    public boolean isVertex(Object object) {
        if (!(object instanceof Port) && !(object instanceof Edge)) {
            return !this.isGroup(object);
        }
        return false;
    }

    public boolean isEdge(Object object) {
        return object instanceof Edge;
    }

    public Object[] getSelectionNodes() {
        Object[] tmp = this.getSelectionCells();
        Object[] all = DefaultGraphModel.getDescendants((GraphModel)this.getModel(), (Object[])tmp).toArray();
        Object[] cells = this.getVertices(all);
        Object[] elems = new Object[cells.length];
        for (int i = 0; i < cells.length; ++i) {
            elems[i] = (String)((DefaultGraphCell)cells[i]).getUserObject();
        }
        return elems;
    }

    public boolean isSubProcess(String name) {
        Object[] tmp = this.getSelectionCells();
        Object[] all = DefaultGraphModel.getDescendants((GraphModel)this.getModel(), (Object[])tmp).toArray();
        Object[] cells = this.getVertices(all);
        Object[] elems = new Object[cells.length];
        for (int i = 0; i < cells.length; ++i) {
            DefaultGraphCell myCell;
            Map props;
            String subProcess;
            if (!name.equals((String)((DefaultGraphCell)cells[i]).getUserObject()) || !(subProcess = (String)(props = (myCell = (DefaultGraphCell)cells[i]).getAttributes()).get("subProcess")).equals("yes")) continue;
            return true;
        }
        return false;
    }

    public Object[] getVertices(Object[] cells) {
        if (cells != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < cells.length; ++i) {
                if (!this.isVertex(cells[i])) continue;
                result.add(cells[i]);
            }
            return result.toArray();
        }
        return null;
    }

    public Object[] getSelectionEdges() {
        Object[] all = this.getSelectionCells();
        Object[] cells = this.getEdges(all);
        Object[] elems = new Object[cells.length];
        for (int i = 0; i < cells.length; ++i) {
            elems[i] = (String)((DefaultEdge)cells[i]).getAttributes().get("name");
        }
        return elems;
    }

    public Object[] getEdges(Object[] cells) {
        if (cells != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < cells.length; ++i) {
                if (!this.isEdge(cells[i])) continue;
                result.add(cells[i]);
            }
            return result.toArray();
        }
        return null;
    }

    public Object[] getEdge(Object[] cells, String name) {
        if (cells != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < cells.length; ++i) {
                Map a;
                if (!this.isEdge(cells[i]) || !name.equals((a = ((DefaultEdge)cells[i]).getAttributes()).get("name"))) continue;
                result.add(cells[i]);
            }
            return result.toArray();
        }
        return null;
    }

    public void removeNodeEdges(Object[] cells, String name) {
        if (cells != null) {
            for (int i = 0; i < cells.length; ++i) {
                Map a;
                if (!this.isEdge(cells[i]) || !name.equals((a = ((DefaultEdge)cells[i]).getAttributes()).get("nodein")) && !name.equals(a.get("nodeout"))) continue;
                this.deleteEdge((String)a.get("name"));
            }
        }
    }

    public void deleteNode(String node) throws Exception {
        if (this.nodes.containsKey(node)) {
            Object[] all = this.getRoots();
            this.removeNodeEdges(all, node);
            this.getModel().remove(new Object[]{this.nodes.get(node)});
            this.nodes.remove(node);
        }
    }

    public void deleteEdge(String edge) {
        if (this.edges.containsKey(edge)) {
            Object[] all = this.getRoots();
            this.getModel().remove(this.getEdge(all, edge));
            this.edges.remove(edge);
        }
    }

    public boolean existEdge(String name) {
        return this.edges.containsKey(name);
    }

    public void restoreEdges() {
        try {
            Object[] all = this.getRoots();
            Object[] ed = this.getEdges(all);
            this.edges.clear();
            if (ed != null) {
                this.getModel().remove(ed);
                Object[] edv = this.persistence.getEdges();
                for (int i = 0; i < edv.length; ++i) {
                    String nEdge = (String)ed[i];
                    String nodeIn = this.persistence.getEdgeInNode(nEdge);
                    String nodeOut = this.persistence.getEdgeOutNode(nEdge);
                    this.addNewEdge((DefaultGraphCell)this.nodes.get(nodeIn), (DefaultGraphCell)this.nodes.get(nodeOut), nEdge);
                }
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, resource.getString("wfgraph.edgeerror"));
        }
    }

    public void restoreEdge(String nEdge, String nodeIn, String nodeOut) {
        this.addNewEdge((DefaultGraphCell)this.nodes.get(nodeIn), (DefaultGraphCell)this.nodes.get(nodeOut), nEdge);
    }

    public void changeNodeState(String node, int state) {
        if (this.nodes.containsKey(node)) {
            Hashtable attributes = new Hashtable();
            Map vertexAttrib = GraphConstants.createMap();
            switch (state) {
                case 0: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.lightGray.darker());
                    break;
                }
                case 1: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.yellow.darker());
                    break;
                }
                case 3: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.green.darker());
                    break;
                }
                case 5: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.magenta.darker());
                    break;
                }
                case 6: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.red.darker());
                    break;
                }
                case 7: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.orange.darker());
                    break;
                }
                case 10: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.cyan.darker());
                    break;
                }
                case 12: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.blue.darker());
                    break;
                }
                case 13: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.gray.darker());
                    break;
                }
                case 2: {
                    GraphConstants.setBackground((Map)vertexAttrib, (Color)Color.blue.darker());
                }
            }
            attributes.put(this.nodes.get(node), vertexAttrib);
            this.model.insert(null, null, null, attributes);
            this.repaint();
        }
    }

    public Object getNeighbour(Object edge, Object vertex) {
        Object source = this.getSourceVertex(edge);
        if (vertex == source) {
            return this.getTargetVertex(edge);
        }
        return source;
    }

    public Object getSourceVertex(Object edge) {
        Object sourcePort = this.graphModel.getSource(edge);
        return this.graphModel.getParent(sourcePort);
    }

    public Object getTargetVertex(Object edge) {
        Object targetPort = this.graphModel.getTarget(edge);
        return this.graphModel.getParent(targetPort);
    }

    public CellView getSourceView(Object edge) {
        Object source = this.getSourceVertex(edge);
        return this.getView().getMapping(source, false);
    }

    public CellView getTargetView(Object edge) {
        Object target = this.getTargetVertex(edge);
        return this.getView().getMapping(target, false);
    }

    public Object[] getEdgesBetween(Object vertex1, Object vertex2) {
        ArrayList result = new ArrayList();
        Set edges = DefaultGraphModel.getEdges((GraphModel)this.graphModel, (Object[])new Object[]{vertex1});
        for (Object edge : edges) {
            Object source = this.getSourceVertex(edge);
            Object target = this.getTargetVertex(edge);
            if ((source != vertex1 || target != vertex2) && (source != vertex2 || target != vertex1)) continue;
            result.add(edge);
        }
        return result.toArray();
    }

    public String getToolTipText(MouseEvent e) {
        try {
            if (e != null) {
                Object c;
                if (!this.persistence.soapclient.getProjectName().equals(this.persistence.getProjectName())) {
                    this.persistence.openProject(this.persistence.getProjectName());
                }
                if ((c = this.getFirstCellForLocation(e.getX(), e.getY())) != null && this.isVertex(c)) {
                    String nodeName = this.convertValueToString(c);
                    StrutsNodeValue nl = this.persistence.getProjectNode(nodeName);
                    String s = "<html><center><b>" + nodeName + "</b></center>" + resource.getString("wfgraph.state") + nl.getState() + "<br>" + resource.getString("wfgraph.role") + nl.getRole() + "<br>" + resource.getString("wfgraph.type") + nl.getType() + "<br>" + resource.getString("wfgraph.deadline") + nl.getDeadline() + "<br></html>";
                    return s;
                }
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, resource.getString("wfgraph.errorgettool"));
        }
        return null;
    }

    public Object[] getAll() {
        return this.getDescendants(this.getRoots());
    }

    public void setAddEdgeState(boolean b) {
        this.NEWEDGE = b;
    }

    public void toFront(String nodeName) {
        Object[] cells = new Object[]{this.nodes.get(nodeName)};
        if (cells != null) {
            GraphView gv = this.getView();
            CellView[] views = gv.getMapping(cells);
            gv.toFront(views);
        }
    }

    public void toBack(String nodeName) {
        Object[] cells = new Object[]{this.nodes.get(nodeName)};
        if (cells != null) {
            GraphView gv = this.getView();
            CellView[] views = gv.getMapping(cells);
            gv.toBack(views);
        }
    }

    public static BufferedImage toImage(JGraph graph) {
        Object[] cells = graph.getRoots();
        if (cells.length > 0) {
            Rectangle bounds = graph.getCellBounds(cells);
            graph.toScreen(bounds);
            Dimension d = bounds.getSize();
            BufferedImage img = new BufferedImage(d.width + 10, d.height + 10, 1);
            Graphics2D graphics = img.createGraphics();
            graphics.translate(-bounds.x + 5, -bounds.y + 5);
            graph.paint((Graphics)graphics);
            return img;
        }
        return null;
    }

    private static String addNodeToVRML(Point p, Color c) {
        String vrml = "Transform{\ntranslation " + p.getX() + " " + p.getY() + " 0\n" + "\tchildren[\n" + "\t\tShape{\n" + "\t          appearance Appearance\n" + "\t        {\n" + "        \t\tmaterial Material\n" + "        \t\t{" + "\t                        diffuseColor " + c.getRed() + " " + c.getGreen() + " " + c.getBlue() + "\n" + "\t               \t\tshininess 0.01\n" + "            \t\t\t}" + "             \t\t}" + "                   geometry Box     { size 25 25 25  }\n" + "\t        }\n" + "]\n" + "}\n";
        return vrml;
    }

    private static String addEdgeToVRML(Point in, Point out) {
        String vrml = "Shape{appearance Appearance { \nmaterial Material {\n\temissiveColor 1 1 1 }\n\t}\n \tgeometry IndexedLineSet {\n \t\tcoord Coordinate {point [ " + in.getX() + " " + in.getY() + " 0\n" + "\t\t\t\t\t " + out.getX() + " " + out.getY() + " 0\n" + "\t\t\t\t\t] }\n" + "\t\tcoordIndex [0 1 ]\n" + "\t\tcolor Color { color [1 0 0, 0 1 0, 0 0 1]}\n" + "\t\tcolorIndex [0 1 ]\n" + "\t\tcolorPerVertex TRUE\n" + "\t}\n" + "}\n";
        return vrml;
    }

    public static String vrmlView(JGraph graph) {
        CellView[] views = graph.getView().getRoots();
        boolean max = false;
        String vrml = "#VRML V2.0 utf8\n Background{skyColor 0 0 0.5}\n";
        for (int i = 0; i < views.length; ++i) {
            if (views[i] instanceof VertexView) {
                Point p = ((VertexView)views[i]).getCenterPoint();
                Color c = (Color)((VertexView)views[i]).getAttributes().get("backgroundColor");
                vrml = vrml + WFGraph.addNodeToVRML(p, c);
                continue;
            }
            if (!(views[i] instanceof EdgeView)) continue;
            Point in = ((EdgeView)views[i]).getPoint(0);
            Point out = ((EdgeView)views[i]).getPoint(((EdgeView)views[i]).getPointCount() - 1);
            vrml = vrml + WFGraph.addEdgeToVRML(in, out);
        }
        return vrml;
    }

    public static void basicLayout(JGraph graph) {
        CellView[] views = graph.getView().getRoots();
        ArrayList<CellView> vertices = new ArrayList<CellView>();
        int max = 0;
        for (int i = 0; i < views.length; ++i) {
            if (!(views[i] instanceof VertexView)) continue;
            vertices.add(views[i]);
            Rectangle b = views[i].getBounds();
            if (b == null) continue;
            max = Math.max(Math.max(b.width, b.height), max);
        }
        int r = (int)Math.max((double)(vertices.size() * max) / Math.PI, 100.0);
        double phi = Math.PI * 2 / (double)vertices.size();
        for (int i = 0; i < vertices.size(); ++i) {
            CellView view = (CellView)vertices.get(i);
            Rectangle bounds = view.getBounds();
            if (bounds == null) continue;
            bounds.setLocation(r + (int)((double)r * Math.sin((double)i * phi)), r + (int)((double)r * Math.cos((double)i * phi)));
        }
        graph.repaint();
    }

    public class LayoutThread
    extends Timer {
        public LayoutThread(WFGraph graph) {
            super(200, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int n = WFGraph.this.getModel().getRootCount();
                    Spring s = new Spring(10 * n);
                    s.compute(WFGraph.this);
                    WFGraph.this.repaint();
                }
            });
        }

        public void step() {
            super.fireActionPerformed(null);
        }
    }

    public class WFMarqueeHandler
    extends BasicMarqueeHandler {
        protected Point start;
        protected Point current;
        protected Rectangle bounds;
        protected PortView port;
        protected PortView firstPort;
        protected PortView lastPort;
        protected DefaultGraphCell sourceCell;
        protected DefaultGraphCell destCell;
        protected boolean exception = false;

        public boolean isForceMarqueeEvent(MouseEvent e) {
            if ((e.getModifiers() & 4) == 0) {
                return WFGraph.this.NEWEDGE || super.isForceMarqueeEvent(e);
            }
            return true;
        }

        public void mousePressed(MouseEvent event) {
            if (WFGraph.this.NEWEDGE) {
                this.start = WFGraph.this.snap(event.getPoint());
                this.sourceCell = (DefaultGraphCell)WFGraph.this.getFirstCellForLocation(event.getX(), event.getY());
                event.consume();
            } else if ((event.getModifiers() & 4) != 0) {
                Object cell = WFGraph.this.getFirstCellForLocation(event.getX(), event.getY());
                JPopupMenu menu = WFContextMenu.popupMenu(WFGraph.this.manager.getFrame(), event.getPoint(), WFGraph.this.convertValueToString(cell), WFGraph.this.manager);
                int x = event.getX();
                int y = event.getY();
                menu.show((Component)((Object)WFGraph.this.manager.getGraph()), x, y);
            }
            super.mousePressed(event);
        }

        public void mouseDragged(MouseEvent event) {
            if (WFGraph.this.NEWEDGE) {
                Graphics g = WFGraph.this.getGraphics();
                Color bg = WFGraph.this.getBackground();
                Color fg = Color.black;
                g.setColor(fg);
                g.setXORMode(bg);
                this.current = WFGraph.this.snap(event.getPoint());
                this.overlay(g);
            }
            super.mouseDragged(event);
        }

        public void mouseReleased(MouseEvent event) {
            try {
                if (WFGraph.this.NEWEDGE) {
                    this.destCell = (DefaultGraphCell)WFGraph.this.getFirstCellForLocation(event.getX(), event.getY());
                    if (this.sourceCell != null && this.destCell != null) {
                        String name = WFGraph.this.persistence.addEdge((String)this.sourceCell.getUserObject(), (String)this.destCell.getUserObject());
                        if (name != null) {
                            WFGraph.this.addNewEdge(this.sourceCell, this.destCell, name);
                        } else {
                            this.exception = true;
                        }
                    }
                    WFGraph.this.NEWEDGE = false;
                    this.sourceCell = null;
                    this.destCell = null;
                }
                super.mouseReleased(event);
                if (this.exception) {
                    this.exception = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void mouseMoved(MouseEvent event) {
            super.mouseMoved(event);
        }

        public void overlay(Graphics g) {
            try {
                super.overlay(g);
                if (WFGraph.this.NEWEDGE) {
                    WFGraph.this.repaint();
                    g.drawLine(this.start.x, this.start.y, this.current.x, this.current.y);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class WFListener
    implements Observer,
    GraphModelListener,
    GraphSelectionListener {
        public void update(Observable o, Object obj) {
            if (WFGraph.this.automaticLayout) {
                WFGraph.this.layout2.resetDamper();
            }
        }

        public void valueChanged(GraphSelectionEvent e) {
            if (!WFGraph.this.isSelectionEmpty() && WFGraph.this.automaticLayout) {
                WFGraph.this.layout2.setDamper(0.0);
            }
            WFGraph.this.manager.updateStatus();
        }

        public void graphChanged(GraphModelEvent e) {
            if (WFGraph.this.automaticLayout) {
                WFGraph.this.layout2.resetDamper();
            }
        }
    }
}

