/*
 * Decompiled with CFR 0.152.
 */
package hero.client.manager;

import hero.client.manager.BrowserControl;
import hero.client.manager.ListItem;
import hero.client.manager.MListener;
import hero.client.manager.ManagerCellRenderer;
import hero.interfaces.Constants;
import hero.util.BonitaClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class JTodoList
extends JPanel
implements PropertyChangeListener,
MouseListener,
Constants.Nd {
    static ResourceBundle resource = ResourceBundle.getBundle("resources.Traduction");
    private BonitaClient soapclient;
    private DefaultListModel model;
    private JList todoList;
    private String project = null;
    MListener ml;
    public static final String imageBase = "images/";
    public static final ImageIcon icon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/icon.png"));

    public JTodoList(BonitaClient soapclient, MListener ml) {
        try {
            this.soapclient = soapclient;
            ml.addEventTodoListener(this);
            this.model = new DefaultListModel();
            this.todoList = new JList(this.model);
            this.todoList.setCellRenderer(new ManagerCellRenderer());
            JScrollPane jsptdl = new JScrollPane(this.todoList);
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout());
            p.setBackground(new Color(177, 177, 251));
            this.setLayout(new BorderLayout());
            this.setBackground(new Color(177, 177, 251));
            this.add((Component)new JLabel(resource.getString("jtodolist.todo")), "North");
            this.add((Component)jsptdl, "Center");
            this.add((Component)p, "South");
            this.todoList.addMouseListener(this);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, resource.getString("jtodolist.error"), resource.getString("jtodolist.inerror"), 1, icon);
        }
    }

    public void mouseReleased(MouseEvent e) {
        try {
            if ((e.getModifiers() & 4) != 0) {
                JPopupMenu menu = new JPopupMenu();
                this.PopupMenu(menu);
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension size = menu.getPreferredSize();
                int x = e.getX();
                int y = e.getY();
                menu.show(this, x, y);
            } else if (e.getClickCount() == 2) {
                try {
                    BrowserControl.displayURL(System.getProperty("bonita.host") + "/bonita/protected/Action.jsp?projectname=" + this.project + "&nodename=" + ((ListItem)this.todoList.getSelectedValue()).getValue());
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void PopupMenu(JPopupMenu menu) {
        ClassLoader cl = this.getClass().getClassLoader();
        if (this.todoList.getSelectedIndex() != -1) {
            JMenuItem mi = menu.add(new JMenuItem(resource.getString("jtodolist.start")));
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTodoList.this.start();
                }
            });
            mi = menu.add(new JMenuItem(resource.getString("jtodolist.details")));
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BrowserControl.displayURL(System.getProperty("bonita.host") + "/bonita/protected/Action.jsp?projectname=" + JTodoList.this.project + "&nodename=" + ((ListItem)JTodoList.this.todoList.getSelectedValue()).getValue());
                }
            });
        }
    }

    void start() {
        try {
            if (this.project != null) {
                this.soapclient.startActivity(this.project, ((ListItem)this.todoList.getSelectedValue()).getValue());
            }
        }
        catch (Exception start) {
            JOptionPane.showMessageDialog(null, resource.getString("jtodolist.starterror") + start.getMessage(), resource.getString("jtodolist.start"), 1, icon);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        try {
            if (e.getPropertyName().equals("selected")) {
                this.model.clear();
                this.project = (String)e.getNewValue();
                Collection toDo = this.soapclient.getToDoList(this.project);
                for (String node : toDo) {
                    ListItem li = new ListItem(this.getColor(node), node);
                    this.model.addElement(li);
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public Color getColor(String name) throws Exception {
        this.soapclient.openProject(this.project);
        int state = this.soapclient.getNodeState(name);
        switch (state) {
            case 1: {
                return Color.yellow;
            }
            case 3: {
                return Color.green;
            }
        }
        return Color.white;
    }

    public void changeEvent(Object[] e, String projectName) {
        try {
            if (projectName.equals(this.project)) {
                this.model.clear();
                int i = 0;
                for (i = 0; i < e.length; ++i) {
                    ListItem li = new ListItem(this.getColor(e[i].toString()), e[i].toString());
                    this.model.addElement(li);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isChanged(Object[] elements) {
        ArrayList<String> listElements = new ArrayList<String>();
        Enumeration e = this.model.elements();
        while (e.hasMoreElements()) {
            ListItem li = (ListItem)e.nextElement();
            listElements.add(li.getValue());
        }
        List<Object> newElements = Arrays.asList(elements);
        return !listElements.containsAll(newElements);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

