/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.BnUserPropertyValue;
import hero.interfaces.UserSession;
import hero.interfaces.UserSessionHome;
import hero.interfaces.UserSessionUtil;
import java.util.Collection;
import javax.security.auth.login.LoginContext;

public class SampleUserApi {
    public static void main(String[] args) throws Exception {
        char[] password = new char[]{'t', 'o', 't', 'o'};
        SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        UserSessionHome usrHome = UserSessionUtil.getHome();
        UserSession usrSession = usrHome.create();
        System.out.println("Current User Name/Passwd : " + usrSession.getUser() + "/" + usrSession.getUserPassword());
        usrSession.setUserProperty("Language", "Spanish");
        System.out.println("Getting Current User properties values");
        Collection properties = usrSession.getUserProperties();
        for (BnUserPropertyValue property : properties) {
            try {
                String propertyKeyName = property.getTheKey();
                String propertyValue = property.getTheValue();
                System.out.println("Property (Key, Value) : " + propertyKeyName + "/" + propertyValue);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        System.out.println("\n Getting project names for this user");
        try {
            Collection prjNames = usrSession.getProjectListNames();
            for (String prjName : prjNames) {
                System.out.println(" --> Project :  " + prjName);
            }
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("\n Starting & terminating Activities available for this user");
        try {
            Collection instNames = usrSession.getInstancesListNames();
            for (String instName : instNames) {
                System.out.println("--> INSTANCE :  " + instName);
                System.out.println("Getting ToDo list for this instance");
                Collection activityNames = usrSession.getToDoList(instName);
                for (String activityName : activityNames) {
                    System.out.println("   --> activity :  " + activityName);
                    try {
                        usrSession.startActivity(instName, activityName);
                        System.out.println("   --> activity started");
                    }
                    catch (Exception e) {
                        System.out.println(" --> " + e);
                    }
                }
                System.out.println("Getting the activity List (executing or anticipating) for the user");
                activityNames = usrSession.getActivityList(instName);
                for (String activityName : activityNames) {
                    System.out.println("   --> activity :  " + activityName);
                    try {
                        usrSession.terminateActivity(instName, activityName);
                        System.out.println("   --> activity terminated");
                    }
                    catch (Exception e) {
                        System.out.println(" --> " + e);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
    }
}

