/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.iterations.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class ExtraEntryPoint {
    public static void main(String[] args) throws Exception {
        try {
            System.out.println(" ****** ExtraEntryPoint 1.0 ******* ");
            System.out.println(" *        Entry                   * ");
            System.out.println(" *          |_____ repeat=false   * ");
            System.out.println(" *        A----->B----->C         * ");
            System.out.println(" *        |      |                * ");
            System.out.println(" *        |_ _ _ |                * ");
            System.out.println(" *      repeat=true               * ");
            System.out.println(" ********************************** ");
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
            ProjectSession ps = projectSessionh.create();
            System.out.print("\n   Creating ExtraEntryPoint model");
            ps.initModel("ExtraEntryPoint");
            ps.setProperty("repeat", "true");
            ps.addNode("A", 1);
            ps.addNode("B", 1);
            ps.addNode("C", 1);
            ps.addNode("Entry", 1);
            ps.setNodeTraditional("A");
            ps.setNodeTraditional("B");
            ps.setNodeTraditional("C");
            ps.setNodeTraditional("Entry");
            ps.addEdge("A", "B");
            String fromBtoC = ps.addEdge("B", "C");
            ps.addEdge("Entry", "B");
            ps.setEdgeCondition(fromBtoC, "repeat.equals(\"false\")");
            ps.addIteration("B", "A", "repeat.equals(\"true\")");
            ps.addRole("Administrator", "The system administator role");
            ps.setNodeRole("A", "Administrator");
            ps.setNodeRole("B", "Administrator");
            ps.setNodeRole("C", "Administrator");
            ps.setNodeRole("Entry", "Administrator");
            ps.addRoleMapper("Administrator", "AdministratorMapper", 1);
            ps.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

