/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.patterns.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class Pattern12MultipleInstancesWithoutSynchronization {
    public static void main(String[] args) {
        try {
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
            ProjectSession prjSession = prjHome.create();
            System.out.print("\n   Pattern 12 - Multiple Instances without Synchronization");
            prjSession.initModel("Pattern 12 - Multiple Instances without Synchronization");
            prjSession.addNode("order_books", 1);
            prjSession.addNode("send_bill", 1);
            prjSession.setNodeTraditional("order_books");
            prjSession.setNodeTraditional("send_bill");
            prjSession.addEdge("order_books", "send_bill");
            prjSession.setProperty("books", "3");
            ProjectSession prjSession2 = prjHome.create();
            prjSession2.initModel("Process book order (SubProcess)");
            prjSession2.addNode("update_stock", 1);
            prjSession2.addNode("send_book", 1);
            prjSession2.setNodeTraditional("update_stock");
            prjSession2.setNodeTraditional("send_book");
            prjSession2.addEdge("update_stock", "send_book");
            String update_stockHookScript = "import hero.interfaces.*;\nbeforeStart(Object engine, Object currentNode) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(currentNode.getBnProject().getName()); \n  BnProjectPropertyValue bookNameProp = prjSession.getProperty(\"book_name\"); \n  System.out.println(\"   ---> update_stock : \" + bookNameProp.getTheValue()); \n}";
            prjSession2.addNodeInterHook("update_stock", "update_stock Hook", "beforeStart", 6, update_stockHookScript);
            prjSession2.addRole("Executor", "Rol that enables to execute the activities inside the SubProcess");
            prjSession2.setUserRole("admin", "Executor");
            prjSession2.setNodeRole("update_stock", "Executor");
            prjSession2.setNodeRole("send_book", "Executor");
            prjSession2.remove();
            String approveHookScript = "import hero.interfaces.*;\nbeforeTerminate(Object engine, Object currentNode) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(currentNode.getBnProject().getName()); \n  BnProjectPropertyValue booksProp = prjSession.getProperty(\"books\"); \n  int books = Integer.parseInt(booksProp.getTheValue()); \n  for (int i = 0; i < books; i++) { \n    String nodeName = \"book\" + Integer.toString(i); \n    prjSession.addNodeSubProcess(nodeName, \"Process book order (SubProcess)\"); \n    prjSession.setNodeProperty(nodeName, \"book_name\", nodeName, true); \n    prjSession.addEdge(\"order_books\", nodeName); \n    prjSession.setNodeRole(nodeName, \"Executor\"); \n  } \n}";
            prjSession.addNodeInterHook("order_books", "Order books Hook", "beforeTerminate", 6, approveHookScript);
            prjSession.addRole("Executor", "Rol that enables to execute the activities");
            prjSession.setUserRole("admin", "Executor");
            prjSession.setNodeRole("order_books", "Executor");
            prjSession.setNodeRole("send_bill", "Executor");
            prjSession.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

