/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples.patterns.src;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class Pattern17InterleavedParallelRouting {
    public static void main(String[] args) {
        try {
            char[] password = new char[]{'t', 'o', 't', 'o'};
            SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
            ProjectSession prjSession = prjHome.create();
            System.out.print("\n   Pattern 17 - Interleaved Parallel Routing");
            prjSession.initModel("Pattern 17 - Interleaved Parallel Routing");
            prjSession.addNode("select_avaliable_test", 1);
            prjSession.addNode("physical_test", 1);
            prjSession.addNode("mental_test", 1);
            prjSession.addNode("skill_test", 1);
            prjSession.addNode("decide", 2);
            prjSession.addNode("tests_report", 1);
            prjSession.setNodeTraditional("select_avaliable_test");
            prjSession.setNodeTraditional("physical_test");
            prjSession.setNodeTraditional("mental_test");
            prjSession.setNodeTraditional("skill_test");
            prjSession.setNodeTraditional("decide");
            prjSession.setNodeTraditional("tests_report");
            String toPhysicalTest = prjSession.addEdge("select_avaliable_test", "physical_test");
            String toMentalTest = prjSession.addEdge("select_avaliable_test", "mental_test");
            String toSkillTest = prjSession.addEdge("select_avaliable_test", "skill_test");
            prjSession.addEdge("physical_test", "decide");
            prjSession.addEdge("mental_test", "decide");
            prjSession.addEdge("skill_test", "decide");
            String toTestReport = prjSession.addEdge("decide", "tests_report");
            prjSession.setProperty("test", "");
            prjSession.setProperty("physical_test", "not_passed");
            prjSession.setProperty("mental_test", "not_passed");
            prjSession.setProperty("skill_test", "not_passed");
            prjSession.setEdgeCondition(toPhysicalTest, "test.equals(\"1\")");
            prjSession.setEdgeCondition(toMentalTest, "test.equals(\"2\")");
            prjSession.setEdgeCondition(toSkillTest, "test.equals(\"3\")");
            prjSession.setEdgeCondition(toTestReport, "physical_test.equals(\"passed\") && mental_test.equals(\"passed\") && skill_test.equals(\"passed\")");
            String simulateAvalibilityHookScript = "import hero.interfaces.*;\nimport java.util.Random; \nbeforeTerminate(Object engine, Object currentNode) { \n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(currentNode.getBnProject().getName()); \n  String physicalPassed = prjSession.getProperty(\"physical_test\").getTheValue(); \n  String mentalPassed = prjSession.getProperty(\"mental_test\").getTheValue(); \n  String skillPassed = prjSession.getProperty(\"skill_test\").getTheValue(); \n  Random generator = new Random(System.currentTimeMillis()); \n  boolean avaliableTest = false; \n  int testNum; \n  System.out.println(\" Physical : \" + physicalPassed); \n  System.out.println(\"   Mental : \" + mentalPassed); \n  System.out.println(\"    Skill : \" + skillPassed); \n  while (avaliableTest == false) { \n    testNum = generator.nextInt(3) + 1; \n    System.out.println(\"    --> Test : \" + testNum); \n    if (((testNum == 1) && (physicalPassed.equals(\"not_passed\")))        || ((testNum == 2) && (mentalPassed.equals(\"not_passed\")))        || ((testNum == 3) && (skillPassed.equals(\"not_passed\")))) { \n      avaliableTest = true; \n    } \n  } \n  prjSession.setProperty(\"test\", Integer.toString(testNum)); \n  System.out.println(\"    --> Tests remaining : \" + testNum); \n} \n";
            prjSession.addNodeInterHook("select_avaliable_test", "Select test Hook", "beforeTerminate", 6, simulateAvalibilityHookScript);
            String testPassedHookScript = "import hero.interfaces.*;\nimport java.util.Random; \nbeforeTerminate(Object engine, Object currentNode) { \n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(currentNode.getBnProject().getName()); \n  String nodeName = currentNode.getName(); \n  prjSession.setProperty(nodeName, \"passed\"); \n  System.out.println(\"    --> Test \" + nodeName + \" : passed\"); \n} \n";
            prjSession.addNodeInterHook("physical_test", "physical_test Hook", "beforeTerminate", 6, testPassedHookScript);
            prjSession.addNodeInterHook("mental_test", "mental_test Hook", "beforeTerminate", 6, testPassedHookScript);
            prjSession.addNodeInterHook("skill_test", "skill_test Hook", "beforeTerminate", 6, testPassedHookScript);
            prjSession.addIteration("decide", "select_avaliable_test", "(physical_test.equals(\"not_passed\") || mental_test.equals(\"not_passed\") || skill_test.equals(\"not_passed\"))");
            prjSession.addRole("Executor", "Rol that enables to execute the activities");
            prjSession.setUserRole("admin", "Executor");
            prjSession.setNodeRole("select_avaliable_test", "Executor");
            prjSession.setNodeRole("physical_test", "Executor");
            prjSession.setNodeRole("mental_test", "Executor");
            prjSession.setNodeRole("skill_test", "Executor");
            prjSession.setNodeRole("decide", "Executor");
            prjSession.setNodeRole("tests_report", "Executor");
            prjSession.checkModelDefinition();
            System.out.println("   [ OK ]");
        }
        catch (Exception e) {
            System.out.println("\n\n   [ ERROR ] : " + e);
            e.printStackTrace();
        }
    }
}

