/*
 * Decompiled with CFR 0.152.
 */
package hero.client.test;

import hero.interfaces.BnNodePropertyValue;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import hero.interfaces.UserSession;
import hero.interfaces.UserSessionHome;
import hero.interfaces.UserSessionUtil;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class IterationTests
extends TestCase {
    public IterationTests(String testname) {
        super(testname);
    }

    public static TestSuite suite() {
        return new TestSuite(IterationTests.class);
    }

    public void setUp() throws Exception {
    }

    public void testLeaveIteration() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("LeaveIteration");
        ps.addNode("node0", 1);
        ps.addNode("node1", 1);
        ps.addNode("node2", 1);
        ps.addNode("node3", 1);
        ps.addNode("node4", 1);
        ps.addNode("node5", 1);
        ps.addNode("node6", 1);
        ps.addNode("node7", 1);
        ps.addNode("node8", 3);
        ps.setNodeTraditional("node8");
        ps.addNode("node9", 3);
        ps.setNodeTraditional("node9");
        ps.addEdge("node0", "node1");
        ps.addEdge("node1", "node3");
        ps.addEdge("node1", "node4");
        ps.addEdge("node1", "node5");
        String from3to6 = ps.addEdge("node3", "node6");
        String from3to8 = ps.addEdge("node3", "node8");
        String from4to2 = ps.addEdge("node4", "node2");
        String from4to6 = ps.addEdge("node4", "node6");
        ps.addEdge("node5", "node4");
        ps.addEdge("node5", "node6");
        String from6to7 = ps.addEdge("node6", "node7");
        ps.addEdge("node8", "node9");
        ps.setProperty("iterate", "true");
        ps.setEdgeCondition(from3to6, "iterate.equals(\"true\")");
        ps.setEdgeCondition(from4to6, "iterate.equals(\"true\")");
        ps.setEdgeCondition(from3to8, "iterate.equals(\"false\")");
        ps.setEdgeCondition(from4to2, "iterate.equals(\"false\")");
        ps.setEdgeCondition(from6to7, "iterate.equals(\"false\")");
        ps.addIteration("node6", "node1", "iterate.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("LeaveIteration");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        usr.startActivity(project, "node0");
        IterationTests.assertTrue((String)"Error in LeaveIteration, startActivity node0: node0 failed", (ps.getNodeValue("node0").getState() == 6 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in LeaveIteration, startActivity node0: node1 failed", (ps.getNodeValue("node1").getState() == 3 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node0");
        IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node0: node0 failed", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node0: node1 failed", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
        for (int index = 0; index < 2; ++index) {
            usr.startActivity(project, "node1");
            IterationTests.assertTrue((String)"Error in LeaveIteration, startActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, startActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 3 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, startActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, startActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 3 ? 1 : 0) != 0);
            usr.terminateActivity(project, "node1");
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 1 ? 1 : 0) != 0);
            usr.startActivity(project, "node3");
            usr.startActivity(project, "node5");
            usr.startActivity(project, "node4");
            if (index == 0) {
                IterationTests.assertTrue((String)"Error in LeaveIteration, startActivity node2: node2 failed", (ps.getNodeValue("node2").getState() == 3 ? 1 : 0) != 0);
                usr.startActivity(project, "node2");
                IterationTests.assertTrue((String)"Error in LeaveIteration, startActivity node2: node2 failed", (ps.getNodeValue("node2").getState() == 5 ? 1 : 0) != 0);
            }
            usr.terminateActivity(project, "node3");
            usr.terminateActivity(project, "node5");
            usr.terminateActivity(project, "node4");
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node3: node8 failed", (ps.getNodeValue("node8").getState() == 2 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node3: node9 failed", (ps.getNodeValue("node9").getState() == 2 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node4: node2 failed", (ps.getNodeValue("node2").getState() == 2 ? 1 : 0) != 0);
            usr.startActivity(project, "node6");
            usr.terminateActivity(project, "node6");
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node6: node0 failed", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node6: node1 failed", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node6: node2 failed", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node6: node3 failed", (ps.getNodeValue("node3").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node6: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node6: node5 failed", (ps.getNodeValue("node5").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node6: node6 failed", (ps.getNodeValue("node6").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node6: node7 failed", (ps.getNodeValue("node7").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node6: node8 failed", (ps.getNodeValue("node8").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node6: node9 failed", (ps.getNodeValue("node9").getState() == 0 ? 1 : 0) != 0);
        }
        usr.startActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in LeaveIteration, startActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in LeaveIteration, startActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 3 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in LeaveIteration, startActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in LeaveIteration, startActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 3 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node3");
        usr.startActivity(project, "node5");
        usr.startActivity(project, "node4");
        ps.setProperty("iterate", "false");
        usr.terminateActivity(project, "node3");
        usr.terminateActivity(project, "node5");
        usr.terminateActivity(project, "node4");
        IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node3 | node4, after iterate: node6 failed", (ps.getNodeValue("node6").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node3 | node4, after iterate: node7 failed", (ps.getNodeValue("node7").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node3, after iterate: node8 failed", (ps.getNodeValue("node8").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node3, after iterate: node9 failed", (ps.getNodeValue("node9").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in LeaveIteration, terminateActivity node6, after iterate: node2 failed", (ps.getNodeValue("node2").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node2");
        IterationTests.assertTrue((String)"Error in LeaveIteration, startActivity node2, after iterate: node2 failed", (ps.getNodeValue("node2").getState() == 6 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node2");
    }

    public void testFinalizeIteration() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("FinalizeIteration");
        ps.addNode("node0", 1);
        ps.addNode("node1", 1);
        ps.addNode("node2", 1);
        ps.addNode("node3", 1);
        ps.addNode("node4", 1);
        ps.addNode("node5", 1);
        ps.addNode("node6", 1);
        ps.addNode("node7", 1);
        ps.addNode("node8", 3);
        ps.setNodeTraditional("node8");
        ps.addNode("node9", 3);
        ps.setNodeTraditional("node9");
        ps.addEdge("node0", "node1");
        ps.addEdge("node1", "node3");
        ps.addEdge("node1", "node4");
        ps.addEdge("node1", "node5");
        String from3to6 = ps.addEdge("node3", "node6");
        String from3to8 = ps.addEdge("node3", "node8");
        String from4to2 = ps.addEdge("node4", "node2");
        String from4to6 = ps.addEdge("node4", "node6");
        ps.addEdge("node5", "node4");
        ps.addEdge("node5", "node6");
        String from6to7 = ps.addEdge("node6", "node7");
        ps.addEdge("node8", "node9");
        ps.setProperty("iterate", "true");
        ps.setEdgeCondition(from3to6, "iterate.equals(\"true\")");
        ps.setEdgeCondition(from4to6, "iterate.equals(\"true\")");
        ps.setEdgeCondition(from3to8, "iterate.equals(\"false\")");
        ps.setEdgeCondition(from4to2, "iterate.equals(\"false\")");
        ps.setEdgeCondition(from6to7, "iterate.equals(\"false\")");
        ps.addIteration("node6", "node1", "iterate.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("FinalizeIteration");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        usr.startActivity(project, "node0");
        IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node0: node0 failed", (ps.getNodeValue("node0").getState() == 6 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node0: node1 failed", (ps.getNodeValue("node1").getState() == 3 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node0");
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node0: node0 failed", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node0: node1 failed", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
        for (int index = 0; index < 2; ++index) {
            usr.startActivity(project, "node1");
            IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 3 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 3 ? 1 : 0) != 0);
            usr.terminateActivity(project, "node1");
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 1 ? 1 : 0) != 0);
            usr.startActivity(project, "node3");
            usr.startActivity(project, "node5");
            usr.startActivity(project, "node4");
            if (index == 0) {
                IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node2: node2 failed", (ps.getNodeValue("node2").getState() == 3 ? 1 : 0) != 0);
                usr.startActivity(project, "node2");
                IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node2: node2 failed", (ps.getNodeValue("node2").getState() == 5 ? 1 : 0) != 0);
            }
            usr.terminateActivity(project, "node3");
            usr.terminateActivity(project, "node5");
            usr.terminateActivity(project, "node4");
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node3: node8 failed", (ps.getNodeValue("node8").getState() == 2 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node3: node9 failed", (ps.getNodeValue("node9").getState() == 2 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node4: node2 failed", (ps.getNodeValue("node2").getState() == 2 ? 1 : 0) != 0);
            usr.startActivity(project, "node6");
            usr.terminateActivity(project, "node6");
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node0 failed", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node1 failed", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node2 failed", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node3 failed", (ps.getNodeValue("node3").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node5 failed", (ps.getNodeValue("node5").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node6 failed", (ps.getNodeValue("node6").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node7 failed", (ps.getNodeValue("node7").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node8 failed", (ps.getNodeValue("node8").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node9 failed", (ps.getNodeValue("node9").getState() == 0 ? 1 : 0) != 0);
        }
        usr.startActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 3 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 3 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node3");
        usr.startActivity(project, "node5");
        usr.startActivity(project, "node4");
        usr.terminateActivity(project, "node3");
        usr.terminateActivity(project, "node5");
        usr.terminateActivity(project, "node4");
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node3, after iterate: node8 failed", (ps.getNodeValue("node8").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node3, after iterate: node9 failed", (ps.getNodeValue("node9").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node4, after iterate: node2 failed", (ps.getNodeValue("node2").getState() == 2 ? 1 : 0) != 0);
        ps.setProperty("iterate", "false");
        usr.startActivity(project, "node6");
        usr.terminateActivity(project, "node6");
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6, after iterate: node6 failed", (ps.getNodeValue("node6").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6, after iterate: node7 failed", (ps.getNodeValue("node7").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node7");
        usr.terminateActivity(project, "node7");
    }

    public void testFinalizeIterationORjoin() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("FinalizeIterationORjoin");
        ps.addNode("node0", 2);
        ps.addNode("node1", 2);
        ps.addNode("node2", 2);
        ps.addNode("node3", 2);
        ps.addNode("node4", 2);
        ps.addNode("node5", 2);
        ps.addNode("node6", 2);
        ps.addNode("node7", 2);
        ps.addNode("node8", 4);
        ps.setNodeTraditional("node8");
        ps.addNode("node9", 4);
        ps.setNodeTraditional("node9");
        ps.addEdge("node0", "node1");
        ps.addEdge("node1", "node3");
        ps.addEdge("node1", "node4");
        ps.addEdge("node1", "node5");
        String from3to6 = ps.addEdge("node3", "node6");
        String from3to8 = ps.addEdge("node3", "node8");
        String from4to2 = ps.addEdge("node4", "node2");
        String from4to6 = ps.addEdge("node4", "node6");
        ps.addEdge("node5", "node4");
        ps.addEdge("node5", "node6");
        String from6to7 = ps.addEdge("node6", "node7");
        ps.addEdge("node8", "node9");
        ps.setProperty("iterate", "true");
        ps.setEdgeCondition(from3to6, "iterate.equals(\"true\")");
        ps.setEdgeCondition(from4to6, "iterate.equals(\"true\")");
        ps.setEdgeCondition(from3to8, "iterate.equals(\"false\")");
        ps.setEdgeCondition(from4to2, "iterate.equals(\"false\")");
        ps.setEdgeCondition(from6to7, "iterate.equals(\"false\")");
        ps.addIteration("node6", "node1", "iterate.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("FinalizeIterationORjoin");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        usr.startActivity(project, "node0");
        IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node0: node0 failed", (ps.getNodeValue("node0").getState() == 6 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node0: node1 failed", (ps.getNodeValue("node1").getState() == 3 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node0");
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node0: node0 failed", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node0: node1 failed", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
        for (int index = 0; index < 2; ++index) {
            usr.startActivity(project, "node1");
            IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 3 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 3 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 3 ? 1 : 0) != 0);
            usr.terminateActivity(project, "node1");
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 1 ? 1 : 0) != 0);
            usr.startActivity(project, "node3");
            usr.startActivity(project, "node5");
            usr.startActivity(project, "node4");
            if (index == 0) {
                IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node2: node2 failed", (ps.getNodeValue("node2").getState() == 3 ? 1 : 0) != 0);
                usr.startActivity(project, "node2");
                IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node2: node2 failed", (ps.getNodeValue("node2").getState() == 5 ? 1 : 0) != 0);
            }
            usr.terminateActivity(project, "node3");
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node3: node8 failed", (ps.getNodeValue("node8").getState() == 2 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node3: node9 failed", (ps.getNodeValue("node9").getState() == 2 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node3: node6 failed", (ps.getNodeValue("node6").getState() == 1 ? 1 : 0) != 0);
            usr.startActivity(project, "node6");
            usr.terminateActivity(project, "node6");
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node0 failed", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node1 failed", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node2 failed", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node3 failed", (ps.getNodeValue("node3").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node5 failed", (ps.getNodeValue("node5").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node6 failed", (ps.getNodeValue("node6").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node7 failed", (ps.getNodeValue("node7").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node8 failed", (ps.getNodeValue("node8").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6: node9 failed", (ps.getNodeValue("node9").getState() == 0 ? 1 : 0) != 0);
        }
        usr.startActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 3 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 3 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, startActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 3 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 1 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node3");
        usr.terminateActivity(project, "node3");
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node3, after iterate: node8 failed", (ps.getNodeValue("node8").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node3, after iterate: node9 failed", (ps.getNodeValue("node9").getState() == 2 ? 1 : 0) != 0);
        usr.startActivity(project, "node4");
        usr.terminateActivity(project, "node4");
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node4, after iterate: node2 failed", (ps.getNodeValue("node2").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node4, after iterate: node6 failed", (ps.getNodeValue("node6").getState() == 1 ? 1 : 0) != 0);
        ps.setProperty("iterate", "false");
        usr.startActivity(project, "node6");
        usr.terminateActivity(project, "node6");
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6, after iterate: node6 failed", (ps.getNodeValue("node6").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in FinalizeIteration, terminateActivity node6, after iterate: node7 failed", (ps.getNodeValue("node7").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node7");
        usr.terminateActivity(project, "node7");
    }

    public void testRepeatActivity() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("RepeatActivity");
        ps.addNode("A", 1);
        ps.addNode("B", 1);
        ps.addNode("C", 1);
        ps.setNodeTraditional("A");
        ps.setNodeTraditional("B");
        ps.setNodeTraditional("C");
        ps.setProperty("repeat", "true");
        ps.setProperty("repetitions", "3");
        ps.addEdge("A", "B");
        String fromBtoC = ps.addEdge("B", "C");
        ps.setEdgeCondition(fromBtoC, "repeat.equals(\"false\")");
        String repeatScript = "import hero.interfaces.*;\nbeforeTerminate(Object b,Object n) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(n.getBnProject().getName()); \n  BnProjectPropertyValue repetitionsProp = prjSession.getProperty(\"repetitions\"); \n  int repetitions = Integer.parseInt(repetitionsProp.getTheValue()); \n  if (repetitions == 0) { \n    prjSession.setProperty(\"repeat\", \"false\"); \n  } else { \n     repetitions--; \n    prjSession.setProperty(\"repetitions\", Integer.toString(repetitions)); \n  } \n} \n";
        ps.addNodeInterHook("B", "Repeat hook", "beforeTerminate", 6, repeatScript);
        ps.addIteration("B", "B", "repeat.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("RepeatActivity");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        usr.startActivity(project, "A");
        usr.terminateActivity(project, "A");
        IterationTests.assertTrue((String)"Error in RepeatActivity, terminateActivity 'A': 'A' failed", (ps.getNodeValue("A").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in RepeatActivity, terminateActivity 'A': 'B' failed", (ps.getNodeValue("B").getState() == 1 ? 1 : 0) != 0);
        for (int repetitions = 0; repetitions < 3; ++repetitions) {
            usr.startActivity(project, "B");
            usr.terminateActivity(project, "B");
            IterationTests.assertTrue((String)"Error in RepeatActivity, terminateActivity 'B': 'B' failed", (ps.getNodeValue("B").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in RepeatActivity, terminateActivity 'B': 'C' failed", (ps.getNodeValue("C").getState() == 0 ? 1 : 0) != 0);
        }
        usr.startActivity(project, "B");
        usr.terminateActivity(project, "B");
        IterationTests.assertTrue((String)"Error in RepeatActivity, terminateActivity 'B': 'B' failed", (ps.getNodeValue("B").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in RepeatActivity, terminateActivity 'B': 'C' failed", (ps.getNodeValue("C").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "C");
        usr.terminateActivity(project, "C");
    }

    public void testIterationInsideIteration() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("IterationInsideIteration");
        ps.addNode("A", 1);
        ps.addNode("B", 1);
        ps.addNode("C", 1);
        ps.addNode("D", 1);
        ps.setNodeTraditional("A");
        ps.setNodeTraditional("B");
        ps.setNodeTraditional("C");
        ps.setNodeTraditional("D");
        ps.setProperty("condition1", "true");
        ps.setProperty("condition2", "true");
        ps.setProperty("repetitions1", "3");
        ps.setProperty("repetitions2", "3");
        ps.addEdge("A", "B");
        String fromBtoC = ps.addEdge("B", "C");
        String fromCtoD = ps.addEdge("C", "D");
        ps.setEdgeCondition(fromBtoC, "condition1.equals(\"false\")");
        ps.setEdgeCondition(fromCtoD, "condition2.equals(\"false\")");
        String repeat1Script = "import hero.interfaces.*;\nbeforeTerminate(Object b,Object n) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(n.getBnProject().getName()); \n  BnProjectPropertyValue repetitions1Prop = prjSession.getProperty(\"repetitions1\"); \n  int repetitions1 = Integer.parseInt(repetitions1Prop.getTheValue()); \n  repetitions1--; \n  if (repetitions1 == 0) { \n    prjSession.setProperty(\"repetitions1\", \"3\"); \n    prjSession.setProperty(\"condition1\", \"false\"); \n  } else { \n     prjSession.setProperty(\"repetitions1\", Integer.toString(repetitions1)); \n  } \n} \n";
        ps.addNodeInterHook("B", "Repeat1 hook", "beforeTerminate", 6, repeat1Script);
        ps.addIteration("B", "B", "condition1.equals(\"true\")");
        String repeat2Script = "import hero.interfaces.*;\nbeforeTerminate(Object b,Object n) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(n.getBnProject().getName()); \n  BnProjectPropertyValue repetitions2Prop = prjSession.getProperty(\"repetitions2\"); \n  int repetitions2 = Integer.parseInt(repetitions2Prop.getTheValue()); \n  repetitions2--; \n  if (repetitions2 == 0) { \n    prjSession.setProperty(\"condition2\", \"false\"); \n  } else { \n     prjSession.setProperty(\"repetitions2\", Integer.toString(repetitions2)); \n    prjSession.setProperty(\"condition1\", \"true\"); \n  } \n} \n";
        ps.addNodeInterHook("C", "Repeat2 hook", "beforeTerminate", 6, repeat2Script);
        ps.addIteration("C", "A", "condition2.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("IterationInsideIteration");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        int repetitions1 = 0;
        for (int repetitions2 = 0; repetitions2 < 3; ++repetitions2) {
            usr.startActivity(project, "A");
            usr.terminateActivity(project, "A");
            IterationTests.assertTrue((String)"Error in IterationInsideIteration, terminateActivity 'A': 'A' failed", (ps.getNodeValue("A").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in IterationInsideIteration, terminateActivity 'A': 'B' failed", (ps.getNodeValue("B").getState() == 1 ? 1 : 0) != 0);
            for (repetitions1 = 0; repetitions1 < 2; ++repetitions1) {
                usr.startActivity(project, "B");
                usr.terminateActivity(project, "B");
                IterationTests.assertTrue((String)"Error in IterationInsideIteration, terminateActivity 'B': 'B' failed", (ps.getNodeValue("B").getState() == 1 ? 1 : 0) != 0);
                IterationTests.assertTrue((String)"Error in IterationInsideIteration, terminateActivity 'B': 'C' failed", (ps.getNodeValue("C").getState() == 0 ? 1 : 0) != 0);
            }
            usr.startActivity(project, "B");
            usr.terminateActivity(project, "B");
            IterationTests.assertTrue((String)"Error in IterationInsideIteration, terminateActivity 'B': 'B' failed", (ps.getNodeValue("B").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in IterationInsideIteration, terminateActivity 'B': 'C' failed", (ps.getNodeValue("C").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in IterationInsideIteration, terminateActivity 'B': 'D' failed", (ps.getNodeValue("D").getState() == 0 ? 1 : 0) != 0);
            usr.startActivity(project, "C");
            usr.terminateActivity(project, "C");
        }
        IterationTests.assertTrue((String)"Error in IterationInsideIteration, terminateActivity 'C': 'A' failed", (ps.getNodeValue("A").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in IterationInsideIteration, terminateActivity 'C': 'B' failed", (ps.getNodeValue("B").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in IterationInsideIteration, terminateActivity 'C': 'C' failed", (ps.getNodeValue("C").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in IterationInsideIteration, terminateActivity 'C': 'D' failed", (ps.getNodeValue("D").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "D");
        usr.terminateActivity(project, "D");
    }

    public void testManualArbitraryCycles() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("ManualArbitraryCycles");
        ps.addNode("A", 1);
        ps.addNode("B", 1);
        ps.addNode("C", 1);
        ps.addNode("D", 1);
        ps.addNode("E", 1);
        ps.addNode("F", 1);
        ps.setNodeTraditional("A");
        ps.setNodeTraditional("B");
        ps.setNodeTraditional("C");
        ps.setNodeTraditional("D");
        ps.setNodeTraditional("E");
        ps.setNodeTraditional("F");
        ps.setProperty("condition1", "true");
        ps.setProperty("condition2", "true");
        ps.setProperty("iterations", "2");
        ps.addEdge("A", "B");
        ps.addEdge("B", "C");
        ps.addEdge("C", "D");
        String fromDtoE = ps.addEdge("D", "E");
        String fromEtoF = ps.addEdge("E", "F");
        ps.setEdgeCondition(fromDtoE, "condition1.equals(\"false\")");
        ps.setEdgeCondition(fromEtoF, "condition2.equals(\"false\")");
        String dScript = "import hero.interfaces.*;\nbeforeTerminate(Object b,Object n) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(n.getBnProject().getName()); \n  BnProjectPropertyValue condition1Prop = prjSession.getProperty(\"condition1\"); \n  String condition1 = condition1Prop.getTheValue(); \n  if (condition1.equals(\"true\")) { \n    prjSession.setProperty(\"condition1\", \"false\"); \n  } else { \n     prjSession.setProperty(\"condition1\", \"true\"); \n  } \n} \n";
        ps.addNodeInterHook("D", "D script", "beforeTerminate", 6, dScript);
        String eScript = "import hero.interfaces.*;\nbeforeTerminate(Object b,Object n) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(n.getBnProject().getName()); \n  BnProjectPropertyValue iterationsProp = prjSession.getProperty(\"iterations\"); \n  int iterations = Integer.parseInt(iterationsProp.getTheValue()); \n  if (iterations == 0) { \n    prjSession.setProperty(\"condition2\", \"false\"); \n  } else { \n     iterations--; \n    prjSession.setProperty(\"iterations\", Integer.toString(iterations)); \n  } \n} \n";
        ps.addNodeInterHook("E", "E script", "beforeTerminate", 6, eScript);
        ps.addIteration("D", "B", "condition1.equals(\"true\")");
        ps.addIteration("E", "C", "condition2.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("ManualArbitraryCycles");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        usr.startActivity(project, "A");
        usr.terminateActivity(project, "A");
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'A': 'A' failed", (ps.getNodeValue("A").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'A': 'B' failed", (ps.getNodeValue("B").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "B");
        usr.terminateActivity(project, "B");
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'B': 'B' failed", (ps.getNodeValue("B").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'B': 'C' failed", (ps.getNodeValue("C").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "C");
        usr.terminateActivity(project, "C");
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'C': 'C' failed", (ps.getNodeValue("C").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'C': 'D' failed", (ps.getNodeValue("D").getState() == 1 ? 1 : 0) != 0);
        for (int iterations = 0; iterations < 2; ++iterations) {
            usr.startActivity(project, "D");
            usr.terminateActivity(project, "D");
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'D': 'D' failed", (ps.getNodeValue("D").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'D': 'E' failed", (ps.getNodeValue("E").getState() == 1 ? 1 : 0) != 0);
            usr.startActivity(project, "E");
            usr.terminateActivity(project, "E");
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'E': 'C' failed", (ps.getNodeValue("C").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'E': 'D' failed", (ps.getNodeValue("D").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'E': 'E' failed", (ps.getNodeValue("E").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'E': 'F' failed", (ps.getNodeValue("F").getState() == 0 ? 1 : 0) != 0);
            usr.startActivity(project, "C");
            usr.terminateActivity(project, "C");
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'C': 'C' failed", (ps.getNodeValue("C").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'C': 'D' failed", (ps.getNodeValue("D").getState() == 1 ? 1 : 0) != 0);
            usr.startActivity(project, "D");
            usr.terminateActivity(project, "D");
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'D': 'B' failed", (ps.getNodeValue("B").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'D': 'C' failed", (ps.getNodeValue("C").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'D': 'D' failed", (ps.getNodeValue("D").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'D': 'E' failed", (ps.getNodeValue("E").getState() == 0 ? 1 : 0) != 0);
            usr.startActivity(project, "B");
            usr.terminateActivity(project, "B");
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'B': 'B' failed", (ps.getNodeValue("B").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'B': 'C' failed", (ps.getNodeValue("C").getState() == 1 ? 1 : 0) != 0);
            usr.startActivity(project, "C");
            usr.terminateActivity(project, "C");
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'C': 'C' failed", (ps.getNodeValue("C").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'C': 'D' failed", (ps.getNodeValue("D").getState() == 1 ? 1 : 0) != 0);
        }
        usr.startActivity(project, "D");
        usr.terminateActivity(project, "D");
        usr.startActivity(project, "E");
        usr.terminateActivity(project, "E");
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'E': 'A' failed", (ps.getNodeValue("A").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'E': 'B' failed", (ps.getNodeValue("B").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'E': 'C' failed", (ps.getNodeValue("C").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'E': 'D' failed", (ps.getNodeValue("D").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'E': 'E' failed", (ps.getNodeValue("E").getState() == 10 ? 1 : 0) != 0);
        usr.startActivity(project, "F");
        usr.terminateActivity(project, "F");
    }

    public void testAutomaticArbitraryCycles() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("AutomaticArbitraryCycles");
        ps.addNode("A", 1);
        ps.addNode("B", 3);
        ps.addNode("C", 3);
        ps.addNode("D", 3);
        ps.addNode("E", 3);
        ps.addNode("F", 1);
        ps.setNodeTraditional("A");
        ps.setNodeTraditional("B");
        ps.setNodeTraditional("C");
        ps.setNodeTraditional("D");
        ps.setNodeTraditional("E");
        ps.setNodeTraditional("F");
        ps.setProperty("condition1", "50");
        ps.setProperty("condition2", "50");
        ps.setProperty("randomNum", "0");
        ps.addEdge("A", "B");
        ps.addEdge("B", "C");
        ps.addEdge("C", "D");
        String fromDtoE = ps.addEdge("D", "E");
        String fromEtoF = ps.addEdge("E", "F");
        ps.setEdgeCondition(fromDtoE, "(new Integer(randomNum).intValue() >= new Integer(condition1).intValue())");
        ps.setEdgeCondition(fromEtoF, "(new Integer(randomNum).intValue() >= new Integer(condition2).intValue())");
        String generateRandomScript = "import hero.interfaces.*;\nimport java.util.Random; \nbeforeTerminate(Object b,Object n) {\n\n\n  hero.interfaces.ProjectSessionHome pHome = (hero.interfaces.ProjectSessionHome) hero.interfaces.ProjectSessionUtil.getHome(); \n  hero.interfaces.ProjectSession prjSession = pHome.create(); \n  prjSession.initModel(n.getBnProject().getName()); \n  Random generator = new Random(System.currentTimeMillis()); \n  int newRnd = generator.nextInt(100); \n  prjSession.setProperty(\"randomNum\", Integer.toString(newRnd)); \n} \n";
        ps.addNodeInterHook("D", "Generates random number and saves it in 'randomNum' var", "beforeTerminate", 6, generateRandomScript);
        ps.addNodeInterHook("E", "Generates random number and saves it in 'randomNum' var", "beforeTerminate", 6, generateRandomScript);
        ps.addIteration("D", "B", "(new Integer(randomNum).intValue() < new Integer(condition1).intValue())");
        ps.addIteration("E", "C", "(new Integer(randomNum).intValue() < new Integer(condition2).intValue())");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("AutomaticArbitraryCycles");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        usr.startActivity(project, "A");
        usr.terminateActivity(project, "A");
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'A': 'A' failed", (ps.getNodeValue("A").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'A': 'B' failed", (ps.getNodeValue("B").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'A': 'C' failed", (ps.getNodeValue("C").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'A': 'D' failed", (ps.getNodeValue("D").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ArbitraryCycles, terminateActivity 'A': 'E' failed", (ps.getNodeValue("E").getState() == 10 ? 1 : 0) != 0);
        usr.startActivity(project, "F");
        usr.terminateActivity(project, "F");
    }

    public void testIterationsConstrains() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("MultiIterationsLeaving");
        ps.addNode("A", 1);
        ps.addNode("B", 1);
        ps.addNode("C", 1);
        ps.addNode("D", 1);
        ps.setNodeTraditional("A");
        ps.setNodeTraditional("B");
        ps.setNodeTraditional("C");
        ps.setNodeTraditional("D");
        ps.setProperty("path", "A");
        ps.addEdge("A", "B");
        String fromCtoD = ps.addEdge("C", "D");
        ps.setEdgeCondition(fromCtoD, "path.equals(\"D\")");
        try {
            ps.addIteration("C", "A", "path.equals(\"A\")");
            IterationTests.assertTrue((String)"Error in testIterationsConstrains, it's imposible to have and iteration here", (boolean)false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        ps.addEdge("B", "C");
        ps.addIteration("C", "A", "path.equals(\"A\")");
        try {
            ps.addIteration("C", "A", "path.equals(\"B\")");
            IterationTests.assertTrue((String)"Error in testIterationsConstrains, we cannot define 2 iterations over the same nodes", (boolean)false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        ps.addIteration("C", "B", "path.equals(\"B\")");
        ps.addIteration("C", "C", "path.equals(\"C\")");
        ps.checkModelDefinition();
        try {
            ps.addIteration("D", "zzz", "true");
            IterationTests.assertTrue((String)"Error in testIterationsConstrains, cannot create an iteration with nodes that doesn't exit", (boolean)false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            ps.addIteration("zzz", "D", "true");
            IterationTests.assertTrue((String)"Error in testIterationsConstrains, cannot create an iteration with nodes that doesn't exit", (boolean)false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            ps.addEdge("C", "D");
            IterationTests.assertTrue((String)"Error in testIterationsConstrains, this edge creates a cycle", (boolean)false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            ps.addIteration("D", "D", "");
            ps.checkModelDefinition();
            IterationTests.assertTrue((String)"Error in testIterationsConstrains, iteration's condition cannot be \"\" (empty)", (boolean)false);
        }
        catch (Exception e) {
            System.out.println(e);
            ps.deleteIteration("D", "D");
        }
        try {
            ps.addIteration("D", "D", "\"true\"");
            ps.checkModelDefinition();
            IterationTests.assertTrue((String)"Error in testIterationsConstrains, it is posible to have an iteration condition = \"true\"", (boolean)true);
            ps.deleteIteration("D", "D");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            ps.addIteration("D", "C", "\"true\"");
            ps.deleteEdge(fromCtoD);
            ps.checkModelDefinition();
            IterationTests.assertTrue((String)"Error in testIterationsConstrains, it's impossible to have a iteration because these nodes are not connected", (boolean)false);
        }
        catch (Exception e) {
            System.out.println(e);
            ps.deleteIteration("D", "C");
            fromCtoD = ps.addEdge("C", "D");
            ps.setEdgeCondition(fromCtoD, "path.equals(\"D\")");
        }
        try {
            ps.addIteration("D", "A", "path.equals(\"A\")");
            ps.addIteration("D", "B", "path.equals(\"A\")");
            ps.checkModelDefinition();
            IterationTests.assertTrue((String)"Error in testIterationsConstrains, iterations conditions must be different", (boolean)false);
        }
        catch (Exception e) {
            System.out.println(e);
            ps.deleteIteration("D", "A");
            ps.deleteIteration("D", "B");
        }
        try {
            ps.deleteEdge(fromCtoD);
            fromCtoD = ps.addEdge("C", "D");
            ps.checkModelDefinition();
            IterationTests.assertTrue((String)"Error in testIterationsConstrains, condition in edge C--->D has to exist", (boolean)false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            ps.setEdgeCondition(fromCtoD, "");
            ps.checkModelDefinition();
            IterationTests.assertTrue((String)"Error in testIterationsConstrains, condition in edge C--->D cannot be \"\" (empty)", (boolean)false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            ps.deleteEdge(fromCtoD);
            fromCtoD = ps.addEdge("C", "D");
            ps.setEdgeCondition(fromCtoD, "true");
            ps.checkModelDefinition();
            IterationTests.assertTrue((String)"Error in testIterationsConstrains, condition in edge C--->D cannot be \"true\"", (boolean)false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            ps.deleteEdge(fromCtoD);
            fromCtoD = ps.addEdge("C", "D");
            ps.setEdgeCondition(fromCtoD, "path.equals(\"A\")");
            ps.checkModelDefinition();
            IterationTests.assertTrue((String)"Error in testIterationsConstrains, condition in edge C--->D cannot be equal to another iteration condition", (boolean)false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void testExtraEntryPointsSimple1() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("ExtraEntryPointsSimple1");
        ps.setProperty("condA", "true");
        ps.setProperty("condB", "true");
        ps.setProperty("condC", "true");
        ps.setProperty("iterate", "true");
        ps.addNode("node1", 1);
        ps.addNode("node2", 1);
        ps.addNode("node3", 1);
        ps.addNode("node4", 1);
        ps.addNode("extraA", 1);
        ps.addNode("extraB", 1);
        ps.addNode("extraC", 1);
        ps.setNodeTraditional("node1");
        ps.setNodeTraditional("node2");
        ps.setNodeTraditional("node3");
        ps.setNodeTraditional("node4");
        ps.setNodeTraditional("extraA");
        ps.setNodeTraditional("extraB");
        ps.setNodeTraditional("extraC");
        ps.addEdge("node1", "node2");
        ps.addEdge("node2", "node3");
        String from3to4 = ps.addEdge("node3", "node4");
        String fromAto2 = ps.addEdge("extraA", "node2");
        String fromBto2 = ps.addEdge("extraB", "node2");
        String fromCto2 = ps.addEdge("extraC", "node2");
        ps.setEdgeCondition(from3to4, "iterate.equals(\"false\")");
        ps.setEdgeCondition(fromAto2, "condA.equals(\"true\")");
        ps.setEdgeCondition(fromBto2, "condB.equals(\"true\")");
        ps.setEdgeCondition(fromCto2, "condC.equals(\"true\")");
        ps.addIteration("node3", "node1", "iterate.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("ExtraEntryPointsSimple1");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        usr.startActivity(project, "extraA");
        usr.startActivity(project, "extraB");
        usr.startActivity(project, "extraC");
        usr.terminateActivity(project, "extraA");
        usr.terminateActivity(project, "extraB");
        usr.terminateActivity(project, "extraC");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, node2 failed", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
        for (int index = 0; index < 2; ++index) {
            usr.startActivity(project, "node1");
            usr.terminateActivity(project, "node1");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node1: node2 failed", (ps.getNodeValue("node2").getState() == 1 ? 1 : 0) != 0);
            usr.startActivity(project, "node2");
            usr.terminateActivity(project, "node2");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node2: node2 failed", (ps.getNodeValue("node2").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node2: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
            usr.startActivity(project, "node3");
            usr.terminateActivity(project, "node3");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: node1 failed", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: node2 failed", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: node3 failed", (ps.getNodeValue("node3").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        }
        usr.startActivity(project, "node1");
        usr.terminateActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node1: node2 failed", (ps.getNodeValue("node2").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node2");
        usr.terminateActivity(project, "node2");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node2: node2 failed", (ps.getNodeValue("node2").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node2: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node3");
        ps.setProperty("iterate", "false");
        usr.terminateActivity(project, "node3");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: node2 failed", (ps.getNodeValue("node2").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: node3 failed", (ps.getNodeValue("node3").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: node4 failed", (ps.getNodeValue("node4").getState() == 1 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple1, terminateActivity node3: extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        usr.startActivity(project, "node4");
        usr.terminateActivity(project, "node4");
    }

    public void testExtraEntryPointsSimple2() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("ExtraEntryPointsSimple2");
        ps.setProperty("condA", "true");
        ps.setProperty("condB", "true");
        ps.setProperty("condC", "false");
        ps.setProperty("iterate", "true");
        ps.addNode("node1", 1);
        ps.addNode("node2", 1);
        ps.addNode("node3", 1);
        ps.addNode("node4", 1);
        ps.addNode("extraA", 1);
        ps.addNode("extraB", 1);
        ps.addNode("extraC", 1);
        ps.setNodeTraditional("node1");
        ps.setNodeTraditional("node2");
        ps.setNodeTraditional("node3");
        ps.setNodeTraditional("node4");
        ps.setNodeTraditional("extraA");
        ps.setNodeTraditional("extraB");
        ps.setNodeTraditional("extraC");
        ps.addEdge("node1", "node2");
        ps.addEdge("node2", "node3");
        String from3to4 = ps.addEdge("node3", "node4");
        String fromAto2 = ps.addEdge("extraA", "node2");
        String fromBto2 = ps.addEdge("extraB", "node2");
        String fromCto2 = ps.addEdge("extraC", "node2");
        ps.setEdgeCondition(from3to4, "iterate.equals(\"false\")");
        ps.setEdgeCondition(fromAto2, "condA.equals(\"true\")");
        ps.setEdgeCondition(fromBto2, "condB.equals(\"true\")");
        ps.setEdgeCondition(fromCto2, "condC.equals(\"true\")");
        ps.addIteration("node3", "node1", "iterate.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("ExtraEntryPointsSimple2");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        usr.startActivity(project, "extraA");
        usr.startActivity(project, "extraB");
        usr.startActivity(project, "extraC");
        usr.terminateActivity(project, "extraA");
        usr.terminateActivity(project, "extraB");
        usr.terminateActivity(project, "extraC");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple2, extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple2, extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple2, extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple2, node2 failed", (ps.getNodeValue("node2").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple2, node3 failed", (ps.getNodeValue("node3").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple2, node4 failed", (ps.getNodeValue("node4").getState() == 2 ? 1 : 0) != 0);
        usr.startActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple2, startActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node1");
    }

    private void incrementAndTestNodeProperty(ProjectSession ps, String node, String prop, int expectedNewValue) throws Exception {
        BnNodePropertyValue propValue = ps.getNodeProperty(node, prop);
        int counter = Integer.parseInt(propValue.getTheValue());
        if (++counter != expectedNewValue) {
            throw new Exception("Error in testExtraEntryPointsSimple3, counter in " + node + " should be " + expectedNewValue);
        }
        ps.setNodeProperty(node, prop, Integer.toString(counter));
    }

    public void testExtraEntryPointsSimple3() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("ExtraEntryPointsSimple3");
        ps.setProperty("cond0", "true");
        ps.setProperty("condA", "true");
        ps.setProperty("condB", "false");
        ps.setProperty("condC", "false");
        ps.setProperty("iterate", "true");
        ps.addNode("initial", 1);
        ps.addNode("node0", 1);
        ps.addNode("node1", 1);
        ps.addNode("node2", 2);
        ps.addNode("node3", 1);
        ps.addNode("node4", 1);
        ps.addNode("extraA", 2);
        ps.addNode("extraB", 2);
        ps.addNode("extraC", 2);
        ps.setNodeTraditional("initial");
        ps.setNodeTraditional("node0");
        ps.setNodeTraditional("node1");
        ps.setNodeTraditional("node2");
        ps.setNodeTraditional("node3");
        ps.setNodeTraditional("node4");
        ps.setNodeTraditional("extraA");
        ps.setNodeTraditional("extraB");
        ps.setNodeTraditional("extraC");
        ps.setNodeProperty("extraA", "counter", "0", true);
        String from0to1 = ps.addEdge("node0", "node1");
        ps.addEdge("node1", "node2");
        ps.addEdge("node2", "node3");
        String from3to4 = ps.addEdge("node3", "node4");
        String fromAto2 = ps.addEdge("extraA", "node2");
        String fromBto2 = ps.addEdge("extraB", "node2");
        String fromCto2 = ps.addEdge("extraC", "node2");
        ps.setEdgeCondition(from3to4, "iterate.equals(\"false\")");
        ps.setEdgeCondition(from0to1, "cond0.equals(\"true\")");
        ps.setEdgeCondition(fromAto2, "condA.equals(\"true\")");
        ps.setEdgeCondition(fromBto2, "condB.equals(\"true\")");
        ps.setEdgeCondition(fromCto2, "condC.equals(\"true\")");
        ps.addIteration("node3", "node0", "iterate.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("ExtraEntryPointsSimple3");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        usr.startActivity(project, "extraB");
        usr.terminateActivity(project, "extraB");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, node2 failed", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
        usr.startActivity(project, "extraC");
        usr.terminateActivity(project, "extraC");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, node2 failed", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
        this.incrementAndTestNodeProperty(ps, "extraA", "counter", 1);
        usr.startActivity(project, "extraA");
        usr.terminateActivity(project, "extraA");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, node2 failed", (ps.getNodeValue("node2").getState() == 1 ? 1 : 0) != 0);
        for (int index = 0; index < 2; ++index) {
            this.incrementAndTestNodeProperty(ps, "node2", "counter", 2 + index);
            usr.startActivity(project, "node2");
            usr.terminateActivity(project, "node2");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node2: node2 failed", (ps.getNodeValue("node2").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node2: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
            this.incrementAndTestNodeProperty(ps, "node3", "counter", 3 + index);
            usr.startActivity(project, "node3");
            usr.terminateActivity(project, "node3");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: node0 failed", (ps.getNodeValue("node0").getState() == 1 ? 1 : 0) != 0);
            try {
                IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: node1 failed", (ps.getNodeValue("node1").getState() == 0 ? 1 : 0) != 0);
                IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, node1 should not be instantiated yet", (boolean)false);
            }
            catch (Exception e) {
                // empty catch block
            }
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: initial failed", (ps.getNodeValue("initial").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: node2 failed", (ps.getNodeValue("node2").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: node3 failed", (ps.getNodeValue("node3").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        }
        this.incrementAndTestNodeProperty(ps, "node2", "counter", 4);
        usr.startActivity(project, "node2");
        usr.terminateActivity(project, "node2");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node2: node2 failed", (ps.getNodeValue("node2").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node2: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
        this.incrementAndTestNodeProperty(ps, "node3", "counter", 5);
        usr.startActivity(project, "node3");
        ps.setProperty("iterate", "false");
        usr.terminateActivity(project, "node3");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: initial failed", (ps.getNodeValue("initial").getState() == 1 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: node0 failed", (ps.getNodeValue("node0").getState() == 1 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: node2 failed", (ps.getNodeValue("node2").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: node3 failed", (ps.getNodeValue("node3").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node3: node4 failed", (ps.getNodeValue("node4").getState() == 1 ? 1 : 0) != 0);
        this.incrementAndTestNodeProperty(ps, "node4", "counter", 6);
        usr.startActivity(project, "node4");
        usr.terminateActivity(project, "node4");
        try {
            this.incrementAndTestNodeProperty(ps, "node0", "counter", 6);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, node node0 : 'counter' nodeProperty it would not have to be defined here", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        usr.startActivity(project, "node0");
        usr.terminateActivity(project, "node0");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node0: node0 failed", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node0: node1 failed", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
        try {
            this.incrementAndTestNodeProperty(ps, "node1", "counter", 7);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, node node1 : 'counter' nodeProperty it would not have to be defined here", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        usr.startActivity(project, "node1");
        usr.terminateActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node1: initial failed", (ps.getNodeValue("initial").getState() == 1 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node1: node0 failed", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node1: node2 failed", (ps.getNodeValue("node2").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node1: extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node1: extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, terminateActivity node1: extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        try {
            this.incrementAndTestNodeProperty(ps, "initial", "counter", 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple3, node initial : 'counter' nodeProperty it would not have to be defined here", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        usr.startActivity(project, "initial");
        usr.terminateActivity(project, "initial");
    }

    public void testExtraEntryPointsSimple4() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("ExtraEntryPointsSimple4");
        ps.setProperty("condA", "false");
        ps.setProperty("condB", "true");
        ps.setProperty("condC", "false");
        ps.setProperty("cond1", "false");
        ps.setProperty("iterate", "true");
        ps.addNode("node1", 4);
        ps.addNode("node2", 4);
        ps.addNode("node3", 1);
        ps.addNode("node4", 1);
        ps.addNode("extraA", 2);
        ps.addNode("extraB", 2);
        ps.addNode("extraC", 2);
        ps.setNodeTraditional("node1");
        ps.setNodeTraditional("node2");
        ps.setNodeTraditional("node3");
        ps.setNodeTraditional("node4");
        ps.setNodeTraditional("extraA");
        ps.setNodeTraditional("extraB");
        ps.setNodeTraditional("extraC");
        String from1to2 = ps.addEdge("node1", "node2");
        ps.addEdge("node2", "node3");
        String from3to4 = ps.addEdge("node3", "node4");
        String fromAto2 = ps.addEdge("extraA", "node2");
        String fromBto2 = ps.addEdge("extraB", "node2");
        String fromCto2 = ps.addEdge("extraC", "node2");
        ps.setEdgeCondition(from1to2, "cond1.equals(\"true\")");
        ps.setEdgeCondition(from3to4, "iterate.equals(\"false\")");
        ps.setEdgeCondition(fromAto2, "condA.equals(\"true\")");
        ps.setEdgeCondition(fromBto2, "condB.equals(\"true\")");
        ps.setEdgeCondition(fromCto2, "condC.equals(\"true\")");
        ps.addIteration("node3", "node1", "iterate.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("ExtraEntryPointsSimple4");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4 node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
        usr.startActivity(project, "extraC");
        usr.terminateActivity(project, "extraC");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity extraC: extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity extraC: node2 failed", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
        usr.startActivity(project, "extraA");
        usr.terminateActivity(project, "extraA");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity extraA: extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity extraA: node2 failed", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
        usr.startActivity(project, "extraB");
        usr.terminateActivity(project, "extraB");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity extraB: extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity extraB: node2 failed", (ps.getNodeValue("node2").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity extraB: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
        for (int index = 0; index < 2; ++index) {
            usr.startActivity(project, "node3");
            usr.terminateActivity(project, "node3");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: node2 failed", (ps.getNodeValue("node2").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        }
        usr.startActivity(project, "node3");
        ps.setProperty("iterate", "false");
        usr.terminateActivity(project, "node3");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: node2 failed", (ps.getNodeValue("node2").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: node3 failed", (ps.getNodeValue("node3").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: node4 failed", (ps.getNodeValue("node4").getState() == 1 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple4, terminateActivity node3: extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        usr.startActivity(project, "node4");
        usr.terminateActivity(project, "node4");
    }

    public void testExtraEntryPointsSimple5() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("ExtraEntryPointsSimple5");
        ps.setProperty("condA", "false");
        ps.setProperty("condB", "false");
        ps.setProperty("condC", "false");
        ps.setProperty("cond1", "false");
        ps.setProperty("iterate", "true");
        ps.addNode("node1", 4);
        ps.addNode("node2", 4);
        ps.addNode("node3", 1);
        ps.addNode("node4", 1);
        ps.addNode("extraA", 2);
        ps.addNode("extraB", 2);
        ps.addNode("extraC", 2);
        ps.setNodeTraditional("node1");
        ps.setNodeTraditional("node2");
        ps.setNodeTraditional("node3");
        ps.setNodeTraditional("node4");
        ps.setNodeTraditional("extraA");
        ps.setNodeTraditional("extraB");
        ps.setNodeTraditional("extraC");
        String from1to2 = ps.addEdge("node1", "node2");
        ps.addEdge("node2", "node3");
        String from3to4 = ps.addEdge("node3", "node4");
        String fromAto2 = ps.addEdge("extraA", "node2");
        String fromBto2 = ps.addEdge("extraB", "node2");
        String fromCto2 = ps.addEdge("extraC", "node2");
        ps.setEdgeCondition(from1to2, "cond1.equals(\"true\")");
        ps.setEdgeCondition(from3to4, "iterate.equals(\"false\")");
        ps.setEdgeCondition(fromAto2, "condA.equals(\"true\")");
        ps.setEdgeCondition(fromBto2, "condB.equals(\"true\")");
        ps.setEdgeCondition(fromCto2, "condC.equals(\"true\")");
        ps.addIteration("node3", "node1", "iterate.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("ExtraEntryPointsSimple5");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple5 node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
        usr.startActivity(project, "extraC");
        usr.terminateActivity(project, "extraC");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple5, terminateActivity extraC: extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple5, terminateActivity extraC: node2 failed", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
        usr.startActivity(project, "extraA");
        usr.terminateActivity(project, "extraA");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple5, terminateActivity extraA: extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsSimple5, terminateActivity extraA: node2 failed", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
        usr.startActivity(project, "extraB");
        usr.terminateActivity(project, "extraB");
    }

    public void testExtraEntryPointsBig1() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("ExtraEntryPointsBig1");
        ps.setProperty("condA", "true");
        ps.setProperty("iterate", "true");
        ps.addNode("node0", 1);
        ps.addNode("node1", 1);
        ps.addNode("node2", 1);
        ps.addNode("node3", 1);
        ps.addNode("node4", 1);
        ps.addNode("node5", 1);
        ps.addNode("node5A", 1);
        ps.addNode("node5B", 1);
        ps.addNode("node6", 1);
        ps.addNode("node7", 1);
        ps.addNode("node8", 3);
        ps.addNode("node9", 3);
        ps.addNode("extraA", 1);
        ps.addNode("extraB", 1);
        ps.addNode("extraC", 1);
        ps.addNode("extraA0", 3);
        ps.addNode("extraB0", 3);
        ps.addNode("extraB1", 3);
        ps.addNode("extraC0", 3);
        ps.addNode("extraC1", 3);
        ps.addNode("extraC2", 3);
        ps.addNode("extraZ0", 3);
        ps.addNode("extraZ1", 3);
        ps.addNode("extraZ2", 3);
        ps.setNodeTraditional("node0");
        ps.setNodeTraditional("node1");
        ps.setNodeTraditional("node2");
        ps.setNodeTraditional("node3");
        ps.setNodeTraditional("node4");
        ps.setNodeTraditional("node5");
        ps.setNodeTraditional("node5A");
        ps.setNodeTraditional("node5B");
        ps.setNodeTraditional("node6");
        ps.setNodeTraditional("node7");
        ps.setNodeTraditional("node8");
        ps.setNodeTraditional("node9");
        ps.setNodeTraditional("extraA");
        ps.setNodeTraditional("extraB");
        ps.setNodeTraditional("extraC");
        ps.setNodeTraditional("extraA0");
        ps.setNodeTraditional("extraB0");
        ps.setNodeTraditional("extraB1");
        ps.setNodeTraditional("extraC0");
        ps.setNodeTraditional("extraC1");
        ps.setNodeTraditional("extraC2");
        ps.setNodeTraditional("extraZ0");
        ps.setNodeTraditional("extraZ1");
        ps.setNodeTraditional("extraZ2");
        ps.addEdge("node0", "node1");
        ps.addEdge("node1", "node3");
        ps.addEdge("node1", "node4");
        ps.addEdge("node1", "node5");
        String from3to6 = ps.addEdge("node3", "node6");
        String from3to8 = ps.addEdge("node3", "node8");
        String from4to2 = ps.addEdge("node4", "node2");
        String from4to6 = ps.addEdge("node4", "node6");
        ps.addEdge("node5", "node4");
        ps.addEdge("node5", "node6");
        ps.addEdge("node5", "node5A");
        ps.addEdge("node5A", "node5B");
        ps.addEdge("node5B", "node6");
        String from6to7 = ps.addEdge("node6", "node7");
        ps.addEdge("node8", "node9");
        String fromAto3 = ps.addEdge("extraA", "node3");
        ps.addEdge("extraB", "node3");
        ps.addEdge("extraC", "node3");
        ps.addEdge("extraA0", "extraA");
        ps.addEdge("extraB0", "extraB");
        ps.addEdge("extraB1", "extraB");
        ps.addEdge("extraC0", "extraC");
        ps.addEdge("extraC1", "extraC");
        ps.addEdge("extraC2", "extraC");
        ps.addEdge("extraZ0", "node5B");
        ps.addEdge("extraZ1", "node5B");
        ps.addEdge("extraZ2", "node5B");
        ps.setEdgeCondition(from3to6, "iterate.equals(\"true\")");
        ps.setEdgeCondition(from4to6, "iterate.equals(\"true\")");
        ps.setEdgeCondition(from3to8, "iterate.equals(\"false\")");
        ps.setEdgeCondition(from4to2, "iterate.equals(\"false\")");
        ps.setEdgeCondition(from6to7, "iterate.equals(\"false\")");
        ps.setEdgeCondition(fromAto3, "condA.equals(\"true\")");
        ps.addIteration("node6", "node1", "iterate.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("ExtraEntryPointsBig1");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, extraA0 failed", (ps.getNodeValue("extraA0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, extraB0 failed", (ps.getNodeValue("extraB0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, extraB1 failed", (ps.getNodeValue("extraB1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, extraC0 failed", (ps.getNodeValue("extraC0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, extraC1 failed", (ps.getNodeValue("extraC1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, extraC2 failed", (ps.getNodeValue("extraC2").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, extraZ0 failed", (ps.getNodeValue("extraZ0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, extraZ1 failed", (ps.getNodeValue("extraZ1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, extraZ2 failed", (ps.getNodeValue("extraZ2").getState() == 10 ? 1 : 0) != 0);
        usr.startActivity(project, "extraA");
        usr.startActivity(project, "extraB");
        usr.startActivity(project, "extraC");
        usr.terminateActivity(project, "extraC");
        usr.terminateActivity(project, "extraB");
        usr.terminateActivity(project, "extraA");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        usr.startActivity(project, "node0");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, startActivity node0: node0 failed", (ps.getNodeValue("node0").getState() == 6 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, startActivity node0: node1 failed", (ps.getNodeValue("node1").getState() == 0 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node0");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node0: node0 failed", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node0: node1 failed", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
        for (int index = 0; index < 2; ++index) {
            usr.startActivity(project, "node1");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, startActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, startActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, startActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, startActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 0 ? 1 : 0) != 0);
            usr.terminateActivity(project, "node1");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 1 ? 1 : 0) != 0);
            usr.startActivity(project, "node3");
            usr.terminateActivity(project, "node3");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node3: node8 failed", (ps.getNodeValue("node8").getState() == 2 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node3: node9 failed", (ps.getNodeValue("node9").getState() == 2 ? 1 : 0) != 0);
            usr.startActivity(project, "node5");
            usr.terminateActivity(project, "node5");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 1 ? 1 : 0) != 0);
            usr.startActivity(project, "node4");
            usr.terminateActivity(project, "node4");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node4: node2 failed", (ps.getNodeValue("node2").getState() == 2 ? 1 : 0) != 0);
            try {
                usr.startActivity(project, "node2");
                IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, startActivity node2: node2 should be failed", (boolean)false);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                usr.terminateActivity(project, "node2");
                IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node2: node2 should be failed", (boolean)false);
            }
            catch (Exception e) {
                // empty catch block
            }
            usr.startActivity(project, "node5A");
            usr.terminateActivity(project, "node5A");
            usr.startActivity(project, "node5B");
            usr.terminateActivity(project, "node5B");
            usr.startActivity(project, "node6");
            usr.terminateActivity(project, "node6");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: node0 failed", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: node1 failed", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: node2 failed", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: node3 failed", (ps.getNodeValue("node3").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: node5 failed", (ps.getNodeValue("node5").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: node5A failed", (ps.getNodeValue("node5A").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: node5B failed", (ps.getNodeValue("node5B").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: node6 failed", (ps.getNodeValue("node6").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: node7 failed", (ps.getNodeValue("node7").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: node8 failed", (ps.getNodeValue("node8").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: node9 failed", (ps.getNodeValue("node9").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: extraA0 failed", (ps.getNodeValue("extraA0").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: extraB0 failed", (ps.getNodeValue("extraB0").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: extraB1 failed", (ps.getNodeValue("extraB1").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: extraC0 failed", (ps.getNodeValue("extraC0").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: extraC1 failed", (ps.getNodeValue("extraC1").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: extraC2 failed", (ps.getNodeValue("extraC2").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: extraZ0 failed", (ps.getNodeValue("extraZ0").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: extraZ1 failed", (ps.getNodeValue("extraZ1").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6: extraZ2 failed", (ps.getNodeValue("extraZ2").getState() == 10 ? 1 : 0) != 0);
        }
        usr.startActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, startActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, startActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 0 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, startActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, startActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 0 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node3");
        usr.terminateActivity(project, "node3");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node3: node8 failed", (ps.getNodeValue("node8").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node3: node9 failed", (ps.getNodeValue("node9").getState() == 2 ? 1 : 0) != 0);
        usr.startActivity(project, "node5");
        usr.terminateActivity(project, "node5");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node4");
        usr.terminateActivity(project, "node4");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node4: node2 failed", (ps.getNodeValue("node2").getState() == 2 ? 1 : 0) != 0);
        usr.startActivity(project, "node5A");
        usr.terminateActivity(project, "node5A");
        usr.startActivity(project, "node5B");
        usr.terminateActivity(project, "node5B");
        ps.setProperty("iterate", "false");
        usr.startActivity(project, "node6");
        usr.terminateActivity(project, "node6");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6, after iterate: node6 failed", (ps.getNodeValue("node6").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig1, terminateActivity node6, after iterate: node7 failed", (ps.getNodeValue("node7").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node7");
        usr.terminateActivity(project, "node7");
    }

    public void testExtraEntryPointsBig2() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("ExtraEntryPointsBig2");
        ps.setProperty("condA", "false");
        ps.setProperty("iterate", "true");
        ps.addNode("node0", 1);
        ps.addNode("node1", 1);
        ps.addNode("node2", 1);
        ps.addNode("node3", 3);
        ps.addNode("node4", 1);
        ps.addNode("node5", 1);
        ps.addNode("node5A", 1);
        ps.addNode("node5B", 1);
        ps.addNode("node6", 1);
        ps.addNode("node7", 1);
        ps.addNode("node8", 3);
        ps.addNode("node9", 3);
        ps.addNode("extraA", 1);
        ps.addNode("extraB", 1);
        ps.addNode("extraC", 1);
        ps.addNode("extraA0", 3);
        ps.addNode("extraB0", 3);
        ps.addNode("extraB1", 3);
        ps.addNode("extraC0", 3);
        ps.addNode("extraC1", 3);
        ps.addNode("extraC2", 3);
        ps.addNode("extraZ0", 3);
        ps.addNode("extraZ1", 3);
        ps.addNode("extraZ2", 3);
        ps.setNodeTraditional("node0");
        ps.setNodeTraditional("node1");
        ps.setNodeTraditional("node2");
        ps.setNodeTraditional("node3");
        ps.setNodeTraditional("node4");
        ps.setNodeTraditional("node5");
        ps.setNodeTraditional("node5A");
        ps.setNodeTraditional("node5B");
        ps.setNodeTraditional("node6");
        ps.setNodeTraditional("node7");
        ps.setNodeTraditional("node8");
        ps.setNodeTraditional("node9");
        ps.setNodeTraditional("extraA");
        ps.setNodeTraditional("extraB");
        ps.setNodeTraditional("extraC");
        ps.setNodeTraditional("extraA0");
        ps.setNodeTraditional("extraB0");
        ps.setNodeTraditional("extraB1");
        ps.setNodeTraditional("extraC0");
        ps.setNodeTraditional("extraC1");
        ps.setNodeTraditional("extraC2");
        ps.setNodeTraditional("extraZ0");
        ps.setNodeTraditional("extraZ1");
        ps.setNodeTraditional("extraZ2");
        ps.addEdge("node0", "node1");
        ps.addEdge("node1", "node3");
        ps.addEdge("node1", "node4");
        ps.addEdge("node1", "node5");
        String from3to6 = ps.addEdge("node3", "node6");
        String from3to8 = ps.addEdge("node3", "node8");
        String from4to2 = ps.addEdge("node4", "node2");
        String from4to6 = ps.addEdge("node4", "node6");
        ps.addEdge("node5", "node4");
        ps.addEdge("node5", "node6");
        ps.addEdge("node5", "node5A");
        ps.addEdge("node5A", "node5B");
        ps.addEdge("node5B", "node6");
        String from6to7 = ps.addEdge("node6", "node7");
        ps.addEdge("node8", "node9");
        String fromAto3 = ps.addEdge("extraA", "node3");
        ps.addEdge("extraB", "node3");
        ps.addEdge("extraC", "node3");
        ps.addEdge("extraA0", "extraA");
        ps.addEdge("extraB0", "extraB");
        ps.addEdge("extraB1", "extraB");
        ps.addEdge("extraC0", "extraC");
        ps.addEdge("extraC1", "extraC");
        ps.addEdge("extraC2", "extraC");
        ps.addEdge("extraZ0", "node5B");
        ps.addEdge("extraZ1", "node5B");
        ps.addEdge("extraZ2", "node5B");
        ps.setEdgeCondition(from3to6, "iterate.equals(\"true\")");
        ps.setEdgeCondition(from4to6, "iterate.equals(\"true\")");
        ps.setEdgeCondition(from3to8, "iterate.equals(\"false\")");
        ps.setEdgeCondition(from4to2, "iterate.equals(\"false\")");
        ps.setEdgeCondition(from6to7, "iterate.equals(\"false\")");
        ps.setEdgeCondition(fromAto3, "condA.equals(\"true\")");
        ps.addIteration("node6", "node1", "iterate.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("ExtraEntryPointsBig2");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, extraA0 failed", (ps.getNodeValue("extraA0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, extraB0 failed", (ps.getNodeValue("extraB0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, extraB1 failed", (ps.getNodeValue("extraB1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, extraC0 failed", (ps.getNodeValue("extraC0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, extraC1 failed", (ps.getNodeValue("extraC1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, extraC2 failed", (ps.getNodeValue("extraC2").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, extraZ0 failed", (ps.getNodeValue("extraZ0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, extraZ1 failed", (ps.getNodeValue("extraZ1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, extraZ2 failed", (ps.getNodeValue("extraZ2").getState() == 10 ? 1 : 0) != 0);
        usr.startActivity(project, "extraA");
        usr.terminateActivity(project, "extraA");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, node3 failed", (ps.getNodeValue("node3").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, node8 failed", (ps.getNodeValue("node8").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, node9 failed", (ps.getNodeValue("node9").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, node6 failed", (ps.getNodeValue("node6").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, node7 failed", (ps.getNodeValue("node7").getState() == 2 ? 1 : 0) != 0);
        usr.startActivity(project, "extraB");
        usr.terminateActivity(project, "extraB");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
        usr.startActivity(project, "extraC");
        usr.terminateActivity(project, "extraC");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        usr.startActivity(project, "node0");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, startActivity node0: node0 failed", (ps.getNodeValue("node0").getState() == 6 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, startActivity node0: node1 failed", (ps.getNodeValue("node1").getState() == 0 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node0");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node0: node0 failed", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node0: node1 failed", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, startActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, startActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, startActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, startActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 0 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 1 ? 1 : 0) != 0);
        try {
            usr.startActivity(project, "node3");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, startActivity node3 is not possible", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            usr.terminateActivity(project, "node3");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node3 is not possible", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, node8 failed", (ps.getNodeValue("node8").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, node9 failed", (ps.getNodeValue("node9").getState() == 2 ? 1 : 0) != 0);
        usr.startActivity(project, "node5");
        usr.terminateActivity(project, "node5");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node4");
        usr.terminateActivity(project, "node4");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node4: node2 failed", (ps.getNodeValue("node2").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node6, after iterate: node6 failed", (ps.getNodeValue("node6").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node6, after iterate: node7 failed", (ps.getNodeValue("node7").getState() == 2 ? 1 : 0) != 0);
        usr.startActivity(project, "node5A");
        usr.terminateActivity(project, "node5A");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node5A: node5A failed", (ps.getNodeValue("node5A").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node5A: node5B failed", (ps.getNodeValue("node5B").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node5B");
        usr.terminateActivity(project, "node5B");
        try {
            usr.startActivity(project, "node6");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, startActivity node6 is not possible", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            usr.terminateActivity(project, "node6");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node6 is not possible", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            usr.startActivity(project, "node7");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, startActivity node7 is not possible", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            usr.terminateActivity(project, "node7");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig2, terminateActivity node7 is not possible", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testExtraEntryPointsBig3() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("ExtraEntryPointsBig3");
        ps.setProperty("iterate", "true");
        ps.setProperty("condA", "false");
        ps.setProperty("condB", "true");
        ps.setProperty("condC", "false");
        ps.setProperty("condZ0", "false");
        ps.setProperty("condZ1", "false");
        ps.setProperty("condZ2", "true");
        ps.setProperty("cond1", "false");
        ps.addNode("node0", 1);
        ps.addNode("node1", 1);
        ps.addNode("node2", 1);
        ps.addNode("node3", 2);
        ps.addNode("node4", 1);
        ps.addNode("node5", 1);
        ps.addNode("node5A", 1);
        ps.addNode("node5B", 4);
        ps.addNode("node6", 1);
        ps.addNode("node7", 1);
        ps.addNode("node8", 3);
        ps.addNode("node9", 3);
        ps.addNode("extraA", 1);
        ps.addNode("extraB", 1);
        ps.addNode("extraC", 1);
        ps.addNode("extraA0", 3);
        ps.addNode("extraB0", 3);
        ps.addNode("extraB1", 3);
        ps.addNode("extraC0", 3);
        ps.addNode("extraC1", 3);
        ps.addNode("extraC2", 3);
        ps.addNode("extraZ0", 3);
        ps.addNode("extraZ1", 3);
        ps.addNode("extraZ2", 3);
        ps.setNodeTraditional("node0");
        ps.setNodeTraditional("node1");
        ps.setNodeTraditional("node2");
        ps.setNodeTraditional("node3");
        ps.setNodeTraditional("node4");
        ps.setNodeTraditional("node5");
        ps.setNodeTraditional("node5A");
        ps.setNodeTraditional("node5B");
        ps.setNodeTraditional("node6");
        ps.setNodeTraditional("node7");
        ps.setNodeTraditional("node8");
        ps.setNodeTraditional("node9");
        ps.setNodeTraditional("extraA");
        ps.setNodeTraditional("extraB");
        ps.setNodeTraditional("extraC");
        ps.setNodeTraditional("extraA0");
        ps.setNodeTraditional("extraB0");
        ps.setNodeTraditional("extraB1");
        ps.setNodeTraditional("extraC0");
        ps.setNodeTraditional("extraC1");
        ps.setNodeTraditional("extraC2");
        ps.setNodeTraditional("extraZ0");
        ps.setNodeTraditional("extraZ1");
        ps.setNodeTraditional("extraZ2");
        ps.addEdge("node0", "node1");
        String from1to3 = ps.addEdge("node1", "node3");
        ps.addEdge("node1", "node4");
        ps.addEdge("node1", "node5");
        String from3to6 = ps.addEdge("node3", "node6");
        String from3to8 = ps.addEdge("node3", "node8");
        String from4to2 = ps.addEdge("node4", "node2");
        String from4to6 = ps.addEdge("node4", "node6");
        ps.addEdge("node5", "node4");
        ps.addEdge("node5", "node6");
        ps.addEdge("node5", "node5A");
        ps.addEdge("node5A", "node5B");
        ps.addEdge("node5B", "node6");
        String from6to7 = ps.addEdge("node6", "node7");
        ps.addEdge("node8", "node9");
        String fromAto3 = ps.addEdge("extraA", "node3");
        String fromBto3 = ps.addEdge("extraB", "node3");
        String fromCto3 = ps.addEdge("extraC", "node3");
        ps.addEdge("extraA0", "extraA");
        ps.addEdge("extraB0", "extraB");
        ps.addEdge("extraB1", "extraB");
        ps.addEdge("extraC0", "extraC");
        ps.addEdge("extraC1", "extraC");
        ps.addEdge("extraC2", "extraC");
        String fromZ0to5B = ps.addEdge("extraZ0", "node5B");
        String fromZ1to5B = ps.addEdge("extraZ1", "node5B");
        String fromZ2to5B = ps.addEdge("extraZ2", "node5B");
        ps.setEdgeCondition(from3to6, "iterate.equals(\"true\")");
        ps.setEdgeCondition(from4to6, "iterate.equals(\"true\")");
        ps.setEdgeCondition(from3to8, "iterate.equals(\"false\")");
        ps.setEdgeCondition(from4to2, "iterate.equals(\"false\")");
        ps.setEdgeCondition(from6to7, "iterate.equals(\"false\")");
        ps.setEdgeCondition(fromAto3, "condA.equals(\"true\")");
        ps.setEdgeCondition(fromBto3, "condB.equals(\"true\")");
        ps.setEdgeCondition(fromCto3, "condC.equals(\"true\")");
        ps.setEdgeCondition(fromZ0to5B, "condZ0.equals(\"true\")");
        ps.setEdgeCondition(fromZ1to5B, "condZ1.equals(\"true\")");
        ps.setEdgeCondition(fromZ2to5B, "condZ2.equals(\"true\")");
        ps.setEdgeCondition(from1to3, "cond1.equals(\"true\")");
        ps.addIteration("node6", "node1", "iterate.equals(\"true\")");
        ps.checkModelDefinition();
        ps.setUserRole("admin", "InitialRole");
        String project = ps.instantiateProject("ExtraEntryPointsBig3");
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, extraA0 failed", (ps.getNodeValue("extraA0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, extraB0 failed", (ps.getNodeValue("extraB0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, extraB1 failed", (ps.getNodeValue("extraB1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, extraC0 failed", (ps.getNodeValue("extraC0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, extraC1 failed", (ps.getNodeValue("extraC1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, extraC2 failed", (ps.getNodeValue("extraC2").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, extraZ0 failed", (ps.getNodeValue("extraZ0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, extraZ1 failed", (ps.getNodeValue("extraZ1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, extraZ2 failed", (ps.getNodeValue("extraZ2").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node5B failed", (ps.getNodeValue("node5B").getState() == 10 ? 1 : 0) != 0);
        usr.startActivity(project, "extraA");
        usr.startActivity(project, "extraB");
        usr.startActivity(project, "extraC");
        usr.terminateActivity(project, "extraA");
        usr.terminateActivity(project, "extraB");
        usr.terminateActivity(project, "extraC");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node0");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, startActivity node0: node0 failed", (ps.getNodeValue("node0").getState() == 6 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, startActivity node0: node1 failed", (ps.getNodeValue("node1").getState() == 0 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node0");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node0: node0 failed", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node0: node1 failed", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
        for (int index = 0; index < 2; ++index) {
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, node6 failed", (ps.getNodeValue("node6").getState() == 0 ? 1 : 0) != 0);
            usr.startActivity(project, "node3");
            usr.terminateActivity(project, "node3");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node3 failed", (ps.getNodeValue("node3").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, node6 failed", (ps.getNodeValue("node6").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node3: node8 failed", (ps.getNodeValue("node8").getState() == 2 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node3: node9 failed", (ps.getNodeValue("node9").getState() == 2 ? 1 : 0) != 0);
            usr.startActivity(project, "node1");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, startActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, startActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, startActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, startActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 0 ? 1 : 0) != 0);
            usr.terminateActivity(project, "node1");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 1 ? 1 : 0) != 0);
            try {
                usr.startActivity(project, "node3");
                IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, startActivity node3 is not possible", (boolean)false);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                usr.terminateActivity(project, "node3");
                IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node3 is not possible", (boolean)false);
            }
            catch (Exception e) {
                // empty catch block
            }
            usr.startActivity(project, "node5");
            usr.terminateActivity(project, "node5");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node5: node5 failed", (ps.getNodeValue("node5").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node5: node4 failed", (ps.getNodeValue("node4").getState() == 1 ? 1 : 0) != 0);
            usr.startActivity(project, "node4");
            usr.terminateActivity(project, "node4");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node4: node4 failed", (ps.getNodeValue("node4").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node4: node2 failed", (ps.getNodeValue("node2").getState() == 2 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node4: node6 failed", (ps.getNodeValue("node6").getState() == 1 ? 1 : 0) != 0);
            try {
                usr.startActivity(project, "node2");
                IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, startActivity node2: node2 should be failed", (boolean)false);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                usr.terminateActivity(project, "node2");
                IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node2: node2 should be failed", (boolean)false);
            }
            catch (Exception e) {
                // empty catch block
            }
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, before startActivity node5A: node5B failed", (ps.getNodeValue("node5B").getState() == 10 ? 1 : 0) != 0);
            usr.startActivity(project, "node5A");
            usr.terminateActivity(project, "node5A");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, after terminateActivity node5A: node5A failed", (ps.getNodeValue("node5A").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, after terminateActivity node5A: node5B failed", (ps.getNodeValue("node5B").getState() == 10 ? 1 : 0) != 0);
            usr.startActivity(project, "node6");
            usr.terminateActivity(project, "node6");
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node0 failed", (ps.getNodeValue("node0").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node1 failed", (ps.getNodeValue("node1").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node2 failed", (ps.getNodeValue("node2").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node3 failed", (ps.getNodeValue("node3").getState() == 1 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node5 failed", (ps.getNodeValue("node5").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node5A failed", (ps.getNodeValue("node5A").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node5B failed", (ps.getNodeValue("node5B").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node6 failed", (ps.getNodeValue("node6").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node7 failed", (ps.getNodeValue("node7").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node8 failed", (ps.getNodeValue("node8").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node9 failed", (ps.getNodeValue("node9").getState() == 0 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: extraA failed", (ps.getNodeValue("extraA").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: extraB failed", (ps.getNodeValue("extraB").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: extraC failed", (ps.getNodeValue("extraC").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: extraA0 failed", (ps.getNodeValue("extraA0").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: extraB0 failed", (ps.getNodeValue("extraB0").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: extraB1 failed", (ps.getNodeValue("extraB1").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: extraC0 failed", (ps.getNodeValue("extraC0").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: extraC1 failed", (ps.getNodeValue("extraC1").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: extraC2 failed", (ps.getNodeValue("extraC2").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: extraZ0 failed", (ps.getNodeValue("extraZ0").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: extraZ1 failed", (ps.getNodeValue("extraZ1").getState() == 10 ? 1 : 0) != 0);
            IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: extraZ2 failed", (ps.getNodeValue("extraZ2").getState() == 10 ? 1 : 0) != 0);
        }
        usr.startActivity(project, "node3");
        usr.terminateActivity(project, "node3");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node3: node8 failed", (ps.getNodeValue("node8").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node3: node9 failed", (ps.getNodeValue("node9").getState() == 2 ? 1 : 0) != 0);
        usr.startActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, startActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 6 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, startActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, startActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, startActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 0 ? 1 : 0) != 0);
        usr.terminateActivity(project, "node1");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node1: node1 failed", (ps.getNodeValue("node1").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node1: node3 failed", (ps.getNodeValue("node3").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 0 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node1: node5 failed", (ps.getNodeValue("node5").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node5");
        usr.terminateActivity(project, "node5");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node1: node4 failed", (ps.getNodeValue("node4").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node4");
        usr.terminateActivity(project, "node4");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node4: node4 failed", (ps.getNodeValue("node4").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node4: node2 failed", (ps.getNodeValue("node2").getState() == 2 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node4: node6 failed", (ps.getNodeValue("node6").getState() == 1 ? 1 : 0) != 0);
        ps.setProperty("iterate", "false");
        usr.startActivity(project, "node6");
        usr.terminateActivity(project, "node6");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node6 failed", (ps.getNodeValue("node6").getState() == 10 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, terminateActivity node6: node7 failed", (ps.getNodeValue("node7").getState() == 1 ? 1 : 0) != 0);
        usr.startActivity(project, "node7");
        usr.terminateActivity(project, "node7");
        IterationTests.assertTrue((String)"Error in ExtraEntryPointsBig3, before startActivity node5A: node5B failed", (ps.getNodeValue("node5B").getState() == 10 ? 1 : 0) != 0);
        usr.startActivity(project, "node5A");
        usr.terminateActivity(project, "node5A");
    }

    public void testSubProcessesIteration() throws Exception {
        Iterator instances;
        Collection inst;
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps1 = projectSessionh.create();
        ps1.initModel("oneSubProject");
        ps1.addNode("test1", 1);
        ps1.addNode("test2", 1);
        ps1.addEdge("test1", "test2");
        ProjectSession ps = projectSessionh.create();
        ps.initModel("oneTestProject");
        ps.addNode("node1", 1);
        ps.addNode("node3", 1);
        ps.addNodeSubProcess("node2", "oneSubProject");
        ps.addEdge("node1", "node2");
        ps.addEdge("node2", "node3");
        ps.setNodeProperty("node1", "prop", "ok", true);
        ps.addRoleMapper("InitialRole", "roleMapperTest", 1);
        ps.addIteration("node3", "node1", "prop.equals(\"ok\")");
        ps.checkModelDefinition();
        String instName = ps.instantiateProject("oneTestProject");
        UserSessionHome userSessionh = UserSessionUtil.getHome();
        UserSession us = userSessionh.create();
        IterationTests.assertTrue((String)"Error in roleMapper", (boolean)us.getToDoList(instName).contains("node1"));
        String actName = null;
        for (int index = 0; index < 3; ++index) {
            us.startActivity(instName, "node1");
            us.terminateActivity(instName, "node1");
            inst = us.getProjectInstancesNames("oneSubProject");
            instances = inst.iterator();
            actName = (String)instances.next();
            IterationTests.assertTrue((String)"Error in Iteration, subProcess is not reinitialized", (us.getNode(actName, "test1").getState() == 1 ? 1 : 0) != 0);
            us.startActivity(actName, "test1");
            us.terminateActivity(actName, "test1");
            us.startActivity(actName, "test2");
            us.terminateActivity(actName, "test2");
            us.startActivity(instName, "node3");
            us.terminateActivity(instName, "node3");
            IterationTests.assertTrue((String)"Error in Iteration", (boolean)us.getToDoList(instName).contains("node1"));
            IterationTests.assertTrue((String)"Error in Iteration, subProcess is not reinitialized", (boolean)us.getToDoList(actName).isEmpty());
            IterationTests.assertTrue((String)"Error in Iteration, subProcess is not reinitialized", (us.getNode(actName, "test1").getState() == 0 ? 1 : 0) != 0);
        }
        us.startActivity(instName, "node1");
        us.terminateActivity(instName, "node1");
        inst = us.getProjectInstancesNames("oneSubProject");
        instances = inst.iterator();
        actName = (String)instances.next();
        us.startActivity(actName, "test1");
        us.terminateActivity(actName, "test1");
        us.startActivity(actName, "test2");
        us.terminateActivity(actName, "test2");
        us.startActivity(instName, "node3");
        ps.setNodeProperty("node3", "prop", "nok", true);
        us.terminateActivity(instName, "node3");
        try {
            us.getToDoList(instName);
            IterationTests.assertTrue((String)"Should have throw FinderException", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            us.getToDoList(actName);
            IterationTests.assertTrue((String)"Should have throw FinderException", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testSubProcessesIterationOnlySubProcesses() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps1 = projectSessionh.create();
        ps1.initModel("SubProject1");
        ps1.addNode("test1", 1);
        ps1.addNode("test2", 1);
        ps1.addEdge("test1", "test2");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initModel("SubProject2");
        ps2.addNode("test1", 1);
        ps2.addNode("test2", 1);
        ps2.addEdge("test1", "test2");
        ProjectSession ps = projectSessionh.create();
        ps.initModel("MyProjectIte");
        ps.addNodeSubProcess("node1", "SubProject1");
        ps.addNodeSubProcess("node2bis", "SubProject2");
        ps.addEdge("node1", "node2bis");
        ps.setNodeProperty("node1", "prop", "ok", true);
        ps.addRoleMapper("InitialRole", "roleMapperTest", 1);
        ps.addIteration("node2bis", "node1", "prop.equals(\"ok\")");
        ps.checkModelDefinition();
        String instName = ps.instantiateProject("MyProjectIte");
        UserSessionHome userSessionh = UserSessionUtil.getHome();
        UserSession us = userSessionh.create();
        Collection inst = us.getProjectInstancesNames("SubProject1");
        Iterator instances = inst.iterator();
        String actName = (String)instances.next();
        for (int index = 0; index < 3; ++index) {
            us.startActivity(actName, "test1");
            us.terminateActivity(actName, "test1");
            us.startActivity(actName, "test2");
            us.terminateActivity(actName, "test2");
            inst = us.getProjectInstancesNames("SubProject2");
            instances = inst.iterator();
            actName = (String)instances.next();
            us.startActivity(actName, "test1");
            us.terminateActivity(actName, "test1");
            us.startActivity(actName, "test2");
            us.terminateActivity(actName, "test2");
            inst = us.getProjectInstancesNames("SubProject1");
            instances = inst.iterator();
            actName = (String)instances.next();
        }
        us.startActivity(actName, "test1");
        us.terminateActivity(actName, "test1");
        us.startActivity(actName, "test2");
        us.terminateActivity(actName, "test2");
        inst = us.getProjectInstancesNames("SubProject2");
        instances = inst.iterator();
        String actName2 = (String)instances.next();
        us.startActivity(actName2, "test1");
        us.terminateActivity(actName2, "test1");
        us.startActivity(actName2, "test2");
        ps.initProject(actName2);
        ps.setProperty("prop", "nok");
        us.terminateActivity(actName2, "test2");
        IterationTests.assertTrue((String)"Error in SubProcess 1", (us.getProjectInstancesNames("SubProject1").size() == 0 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in SubProcess 2", (us.getProjectInstancesNames("SubProject2").size() == 0 ? 1 : 0) != 0);
        IterationTests.assertTrue((String)"Error in SubProcess 3", (us.getProjectInstancesNames("MyProjectIte").size() == 0 ? 1 : 0) != 0);
    }
}

