/*
 * Decompiled with CFR 0.152.
 */
package hero.client.test;

import hero.interfaces.BnAuthRole;
import hero.interfaces.BnAuthRoleHome;
import hero.interfaces.BnAuthRoleUtil;
import hero.interfaces.BnAuthRoleValue;
import hero.interfaces.BnUser;
import hero.interfaces.BnUserHome;
import hero.interfaces.BnUserUtil;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import hero.interfaces.UserRegistration;
import hero.interfaces.UserRegistrationHome;
import hero.interfaces.UserRegistrationUtil;
import hero.interfaces.UserSession;
import hero.interfaces.UserSessionHome;
import hero.interfaces.UserSessionUtil;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class UserRegistrationTests
extends TestCase {
    public UserRegistrationTests(String testname) {
        super(testname);
    }

    public static TestSuite suite() {
        return new TestSuite(UserRegistrationTests.class);
    }

    public void setUp() throws Exception {
    }

    public void testCreateUser() throws Exception {
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("pouet", "toto", "admin@pouet.com");
        BnUserHome uHome = BnUserUtil.getHome();
        try {
            BnUser user = uHome.findByName("pouet");
        }
        catch (Exception cu) {
            UserRegistrationTests.assertTrue((String)"Should have throw Exception in createUser", (boolean)false);
        }
    }

    public void testCreateAuthRole() throws Exception {
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.roleCreate("pouet", "ADMIN");
        BnAuthRoleHome aHome = BnAuthRoleUtil.getHome();
        try {
            BnAuthRole role = aHome.findByName("pouet");
        }
        catch (Exception cu) {
            UserRegistrationTests.assertTrue((String)"Should have throw Exception in createAuthRole", (boolean)false);
        }
    }

    public void testSetUserRole() throws Exception {
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("testrole", "toto", "admin@pouet.com");
        userReg.roleCreate("roletest", "ADMIN");
        userReg.setUserRole("testrole", "roletest");
        BnUserHome uHome = BnUserUtil.getHome();
        BnUser user = uHome.findByName("testrole");
        BnAuthRoleValue[] roles = user.getBnUserValue().getBnAuthRoles();
        UserRegistrationTests.assertTrue((String)"Should have throw Exception in createUser", (roles.length == 2 ? 1 : 0) != 0);
    }

    public void testDeleteUser() throws Exception {
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("deleteUser", "toto", "admin@pouet.com");
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession pss = projectSessionh.create();
        pss.initProject("oneProject");
        pss.addNode("node1", 1);
        pss.addUser("deleteUser");
        pss.setNodeRole("node1", "deleteUser");
        pss.setUserRole("deleteUser", "admin");
        ProjectSession pss2 = projectSessionh.create();
        pss2.initProject("oneProject2");
        pss2.addUser("deleteUser");
        ProjectSession pss3 = projectSessionh.create();
        pss3.initProject("oneProject3");
        pss3.addUser("deleteUser");
        pss3.addNode("node1", 1);
        pss3.setNodeRole("node1", "deleteUser");
        try {
            userReg.deleteUser("deleteUser");
            UserRegistrationTests.assertTrue((String)"Should have throw EJBException in deleteUser when initial state", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        UserSessionHome usersh = UserSessionUtil.getHome();
        UserSession usr = usersh.create();
        usr.startActivity("oneProject", "node1");
        try {
            userReg.deleteUser("deleteUser");
            UserRegistrationTests.assertTrue((String)"Should have throw EJBException in deleteUser when started activity", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        usr.terminateActivity("oneProject", "node1");
        usr.terminate("oneProject");
        usr.removeProject("oneProject3");
        usr.removeProject("oneProject2");
        try {
            userReg.deleteUser("deleteUser");
        }
        catch (Exception e) {
            UserRegistrationTests.assertTrue((String)("Error in deleteUser: " + e.getMessage()), (boolean)false);
        }
    }
}

