/*
 * Decompiled with CFR 0.152.
 */
package hero.client.test;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.BnNodeLightValue;
import hero.interfaces.BnNodeValue;
import hero.interfaces.BnProject;
import hero.interfaces.BnProjectHome;
import hero.interfaces.BnProjectUtil;
import hero.interfaces.BnUserHome;
import hero.interfaces.BnUserPropertyValue;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import hero.interfaces.UserRegistration;
import hero.interfaces.UserRegistrationHome;
import hero.interfaces.UserRegistrationUtil;
import hero.interfaces.UserSession;
import hero.interfaces.UserSessionHome;
import hero.interfaces.UserSessionUtil;
import hero.util.HeroException;
import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.security.auth.login.LoginContext;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;

public class UserSessionTests
extends TestCase {
    private BnProjectHome projecth;
    private ProjectSessionHome projectsesh;
    private BnUserHome userh;
    private UserSessionHome usersessionh;

    public UserSessionTests(String testname) {
        super(testname);
    }

    public static TestSuite suite() {
        return new TestSuite(UserSessionTests.class);
    }

    public void setUp() throws Exception {
    }

    public void testGetProjectListSession() throws Exception {
        this.projectsesh = ProjectSessionUtil.getHome();
        ProjectSession p = this.projectsesh.create();
        p.initProject("Failure");
        p.addNode("t1", 1);
        p.addNode("t2", 1);
        p.addEdge("t1", "t2");
        this.usersessionh = UserSessionUtil.getHome();
        UserSession usersession = this.usersessionh.create();
        ProjectSession lproj1 = this.projectsesh.create();
        lproj1.initProject("p1SS");
        ProjectSession lproj2 = this.projectsesh.create();
        lproj2.initProject("p2SS");
        System.out.println("usersession home ?" + this.usersessionh);
        System.out.println("usersession ?" + usersession);
        Collection c = usersession.getProjectList();
        UserSessionTests.assertTrue((String)"getProjectList Error", (c.size() != 0 ? 1 : 0) != 0);
        Collection c2 = usersession.getToDoList("p1SS");
        Collection c3 = usersession.getToDoList("p2SS");
        usersession.startActivity("Failure", "t1");
        usersession.startActivity("Failure", "t2");
        usersession.terminateActivity("Failure", "t1");
    }

    public void testGetProjectList() throws Exception {
        this.projectsesh = ProjectSessionUtil.getHome();
        this.usersessionh = UserSessionUtil.getHome();
        UserSession usersession = this.usersessionh.create();
        ProjectSession lproj1 = this.projectsesh.create();
        lproj1.initProject("p1");
        ProjectSession lproj2 = this.projectsesh.create();
        lproj2.initProject("p2");
        System.out.println("usersession home ?" + this.usersessionh);
        System.out.println("usersession ?" + usersession);
        Collection c = usersession.getProjectList();
        UserSessionTests.assertTrue((String)"getProjectList Error", (c.size() != 0 ? 1 : 0) != 0);
    }

    public void testGetToDoList1() throws Exception {
        this.projectsesh = ProjectSessionUtil.getHome();
        this.usersessionh = UserSessionUtil.getHome();
        ProjectSession proj = this.projectsesh.create();
        proj.initProject("p3");
        proj.addNode("name1", 1);
        proj.setUserRole("admin", "InitialRole");
        UserSession usersession = this.usersessionh.create();
        Collection c = usersession.getToDoList("p3");
        Iterator i = c.iterator();
        UserSessionTests.assertTrue((String)"getToDoList Error", (boolean)((String)i.next()).equals("name1"));
    }

    public void testGetToDoList2() throws Exception {
        this.projectsesh = ProjectSessionUtil.getHome();
        this.usersessionh = UserSessionUtil.getHome();
        ProjectSession proj = this.projectsesh.create();
        proj.initProject("p4");
        proj.addNode("name1", 1);
        proj.addNode("name2", 1);
        proj.setUserRole("admin", "InitialRole");
        UserSession usersession = this.usersessionh.create();
        Collection c = usersession.getToDoList("p4");
        Iterator i = c.iterator();
        String node1 = (String)i.next();
        String node2 = (String)i.next();
        UserSessionTests.assertTrue((String)"getToDoList Error", (node1.equals("name1") || node1.equals("name2") ? 1 : 0) != 0);
        UserSessionTests.assertTrue((String)"getToDoList Error", (node2.equals("name1") || node2.equals("name2") ? 1 : 0) != 0);
    }

    public void testGetActivityList() throws Exception {
        this.projectsesh = ProjectSessionUtil.getHome();
        this.usersessionh = UserSessionUtil.getHome();
        ProjectSession proj = this.projectsesh.create();
        proj.initProject("p5");
        proj.addNode("NodeExecuting", 1);
        proj.setUserRole("admin", "InitialRole");
        UserSession usersession = this.usersessionh.create();
        Collection c = usersession.getActivityList("p5");
        UserSessionTests.assertTrue((String)"getActivityList Error", (c.size() == 0 ? 1 : 0) != 0);
        usersession.startActivity("p5", "NodeExecuting");
        c = usersession.getActivityList("p5");
        Iterator i = c.iterator();
        UserSessionTests.assertTrue((String)"getActivityList Error", (boolean)((String)i.next()).equals("NodeExecuting"));
    }

    public void testGetNode() throws Exception {
        this.projectsesh = ProjectSessionUtil.getHome();
        this.usersessionh = UserSessionUtil.getHome();
        ProjectSession proj = this.projectsesh.create();
        proj.initProject("testgetnode");
        proj.addNode("pouet", 1);
        UserSession usr = this.usersessionh.create();
        try {
            BnNodeValue nv = usr.getNode("testgetnode", "pouet");
        }
        catch (HeroException h) {
            UserSessionTests.assertTrue((String)"Should be a success", (boolean)false);
        }
    }

    public void testProperty() throws Exception {
        this.usersessionh = UserSessionUtil.getHome();
        UserSession usr = this.usersessionh.create();
        usr.setUserProperty("prop1", "val1");
        usr.setUserProperty("prop2", "val2");
        usr.setUserProperty("prop3", "val3");
    }

    public void testDeleteProperty() throws Exception {
        this.usersessionh = UserSessionUtil.getHome();
        UserSession usr = this.usersessionh.create();
        usr.deleteUserProperty("prop2");
        usr.deleteUserProperty("prop3");
    }

    public void testGetProperties() throws Exception {
        this.usersessionh = UserSessionUtil.getHome();
        UserSession usr = this.usersessionh.create();
        Collection c = usr.getUserProperties();
        for (BnUserPropertyValue p : c) {
            String key = p.getTheKey();
            String value = p.getTheValue();
            UserSessionTests.assertTrue((String)"Get Properties", (boolean)key.equalsIgnoreCase("prop1"));
        }
    }

    public void testSpeedCheckOneCallRMI() throws Exception {
        this.usersessionh = UserSessionUtil.getHome();
        UserSession usr = this.usersessionh.create();
        usr.getUser();
        usr.getUserPassword();
    }

    public void testSpeedCheckTenCallRMI() throws Exception {
        this.usersessionh = UserSessionUtil.getHome();
        UserSession usr = this.usersessionh.create();
        for (int i = 0; i < 10; ++i) {
            usr.getUser();
            usr.getUserPassword();
        }
    }

    public void testSpeedCheckOneCallSOAP() throws Exception {
        String endpoint = System.getProperty("bonita.host") + "/bonita_ws/services/UserSession";
        Service service = new Service();
        Call call = (Call)service.createCall();
        call.setTargetEndpointAddress(new URL(endpoint));
        call.setMaintainSession(true);
        call.setUsername("admin");
        call.setPassword("toto");
        call.setOperationName("getUser");
        String resp = (String)call.invoke(new Object[0]);
        call.setOperationName("getUserPassword");
        String ret2 = (String)call.invoke(new Object[0]);
    }

    public void testSpeedCheckTenCallSOAP() throws Exception {
        String endpoint = System.getProperty("bonita.host") + "/bonita_ws/services/UserSession";
        Service service = new Service();
        Call call = (Call)service.createCall();
        call.setTargetEndpointAddress(new URL(endpoint));
        call.setMaintainSession(true);
        call.setUsername("admin");
        call.setPassword("toto");
        for (int i = 0; i < 10; ++i) {
            call.setOperationName("getUser");
            String resp = (String)call.invoke(new Object[0]);
            call.setOperationName("getUserPassword");
            String ret2 = (String)call.invoke(new Object[0]);
        }
    }

    public void testGetProjectInstances() throws Exception {
        this.projectsesh = ProjectSessionUtil.getHome();
        ProjectSession p = this.projectsesh.create();
        p.initModel("GPI");
        p.initModel("GPIGPI");
        String name1 = p.instantiateProject("GPI");
        String name2 = p.instantiateProject("GPI");
        this.usersessionh = UserSessionUtil.getHome();
        UserSession usr = this.usersessionh.create();
        Collection instances = usr.getProjectInstancesNames("GPI");
        UserSessionTests.assertTrue((String)"getProjectInstances Error", (instances.size() == 2 ? 1 : 0) != 0);
    }

    public void testInstancesByProperty() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("instProp");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initModel("instProp2");
        ProjectSession ps3 = projectSessionh.create();
        ps3.initModel("instProp3");
        ps.setProperty("id", "1234");
        ps2.setProperty("id", "1234");
        ps3.setProperty("id2", "1234");
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession usersession = uHome.create();
        Collection names = usersession.getInstancesByPropertyNames("id", "1234");
        UserSessionTests.assertTrue((String)"Error in Instances by Property. Project error", (names.size() == 0 ? 1 : 0) != 0);
        String prop1 = ps.instantiateProject("instProp");
        String prop2 = ps2.instantiateProject("instProp2");
        String prop3 = ps3.instantiateProject("instProp3");
        ps.setProperty("id", "1234");
        ps2.setProperty("id", "1234");
        ps3.setProperty("id2", "1234");
        names = usersession.getInstancesByPropertyNames("id", "1234");
        UserSessionTests.assertTrue((String)"Error in Instances by Property. Instance error", (names.size() == 2 ? 1 : 0) != 0);
    }

    public void testProjectsByProperty() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("projProp");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initModel("projProp2");
        ps.setProperty("id", "123");
        ps2.setProperty("id", "123");
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession usersession = uHome.create();
        Collection names = usersession.getProjectsByPropertyNames("id", "123");
        UserSessionTests.assertTrue((String)"Error in Projects by Property", (names.size() == 2 ? 1 : 0) != 0);
        String prop1 = ps.instantiateProject("projProp");
        String prop2 = ps2.instantiateProject("projProp2");
        ps.setProperty("id", "123");
        ps2.setProperty("id", "123");
        names = usersession.getProjectsByPropertyNames("id", "123");
        UserSessionTests.assertTrue((String)"Error in Projects by Property", (names.size() == 2 ? 1 : 0) != 0);
    }

    public void testGetInstancesList() throws Exception {
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("GetInst", "GetInst", "miguel.valdes-faura@bull.net");
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("GetInstancesList");
        ps.addNode("node1", 1);
        ps.addUser("GetInst");
        ps.setNodeRole("node1", "GetInst");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initModel("GetInstancesList2");
        ProjectSession ps3 = projectSessionh.create();
        ps3.initModel("GetInstancesList3");
        ps3.addNode("node1", 1);
        ps3.addUser("GetInst");
        ps3.setNodeRole("node1", "GetInst");
        SimpleCallbackHandler handler = new SimpleCallbackHandler("GetInst", "GetInst".toCharArray());
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession usersession = uHome.create();
        Collection names = usersession.getInstancesListNames();
        UserSessionTests.assertTrue((String)"Error in getInstancesList. GetInstancesListNames", (names.size() == 0 ? 1 : 0) != 0);
        names = usersession.getProjectListNames();
        UserSessionTests.assertTrue((String)"Error in getInstancesList. GetProjectListNames", (names.size() == 2 ? 1 : 0) != 0);
        names = usersession.getInstancesList();
        UserSessionTests.assertTrue((String)"Error in getInstancesList. GetInstancesList", (names.size() == 0 ? 1 : 0) != 0);
        names = usersession.getProjectList();
        UserSessionTests.assertTrue((String)"Error in getInstancesList. GetProjectList", (names.size() == 2 ? 1 : 0) != 0);
        ps.instantiateProject("GetInstancesList");
        ps.instantiateProject("GetInstancesList3");
        names = usersession.getInstancesListNames();
        UserSessionTests.assertTrue((String)"Error in getInstancesList. GetInstancesListNames", (names.size() == 2 ? 1 : 0) != 0);
        names = usersession.getProjectListNames();
        UserSessionTests.assertTrue((String)"Error in getInstancesList. GetProjectListNames", (names.size() == 4 ? 1 : 0) != 0);
        names = usersession.getInstancesList();
        UserSessionTests.assertTrue((String)"Error in getInstancesList. GetInstancesList", (names.size() == 2 ? 1 : 0) != 0);
        names = usersession.getProjectList();
        UserSessionTests.assertTrue((String)"Error in getInstancesList. GetProjectList", (names.size() == 4 ? 1 : 0) != 0);
        char[] password2 = new char[]{'t', 'o', 't', 'o'};
        handler = new SimpleCallbackHandler("admin", password2);
        lc = new LoginContext("TestClient", handler);
        lc.login();
    }

    public void testGetTodoListAllInstances() throws Exception {
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("tdai", "tdai", "miguel.valdes-faura@bull.net");
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("TDAI");
        ps.addNode("node1", 1);
        ps.addNode("node2", 1);
        ps.addUser("tdai");
        ps.setNodeRole("node1", "tdai");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initModel("TDAI2");
        ps2.addNode("node2", 1);
        ProjectSession ps3 = projectSessionh.create();
        ps3.initModel("TDAI3");
        ps3.addNode("node1", 1);
        ps3.addNode("node2", 1);
        ps3.addUser("tdai");
        ps3.setNodeRole("node1", "tdai");
        ProjectSession ps4 = projectSessionh.create();
        ps4.initProject("TDAI4");
        ps4.addNode("node1", 1);
        ps4.addUser("tdai");
        ps4.setNodeRole("node1", "tdai");
        SimpleCallbackHandler handler = new SimpleCallbackHandler("tdai", "tdai".toCharArray());
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        ps.instantiateProject("TDAI");
        ps2.instantiateProject("TDAI2");
        ps3.instantiateProject("TDAI3");
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession usersession = uHome.create();
        Collection names = usersession.getToDoListAllInstances();
        UserSessionTests.assertTrue((String)"Error in getTodoListAllInstances", (names.size() == 3 ? 1 : 0) != 0);
        char[] password2 = new char[]{'t', 'o', 't', 'o'};
        handler = new SimpleCallbackHandler("admin", password2);
        lc = new LoginContext("TestClient", handler);
        lc.login();
    }

    public void testGetActivityListAllInstances() throws Exception {
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("taai", "taai", "miguel.valdes-faura@bull.net");
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("TAAI");
        ps.addNode("node1", 1);
        ps.addNode("node2", 1);
        ps.addUser("taai");
        ps.setNodeRole("node1", "taai");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initModel("TAAI2");
        ps2.addNode("node2", 1);
        ProjectSession ps3 = projectSessionh.create();
        ps3.initModel("TAAI3");
        ps3.addNode("node1", 1);
        ps3.addNode("node2", 1);
        ps3.addUser("taai");
        ps3.setNodeRole("node1", "taai");
        SimpleCallbackHandler handler = new SimpleCallbackHandler("taai", "taai".toCharArray());
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        String name1 = ps.instantiateProject("TAAI");
        String name2 = ps2.instantiateProject("TAAI2");
        String name3 = ps3.instantiateProject("TAAI3");
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession usersession = uHome.create();
        Collection names = usersession.getActivityListAllInstances();
        UserSessionTests.assertTrue((String)"Error in getActivityAllInstancesList.1 ", (names.size() == 0 ? 1 : 0) != 0);
        usersession.startActivity(name1, "node1");
        names = usersession.getActivityListAllInstances();
        UserSessionTests.assertTrue((String)"Error in getActivityAllInstancesList.2 ", (names.size() == 1 ? 1 : 0) != 0);
        usersession.startActivity(name3, "node1");
        names = usersession.getActivityListAllInstances();
        UserSessionTests.assertTrue((String)"Error in getActivityAllInstancesList.3 ", (names.size() == 2 ? 1 : 0) != 0);
        usersession.terminateActivity(name3, "node1");
        names = usersession.getActivityListAllInstances();
        UserSessionTests.assertTrue((String)"Error in getActivityAllInstancesList.4 ", (names.size() == 1 ? 1 : 0) != 0);
        char[] password2 = new char[]{'t', 'o', 't', 'o'};
        handler = new SimpleCallbackHandler("admin", password2);
        lc = new LoginContext("TestClient", handler);
        lc.login();
    }

    public void testGetTodoListByProperty() throws Exception {
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("tdp", "tdp", "miguel.valdes-faura@bull.net");
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("TDP");
        ps.addNode("node1", 1);
        ps.setProperty("test", "111");
        ps.setNodeProperty("node1", "test", "111");
        ps.setNodeProperty("node1", "test", "1112");
        ps.addNode("node2", 1);
        ps.addUser("tdp");
        ps.setNodeRole("node1", "tdp");
        ps.setNodeRole("node2", "tdp");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initModel("TDP2");
        ps2.addNode("node2", 1);
        ProjectSession ps3 = projectSessionh.create();
        ps3.initModel("TDP3");
        ps3.addNode("node1", 1);
        ps3.setNodeProperty("node1", "test", "111");
        ps3.addNode("node2", 1);
        ps3.setNodeProperty("node2", "test3", "111");
        ps3.addUser("tdp");
        ps3.setNodeRole("node1", "tdp");
        SimpleCallbackHandler handler = new SimpleCallbackHandler("tdp", "tdp".toCharArray());
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        String name = ps.instantiateProject("TDP");
        ps.setNodeProperty("node2", "test", "111");
        ps.setProperty("test", "111");
        ps2.instantiateProject("TDP2");
        ps3.instantiateProject("TDP3");
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession usersession = uHome.create();
        Collection names = usersession.getToDoListByProperty("test", "111");
        UserSessionTests.assertTrue((String)"Error in getTodoListByProperty.1", (names.size() == 2 ? 1 : 0) != 0);
        ps.setNodeProperty("node1", "test", "111");
        ps.setNodeProperty("node2", "test3", "11122");
        ps.setProperty("test", "111");
        ps.setProperty("test3", "11122");
        names = usersession.getToDoListByProperty("test", "111");
        UserSessionTests.assertTrue((String)"Error in getTodoListByProperty.2", (names.size() == 2 ? 1 : 0) != 0);
        names = usersession.getToDoListByProperty("test", "1111");
        UserSessionTests.assertTrue((String)"Error in getTodoListByProperty.3", (names.size() == 0 ? 1 : 0) != 0);
        usersession.startActivity(name, "node1");
        names = usersession.getToDoListByProperty("test", "111");
        UserSessionTests.assertTrue((String)"Error in getTodoListByProperty.4", (names.size() == 1 ? 1 : 0) != 0);
        char[] password2 = new char[]{'t', 'o', 't', 'o'};
        handler = new SimpleCallbackHandler("admin", password2);
        lc = new LoginContext("TestClient", handler);
        lc.login();
    }

    public void testGetTodoListByPropertiesAND() throws Exception {
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("tdtp", "tdtp", "miguel.valdes-faura@bull.net");
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("TDTP");
        ps.addNode("node1", 1);
        ps.setProperty("test", "111");
        ps.setNodeProperty("node1", "test", "111");
        ps.setProperty("testTwo", "1112");
        ps.addNode("node2", 1);
        ps.addUser("tdtp");
        ps.setNodeRole("node1", "tdtp");
        ps.setNodeRole("node2", "tdtp");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initModel("TDTP2");
        ps2.addNode("node2", 1);
        ProjectSession ps3 = projectSessionh.create();
        ps3.initModel("TDTP3");
        ps3.addNode("node1", 1);
        ps3.setNodeProperty("node1", "test", "111");
        ps3.addNode("node2", 1);
        ps3.setNodeProperty("node2", "test3", "111");
        ps3.addUser("tdtp");
        ps3.setNodeRole("node1", "tdtp");
        SimpleCallbackHandler handler = new SimpleCallbackHandler("tdtp", "tdtp".toCharArray());
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        String name = ps.instantiateProject("TDTP");
        ps.setNodeProperty("node2", "test", "111");
        ps.setProperty("test", "111");
        ps2.instantiateProject("TDTP2");
        ps3.instantiateProject("TDTP3");
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession usersession = uHome.create();
        Hashtable<String, String> prop = new Hashtable<String, String>();
        prop.put("test", "111");
        Collection names = usersession.getToDoListByProperties(1, prop);
        UserSessionTests.assertTrue((String)"Error in getTodoListByProperties.0", (names.size() == 2 ? 1 : 0) != 0);
        prop.put("testTwo", "1112");
        names = usersession.getToDoListByProperties(1, prop);
        UserSessionTests.assertTrue((String)"Error in getTodoListByProperties.1", (names.size() == 2 ? 1 : 0) != 0);
        ps.setNodeProperty("node1", "test", "111");
        ps.setNodeProperty("node2", "test3", "11122");
        ps2.setProperty("test", "111");
        ps2.setProperty("testTwo", "1112");
        ps2.setProperty("testThree", "1113");
        ps3.setProperty("test", "111");
        ps3.setProperty("testTwo", "1112");
        ps3.setProperty("testThree", "1113");
        names = usersession.getToDoListByProperties(1, prop);
        UserSessionTests.assertTrue((String)"Error in getTodoListByProperties.2", (names.size() == 3 ? 1 : 0) != 0);
        prop.put("testTwo", "1114");
        names = usersession.getToDoListByProperties(1, prop);
        UserSessionTests.assertTrue((String)"Error in getTodoListByProperties.3", (names.size() == 0 ? 1 : 0) != 0);
        usersession.startActivity(name, "node1");
        prop.put("testTwo", "1112");
        prop.put("testThree", "1113");
        names = usersession.getToDoListByProperties(1, prop);
        UserSessionTests.assertTrue((String)"Error in getTodoListByProperties.4", (names.size() == 1 ? 1 : 0) != 0);
        char[] password2 = new char[]{'t', 'o', 't', 'o'};
        handler = new SimpleCallbackHandler("admin", password2);
        lc = new LoginContext("TestClient", handler);
        lc.login();
    }

    public void testGetTodoListByPropertiesOR() throws Exception {
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("tdtpor", "tdtpor", "miguel.valdes-faura@bull.net");
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("TDTPOR");
        ps.addNode("node1", 1);
        ps.setProperty("test", "111");
        ps.setNodeProperty("node1", "test", "111");
        ps.setProperty("testTwo", "1112");
        ps.addNode("node2", 1);
        ps.addUser("tdtpor");
        ps.setNodeRole("node1", "tdtpor");
        ps.setNodeRole("node2", "tdtpor");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initModel("TDTP2OR");
        ps2.addNode("node2", 1);
        ProjectSession ps3 = projectSessionh.create();
        ps3.initModel("TDTP3OR");
        ps3.addNode("node1", 1);
        ps3.setNodeProperty("node1", "test", "111");
        ps3.addNode("node2", 1);
        ps3.setNodeProperty("node2", "test3", "111");
        ps3.addUser("tdtpor");
        ps3.setNodeRole("node1", "tdtpor");
        SimpleCallbackHandler handler = new SimpleCallbackHandler("tdtpor", "tdtpor".toCharArray());
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        String name = ps.instantiateProject("TDTPOR");
        ps.setNodeProperty("node2", "test", "111");
        ps.setProperty("test", "111");
        ps2.instantiateProject("TDTP2OR");
        ps3.instantiateProject("TDTP3OR");
        ps3.setProperty("testTwo", "1112");
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession usersession = uHome.create();
        Hashtable<String, String> prop = new Hashtable<String, String>();
        prop.put("test", "111");
        Collection names = usersession.getToDoListByProperties(2, prop);
        UserSessionTests.assertTrue((String)"Error in getTodoListByProperties.0", (names.size() == 2 ? 1 : 0) != 0);
        prop.put("testTwo", "1112");
        names = usersession.getToDoListByProperties(2, prop);
        UserSessionTests.assertTrue((String)("Error in getTodoListByProperties.1-> " + names.size()), (names.size() == 3 ? 1 : 0) != 0);
        ps.setNodeProperty("node1", "test", "111");
        ps.setNodeProperty("node2", "test3", "11122");
        ps2.setProperty("test", "111");
        ps2.setProperty("testTwo", "1112");
        ps2.setProperty("testThree", "1113");
        ps3.setProperty("test", "111");
        ps3.setProperty("testTwo", "1112");
        ps3.setProperty("testThree", "1113");
        names = usersession.getToDoListByProperties(2, prop);
        UserSessionTests.assertTrue((String)"Error in getTodoListByProperties.2", (names.size() == 3 ? 1 : 0) != 0);
        prop.put("testThree", "1113");
        names = usersession.getToDoListByProperties(2, prop);
        UserSessionTests.assertTrue((String)"Error in getTodoListByProperties.3", (names.size() == 3 ? 1 : 0) != 0);
        prop.put("testFour", "1114");
        try {
            names = usersession.getToDoListByProperties(2, prop);
            UserSessionTests.assertTrue((String)"Error in getToDoListByProperties.4, operation should be failed", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        char[] password2 = new char[]{'t', 'o', 't', 'o'};
        handler = new SimpleCallbackHandler("admin", password2);
        lc = new LoginContext("TestClient", handler);
        lc.login();
    }

    public void testActivityListByProperty() throws Exception {
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("alp", "alp", "miguel.valdes-faura@bull.net");
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("ALP");
        ps.addNode("node1", 1);
        ps.setProperty("test", "111");
        ps.setNodeProperty("node1", "test", "111");
        ps.setNodeProperty("node1", "test", "1112");
        ps.addNode("node2", 1);
        ps.addUser("alp");
        ps.setNodeRole("node1", "alp");
        ps.setNodeRole("node2", "alp");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initModel("ALP2");
        ps2.addNode("node2", 1);
        ProjectSession ps3 = projectSessionh.create();
        ps3.initModel("ALP3");
        ps3.addNode("node1", 1);
        ps3.setNodeProperty("node1", "test", "111");
        ps3.setProperty("test", "111");
        ps3.setProperty("test", "111");
        ps3.setNodeProperty("node1", "test", "111");
        ps3.addNode("node2", 1);
        ps3.setNodeProperty("node2", "test3", "111");
        ps3.addUser("alp");
        ps3.setNodeRole("node1", "alp");
        SimpleCallbackHandler handler = new SimpleCallbackHandler("alp", "alp".toCharArray());
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        String name = ps.instantiateProject("ALP");
        ps.setProperty("test", "111");
        ps.setNodeProperty("node2", "test", "111");
        ps2.instantiateProject("ALP2");
        ps3.instantiateProject("ALP3");
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession usersession = uHome.create();
        Collection names = usersession.getActivityListByProperty("test", "111");
        UserSessionTests.assertTrue((String)"Error in getActivityListByProperty.1", (names.size() == 0 ? 1 : 0) != 0);
        usersession.startActivity(name, "node2");
        names = usersession.getActivityListByProperty("test", "111");
        UserSessionTests.assertTrue((String)"Error in getActivityListByProperty.2", (names.size() == 1 ? 1 : 0) != 0);
        ps.setNodeProperty("node1", "test", "111");
        ps.setNodeProperty("node2", "test3", "11122");
        ps.setProperty("test", "111");
        ps.setProperty("test3", "11122");
        names = usersession.getActivityListByProperty("test", "111");
        UserSessionTests.assertTrue((String)"Error in getActivityListByProperty.2", (names.size() == 1 ? 1 : 0) != 0);
        names = usersession.getToDoListByProperty("test", "1111");
        UserSessionTests.assertTrue((String)"Error in getActivityListByProperty.3", (names.size() == 0 ? 1 : 0) != 0);
        usersession.terminateActivity(name, "node2");
        names = usersession.getActivityListByProperty("test", "111");
        UserSessionTests.assertTrue((String)"Error in getActivityListByProperty.4", (names.size() == 0 ? 1 : 0) != 0);
        char[] password2 = new char[]{'t', 'o', 't', 'o'};
        handler = new SimpleCallbackHandler("admin", password2);
        lc = new LoginContext("TestClient", handler);
        lc.login();
    }

    public void testGetTodoListByActivityProperty() throws Exception {
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("instActProp");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initModel("instActProp2");
        ProjectSession ps3 = projectSessionh.create();
        ps3.initModel("instActProp3");
        ps.setProperty("id", "1234");
        ps2.setProperty("id", "1234");
        ps3.setProperty("id2", "1234");
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession usersession = uHome.create();
        Collection names = usersession.getToDoListByActivityProperty("id", "1234");
        UserSessionTests.assertTrue((String)"Error in Instances by Property. Project error", (names.size() == 0 ? 1 : 0) != 0);
        String prop1 = ps.instantiateProject("instProp");
        String prop2 = ps2.instantiateProject("instProp2");
        String prop3 = ps3.instantiateProject("instProp3");
        ps.setProperty("id", "1234");
        ps2.setProperty("id", "1234");
        ps3.setProperty("id2", "1234");
        names = usersession.getToDoListByActivityProperty("id", "1234");
        UserSessionTests.assertTrue((String)"Error in Instances by Property. Instance error", (names.size() == 0 ? 1 : 0) != 0);
        ps.addNode("node1", 1);
        ps.setNodeRole("node1", "admin");
        ps.setNodeProperty("node1", "test", "ok", true);
        ps2.addNode("node2", 1);
        ps2.setNodeRole("node2", "admin");
        ps2.setNodeProperty("node2", "test", "nok", true);
        prop1 = ps.instantiateProject("instProp");
        prop2 = ps2.instantiateProject("instProp2");
        prop3 = ps3.instantiateProject("instProp3");
        names = usersession.getToDoListByActivityProperty("test", "ok");
        UserSessionTests.assertTrue((String)"Error in Instances by ActivityProperty. Instance error", (names.size() == 1 ? 1 : 0) != 0);
    }

    public void testGetTodoListByActivityPropertyTwoUsers() throws Exception {
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("tdptu", "tdptu", "miguel.valdes-faura@bull.net");
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("TDPTU");
        ps.addNode("node1", 1);
        ps.setNodeProperty("node1", "testtu", "111");
        ps.addNode("node2", 1);
        ps.addUser("tdptu");
        ps.setNodeRole("node1", "tdptu");
        ps.setNodeRole("node2", "tdptu");
        ProjectSession ps2 = projectSessionh.create();
        ps2.initModel("TDPTU2");
        ps2.addNode("node2", 1);
        ps2.setNodeProperty("node2", "testtu", "111");
        ProjectSession ps3 = projectSessionh.create();
        ps3.initModel("TDPTU3");
        ps3.addNode("node1", 1);
        ps3.setNodeProperty("node1", "testtu", "111");
        ps3.addNode("node2", 1);
        ps3.setNodeProperty("node2", "test3", "111");
        ps3.addUser("tdptu");
        ps3.setNodeRole("node1", "tdptu");
        SimpleCallbackHandler handler = new SimpleCallbackHandler("tdptu", "tdptu".toCharArray());
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        String name = ps.instantiateProject("TDPTU");
        ps2.instantiateProject("TDPTU2");
        ps3.instantiateProject("TDPTU3");
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession usersession = uHome.create();
        Collection names = usersession.getToDoListByActivityProperty("testtu", "111");
        Iterator i = names.iterator();
        BnNodeValue nd = null;
        while (i.hasNext()) {
            nd = (BnNodeValue)i.next();
        }
        UserSessionTests.assertTrue((String)("Error in getTodoListByProperty.1: " + nd.getName() + "+" + nd.getBnProject().getName()), (names.size() == 2 ? 1 : 0) != 0);
        ps3.setNodeProperty("node1", "testtu", "1112");
        ps3.setNodeProperty("node2", "test3", "11122");
        names = usersession.getToDoListByActivityProperty("testtu", "111");
        UserSessionTests.assertTrue((String)("Error in getTodoListByActivityProperty.2: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        usersession.startActivity(name, "node1");
        names = usersession.getToDoListByActivityProperty("testtu", "111");
        UserSessionTests.assertTrue((String)("Error in getTodoListByActivityProperty.4: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        char[] password2 = new char[]{'t', 'o', 't', 'o'};
        handler = new SimpleCallbackHandler("admin", password2);
        lc = new LoginContext("TestClient", handler);
        lc.login();
    }

    public void testFindModels() throws Exception {
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession usersession = uHome.create();
        Collection names = usersession.getModels();
        UserSessionTests.assertTrue((String)"Error in findModels", (names.size() > 0 ? 1 : 0) != 0);
    }

    public void testModelInstancesActivities() throws Exception {
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("demandeur1", "toto", "miguel.valdes-faura@bull.net");
        userReg.userCreate("approbateur1", "toto", "miguel.valdes-faura@bull.net");
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("demande_de_conges");
        ps.addNode("demande", 1);
        ps.addNode("approbation", 1);
        ps.addEdge("demande", "approbation");
        ps.addRole("demandeur", "demandeur");
        ps.addRole("approbateur", "approbateur");
        ps.setNodeRole("demande", "demandeur");
        ps.setNodeRole("approbation", "approbateur");
        ps.addUser("approbateur1");
        ps.setUserRole("approbateur1", "approbateur");
        ps.addRoleMapper("demandeur", "mapperTest", 1);
        ProjectSession psh = projectSessionh.create();
        psh.initModel("demande_habilitation");
        psh.addNode("demande", 1);
        psh.addNode("acceptation", 1);
        psh.addEdge("demande", "acceptation");
        psh.addRole("demandeur", "demandeur");
        psh.addRole("approbateur", "approbateur");
        psh.setNodeRole("demande", "demandeur");
        psh.setNodeRole("acceptation", "approbateur");
        psh.addUser("approbateur1");
        psh.setUserRole("approbateur1", "approbateur");
        psh.addRoleMapper("demandeur", "mapperTest2", 1);
        SimpleCallbackHandler handler = new SimpleCallbackHandler("demandeur1", "toto".toCharArray());
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        UserSession usersession1 = uHome.create();
        ProjectSession ps2 = projectSessionh.create();
        String instName1 = ps2.instantiateProject("demande_de_conges");
        Collection names = usersession1.getModelInstancesTodoList("demande_de_conges");
        UserSessionTests.assertTrue((String)("Error in getModelInstancesTodoList.1: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        Iterator i = names.iterator();
        UserSessionTests.assertTrue((String)"Error in getModelInstancesTodoList.2: ", (boolean)((String)i.next()).equals("demande"));
        String instName2 = ps2.instantiateProject("demande_de_conges");
        names = usersession1.getModelInstancesTodoList("demande_de_conges");
        UserSessionTests.assertTrue((String)("Error in getModelInstancesTodoList.3: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        handler = new SimpleCallbackHandler("approbateur1", "toto".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
        UserSession usersession2 = uHome.create();
        names = usersession2.getModelInstancesTodoList("demande_de_conges");
        UserSessionTests.assertTrue((String)("Error in getModelInstancesTodoList.4: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        handler = new SimpleCallbackHandler("demandeur1", "toto".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
        names = usersession1.getInstancesActivityTodoList("demande_de_conges", "demande");
        UserSessionTests.assertTrue((String)("Error in getInstancesActivityTodoList.1: " + names.size()), (names.size() == 2 ? 1 : 0) != 0);
        usersession1.startActivity(instName1, "demande");
        usersession1.terminateActivity(instName1, "demande");
        names = usersession1.getModelInstancesTerminated("demande_de_conges");
        UserSessionTests.assertTrue((String)("Error in getModelInstancesTerminated.1: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        i = names.iterator();
        UserSessionTests.assertTrue((String)"Error in getModelInstancesTerminated.2: ", (boolean)((String)i.next()).equals("demande"));
        names = usersession1.getInstancesActivityTerminated("demande_de_conges", "demande");
        UserSessionTests.assertTrue((String)("Error in getInstancesActivityTerminated.1: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        usersession1.startActivity(instName2, "demande");
        usersession1.terminateActivity(instName2, "demande");
        names = usersession1.getModelInstancesTerminated("demande_de_conges");
        UserSessionTests.assertTrue((String)("Error in getModelInstancesTerminated.3: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        names = usersession1.getInstancesActivityTerminated("demande_de_conges", "demande");
        UserSessionTests.assertTrue((String)("Error in getInstancesActivityTerminated.2: " + names.size()), (names.size() == 2 ? 1 : 0) != 0);
        handler = new SimpleCallbackHandler("approbateur1", "toto".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
        names = usersession2.getModelInstancesTodoList("demande_de_conges");
        UserSessionTests.assertTrue((String)("Error in getModelInstancesTodoList.5: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        names = usersession2.getInstancesActivityTodoList("demande_de_conges", "demande");
        UserSessionTests.assertTrue((String)("Error in getInstancesActivityTodoList.2: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        names = usersession2.getInstancesActivityTodoList("demande_de_conges", "approbation");
        UserSessionTests.assertTrue((String)("Error in getInstancesActivityTodoList.2: " + names.size()), (names.size() == 2 ? 1 : 0) != 0);
        usersession2.startActivity(instName1, "approbation");
        usersession2.terminateActivity(instName1, "approbation");
        names = usersession2.getInstancesActivityTodoList("demande_de_conges", "approbation");
        UserSessionTests.assertTrue((String)("Error in getInstancesActivityTodoList.3: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        names = usersession2.getModelInstancesTerminated("demande_de_conges");
        UserSessionTests.assertTrue((String)("Error in getModelInstancesTerminated.4: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        names = usersession2.getInstancesActivityTerminated("demande_de_conges", "approbation");
        UserSessionTests.assertTrue((String)("Error in getInstancesActivityTerminated.3: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        usersession2.startActivity(instName2, "approbation");
        usersession2.terminateActivity(instName2, "approbation");
        names = usersession2.getInstancesActivityTodoList("demande_de_conges", "approbation");
        UserSessionTests.assertTrue((String)("Error in getInstancesActivityTodoList.4: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        names = usersession2.getModelInstancesTerminated("demande_de_conges");
        UserSessionTests.assertTrue((String)("Error in getModelInstancesTerminated.5: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        names = usersession2.getInstancesActivityTerminated("demande_de_conges", "approbation");
        UserSessionTests.assertTrue((String)("Error in getInstancesActivityTerminated.4: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        handler = new SimpleCallbackHandler("demandeur1", "toto".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
        UserSession usersession3 = uHome.create();
        ProjectSession ps3 = projectSessionh.create();
        instName1 = ps3.instantiateProject("demande_habilitation");
        names = usersession3.getModelInstancesTodoList("demande_habilitation");
        UserSessionTests.assertTrue((String)("Error in getModelInstancesTodoList.5: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        names = usersession3.getModelInstancesTodoList("demande_de_conges");
        UserSessionTests.assertTrue((String)("Error in getModelInstancesTodoList.6: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        usersession1.startActivity(instName1, "demande");
        usersession1.terminateActivity(instName1, "demande");
        handler = new SimpleCallbackHandler("approbateur1", "toto".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
        names = usersession2.getInstancesActivityTodoList("demande_de_conges", "approbation");
        UserSessionTests.assertTrue((String)("Error in getInstancesActivityTodoList.5: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        names = usersession2.getModelInstancesTerminated("demande_de_conges");
        UserSessionTests.assertTrue((String)("Error in getModelInstancesTerminated.6: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        names = usersession2.getInstancesActivityTerminated("demande_de_conges", "approbation");
        UserSessionTests.assertTrue((String)("Error in getInstancesActivityTerminated.5: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        names = usersession2.getModelInstancesTodoList("demande_habilitation");
        UserSessionTests.assertTrue((String)("Error in getModelInstancesTodoList.6: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        names = usersession2.getInstancesActivityTodoList("demande_habilitation", "acceptation");
        UserSessionTests.assertTrue((String)("Error in getInstancesActivityTodoList.6: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        char[] password2 = new char[]{'t', 'o', 't', 'o'};
        handler = new SimpleCallbackHandler("admin", password2);
        lc = new LoginContext("TestClient", handler);
        lc.login();
    }

    public void testMyInstances() throws Exception {
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        userReg.userCreate("demandeur2", "toto", "miguel.valdes-faura@bull.net");
        userReg.userCreate("approbateur2", "toto", "miguel.valdes-faura@bull.net");
        ProjectSessionHome projectSessionh = ProjectSessionUtil.getHome();
        ProjectSession ps = projectSessionh.create();
        ps.initModel("followup1");
        ps.addNode("demande", 1);
        ps.addNode("approbation", 1);
        ps.addEdge("demande", "approbation");
        ps.addRole("demandeur", "demandeur");
        ps.addRole("approbateur", "approbateur");
        ps.setNodeRole("demande", "demandeur");
        ps.setNodeRole("approbation", "approbateur");
        ps.addUser("approbateur2");
        ps.setUserRole("approbateur2", "approbateur");
        ps.addRoleMapper("demandeur", "mapperTest", 1);
        SimpleCallbackHandler handler = new SimpleCallbackHandler("demandeur2", "toto".toCharArray());
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        UserSession usersession1 = uHome.create();
        ProjectSession ps2 = projectSessionh.create();
        String instName1 = ps2.instantiateProject("followup1");
        Collection names = usersession1.getUserInstancesProject();
        UserSessionTests.assertTrue((String)("Error in getUserInstancesProject.1: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        names = usersession1.getUserInstancesProjectNodes("followup1");
        UserSessionTests.assertTrue((String)("Error in getUserInstancesProjectNodes.1: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        usersession1.startActivity(instName1, "demande");
        names = usersession1.getUserInstancesProjectNodes("followup1");
        UserSessionTests.assertTrue((String)("Error in getUserInstancesProjectNodes.2: " + names.size()), (names.size() == 2 ? 1 : 0) != 0);
        usersession1.terminateActivity(instName1, "demande");
        names = usersession1.getUserInstancesProjectNodes("followup1");
        UserSessionTests.assertTrue((String)("Error in getUserInstancesProjectNodes.3: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        handler = new SimpleCallbackHandler("approbateur2", "toto".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
        UserSession usersession2 = uHome.create();
        ProjectSession ps3 = projectSessionh.create();
        names = usersession2.getUserInstancesProject();
        UserSessionTests.assertTrue((String)("Error in getUserInstancesProject.2: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        names = usersession2.getUserInstancesProjectNodes("followup1");
        UserSessionTests.assertTrue((String)("Error in getUserInstancesProjectNodes.4: " + names.size()), (names.size() == 0 ? 1 : 0) != 0);
        ps3.instantiateProject("followup1");
        names = usersession2.getUserInstancesProject();
        UserSessionTests.assertTrue((String)("Error in getUserInstancesProject.3: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        names = usersession2.getUserInstancesProjectNodes("followup1");
        UserSessionTests.assertTrue((String)("Error in getUserInstancesProjectNodes.5: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        handler = new SimpleCallbackHandler("demandeur2", "toto".toCharArray());
        lc = new LoginContext("TestClient", handler);
        lc.login();
        String instName2 = ps2.instantiateProject("followup1");
        names = usersession1.getUserInstancesProject();
        UserSessionTests.assertTrue((String)("Error in getUserInstancesProject.4: " + names.size()), (names.size() == 1 ? 1 : 0) != 0);
        names = usersession1.getUserInstancesProjectNodes("followup1");
        UserSessionTests.assertTrue((String)("Error in getUserInstancesProjectNodes.6: " + names.size()), (names.size() == 2 ? 1 : 0) != 0);
        char[] password2 = new char[]{'t', 'o', 't', 'o'};
        handler = new SimpleCallbackHandler("admin", password2);
        lc = new LoginContext("TestClient", handler);
        lc.login();
    }

    public void testSubProcessesAutoDelete() throws Exception {
        this.projectsesh = ProjectSessionUtil.getHome();
        ProjectSession lproj1 = this.projectsesh.create();
        lproj1.initModel("Approval_Workflow");
        lproj1.addNode("Approval", 1);
        lproj1.setNodeRole("Approval", "admin");
        lproj1.addNode("Reject", 3);
        lproj1.addNode("Accept", 3);
        lproj1.addEdge("Approval", "Reject");
        lproj1.addEdge("Approval", "Accept");
        ProjectSession p = this.projectsesh.create();
        p.initModel("TestSubProcessesAuto");
        p.addNode("testAct", 3);
        p.addNodeSubProcess("Approval", "Approval_Workflow");
        p.addEdge("testAct", "Approval");
        String instName = p.instantiateProject("TestSubProcessesAuto");
        this.usersessionh = UserSessionUtil.getHome();
        UserSession usersession = this.usersessionh.create();
        Collection acts = usersession.getInstancesActivityTodoList("Approval_Workflow", "Approval");
        for (BnNodeLightValue nd : acts) {
            usersession.startActivity(nd.getBnProject().getName(), nd.getName());
            usersession.terminateActivity(nd.getBnProject().getName(), nd.getName());
        }
        try {
            BnProjectHome pHome = BnProjectUtil.getHome();
            BnProject pr = pHome.findByName(instName);
            UserSessionTests.assertTrue((String)"Should have throw EJBException, auto delete instance operations has failed", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

