/*
 * Decompiled with CFR 0.152.
 */
package hero.client.test.perf;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import hero.interfaces.UserSession;
import hero.interfaces.UserSessionHome;
import hero.interfaces.UserSessionUtil;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.login.LoginContext;

public class InstancesPerfTest {
    public static void main(String[] args) throws Exception {
        int argNb = 2;
        if (args.length != argNb) {
            System.out.println("Number of arguments needed : " + argNb);
            System.out.println("Args :  userId nbInstances");
        } else {
            String uNb = "0";
            int instNb = 10;
            long startTime = System.currentTimeMillis();
            try {
                uNb = new String(args[0]);
                String instanceNum = new String(args[1]);
                System.out.println("Parametres : uNb: " + uNb + " - instanceNum: " + instanceNum);
                instNb = Integer.valueOf(instanceNum);
            }
            catch (Exception e) {
                System.out.println(" --> " + e);
            }
            String uName = "user" + uNb;
            char[] password = uName.toCharArray();
            SimpleCallbackHandler handler = new SimpleCallbackHandler(uName, password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            ProjectSessionHome pHome = ProjectSessionUtil.getHome();
            int i = 0;
            for (i = 0; i < instNb; ++i) {
                ProjectSession ps = pHome.create();
                ps.instantiateProject("Stress");
                System.out.println(" --> User: " + uName + " -- Instanciate Stress Model");
                Thread.sleep(100L);
                ps.remove();
            }
            UserSessionHome uHome = UserSessionUtil.getHome();
            UserSession us = uHome.create();
            Collection instances = us.getInstancesListNames();
            Iterator index = instances.iterator();
            UserSession usUser = uHome.create();
            while (index.hasNext()) {
                String name = (String)index.next();
                Collection task = usUser.getToDoList(name);
                Iterator it = task.iterator();
                while (it.hasNext()) {
                    String activity = (String)it.next();
                    usUser.startActivity(name, activity);
                    System.out.println(" --> User: " + uName + " Instance: " + name + " -- Start Act: " + activity);
                    if (activity.matches(".*_instance.*")) {
                        InstancesPerfTest.executeSubProcess(activity);
                    }
                    Thread.sleep(100L);
                    usUser.terminateActivity(name, activity);
                    System.out.println(" --> User: " + uName + " -- Stop Act: " + activity);
                    task = usUser.getToDoList(name);
                    it = task.iterator();
                }
            }
            long time = System.currentTimeMillis();
            long tmp = (time - startTime) / 1000L;
            long h = tmp / 3600L;
            long m = (tmp - 3600L * h) / 60L;
            long s = tmp - 3600L * h - 60L * m;
            System.out.println("  --> Stress Model system time elapsed : " + h + ":" + m + ":" + s);
        }
    }

    public static void executeSubProcess(String subProcess) throws Exception {
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession us = uHome.create();
        us.startActivity(subProcess, "subNode1");
        us.terminateActivity(subProcess, "subNode1");
        us.startActivity(subProcess, "subNode2");
        us.terminateActivity(subProcess, "subNode2");
    }
}

