/*
 * Decompiled with CFR 0.152.
 */
package hero.client.test.perf;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import javax.security.auth.login.LoginContext;

public class ModelCreationPerfTest {
    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        char[] password = new char[]{'t', 'o', 't', 'o'};
        SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        ProjectSessionHome pHome = ProjectSessionUtil.getHome();
        try {
            System.out.println("  --> Model Creation ");
            ProjectSession psSub = pHome.create();
            psSub.initModel("node5Sub");
            psSub.addNode("subNode1", 1);
            psSub.addNode("subNode2", 1);
            psSub.setNodeRole("subNode1", "admin");
            psSub.setNodeRole("subNode2", "admin");
            psSub.addEdge("subNode1", "subNode2");
            String script = "import hero.interfaces.BnInstanceLocal;\nimport hero.interfaces.BnNodeLocal;\nafterStart (Object b,Object n) {\n\n\nSystem.out.println(\"SPInstantiation test, SubProcess: \"+n.getName()+\" project: \"+(n.getBnProject()).getName());}";
            psSub.addNodeInterHook("subNode2", "subNode2", "afterStart", 6, script);
            psSub.addUser("admin2");
            psSub.setNodeRole("subNode1", "admin");
            psSub.setNodeRole("subNode2", "admin");
            ProjectSession pss = pHome.create();
            pss.initModel("Stress");
            pss.addNode("node1", 1);
            pss.addNode("node2", 1);
            pss.addNode("node3", 1);
            pss.addNode("node4", 3);
            pss.addNode("node5Sub", 1);
            pss.addEdge("node1", "node2");
            pss.addEdge("node2", "node3");
            pss.addEdge("node2", "node4");
            pss.addEdge("node3", "node5Sub");
            script = "import hero.interfaces.BnInstanceLocal;\nimport hero.interfaces.BnNodeLocal;\nafterStart (Object b,Object n) {\n\n\nSystem.out.println(\"Stress test, node: \"+n.getName()+\" project: \"+(n.getBnProject()).getName());}";
            pss.addNodeInterHook("node2", "node2", "afterStart", 6, script);
            pss.addUser("admin2");
            pss.setUserRole("admin2", "InitialRole");
            pss.setNodeRole("node1", "admin");
            pss.setNodeRole("node2", "admin");
            pss.setNodeRole("node3", "admin");
            pss.setNodeRole("node4", "admin");
            pss.setNodeRole("node5Sub", "admin");
            System.out.println("  --> Stress Model totally created ");
            psSub.remove();
            pss.remove();
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        long time = System.currentTimeMillis();
        long tmp = (time - startTime) / 1000L;
        long h = tmp / 3600L;
        long m = (tmp - 3600L * h) / 60L;
        long s = tmp - 3600L * h - 60L * m;
        System.out.println("  --> Stress Model system time elapsed : " + h + ":" + m + ":" + s);
    }
}

