/*
 * Decompiled with CFR 0.152.
 */
package hero.client.test.stress;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import hero.interfaces.UserRegistration;
import hero.interfaces.UserRegistrationHome;
import hero.interfaces.UserRegistrationUtil;
import hero.interfaces.UserSession;
import hero.interfaces.UserSessionHome;
import hero.interfaces.UserSessionUtil;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.login.LoginContext;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class InstancesTests
extends TestCase {
    public InstancesTests(String testname) {
        super(testname);
    }

    public static TestSuite suite() {
        return new TestSuite(InstancesTests.class);
    }

    public void setUp() throws Exception {
    }

    public void testInstances() throws Exception {
        ProjectSessionHome pHome = ProjectSessionUtil.getHome();
        ProjectSession psSub = pHome.create();
        try {
            psSub.initModel("node5Sub");
            psSub.addNode("subNode1", 1);
            psSub.addNode("subNode2", 1);
            psSub.setNodeRole("subNode1", "admin");
            psSub.setNodeRole("subNode2", "admin");
            psSub.addEdge("subNode1", "subNode2");
            String script = "import hero.interfaces.BnInstanceLocal;\nimport hero.interfaces.BnNodeLocal;\nafterStart (Object b,Object n) {\n\n\nSystem.out.println(\"SPInstantiation test, SubProcess: \"+n.getName()+\" project: \"+(n.getBnProject()).getName());}";
            psSub.addNodeInterHook("subNode2", "subNode2", "afterStart", 6, script);
            psSub.addUser("admin2");
            psSub.setNodeRole("subNode1", "admin");
            psSub.setNodeRole("subNode2", "admin");
            ProjectSession pss = pHome.create();
            pss.initModel("Stress");
            pss.addNode("node1", 1);
            pss.addNode("node2", 1);
            pss.addNode("node3", 1);
            pss.addNode("node4", 3);
            pss.addNodeSubProcess("node5Sub", "Stress");
            pss.addEdge("node1", "node2");
            pss.addEdge("node2", "node3");
            pss.addEdge("node2", "node4");
            pss.addEdge("node3", "node5Sub");
            script = "import hero.interfaces.BnInstanceLocal;\nimport hero.interfaces.BnNodeLocal;\nafterStart (Object b,Object n) {\n\n\nSystem.out.println(\"Stress test, node: \"+n.getName()+\" project: \"+(n.getBnProject()).getName());}";
            pss.addNodeInterHook("node2", "node2", "afterStart", 6, script);
            pss.addUser("admin2");
            pss.setUserRole("admin2", "InitialRole");
            pss.setNodeRole("node1", "admin");
            pss.setNodeRole("node2", "admin");
            pss.setNodeRole("node3", "admin");
            pss.setNodeRole("node4", "admin");
            pss.setNodeRole("node5Sub", "admin");
            ProjectSession pss1 = pHome.create();
            pss1.instantiateProject("Stress");
            InstancesTests.assertTrue((String)"Instantiation Error, role error in node1", (boolean)pss1.getNodeRoleName("node1").equals("admin"));
            Collection users = pss1.getUsers();
            InstancesTests.assertTrue((String)"Instantiation Error, user admin2 does not exist", (boolean)users.contains("admin2"));
            InstancesTests.assertTrue((String)"Instantiation Error, type error in node1", (pss1.getNodeType("node1") == 1 ? 1 : 0) != 0);
            InstancesTests.assertTrue((String)"Instantiation Error, type error in node4", (pss1.getNodeType("node4") == 3 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            // empty catch block
        }
        int global = 0;
        for (global = 0; global < 100; ++global) {
            UserRegistrationHome urHome = UserRegistrationUtil.getHome();
            UserRegistration userReg = urHome.create();
            userReg.userCreate("user" + global, "user" + global, "miguel.valdes-faura@ext.bull.net");
            userReg.remove();
            String uName = "user" + global;
            char[] password = uName.toCharArray();
            SimpleCallbackHandler handler = new SimpleCallbackHandler(uName, password);
            LoginContext lc = new LoginContext("TestClient", handler);
            lc.login();
            int i = 0;
            for (i = 0; i < 10; ++i) {
                ProjectSession ps = pHome.create();
                ps.instantiateProject("Stress");
                ps.remove();
            }
            UserSessionHome uHome = UserSessionUtil.getHome();
            UserSession us = uHome.create();
            Collection instances = us.getInstancesListNames();
            InstancesTests.assertTrue((String)"getInstancesList error", (instances.size() >= 1 ? 1 : 0) != 0);
            Iterator index = instances.iterator();
            UserSession usUser = uHome.create();
            while (index.hasNext()) {
                String name = (String)index.next();
                Collection task = usUser.getToDoList(name);
                Iterator it = task.iterator();
                while (it.hasNext()) {
                    String activity = (String)it.next();
                    usUser.startActivity(name, activity);
                    if (activity.matches(".*_instance.*")) {
                        this.executeSubProcess(activity);
                    }
                    usUser.terminateActivity(name, activity);
                    task = usUser.getToDoList(name);
                    it = task.iterator();
                }
            }
        }
    }

    public void executeSubProcess(String subProcess) throws Exception {
        UserSessionHome uHome = UserSessionUtil.getHome();
        UserSession us = uHome.create();
        us.startActivity(subProcess, "subNode1");
        us.terminateActivity(subProcess, "subNode1");
        us.startActivity(subProcess, "subNode2");
        us.terminateActivity(subProcess, "subNode2");
    }
}

