/*
 * Decompiled with CFR 0.152.
 */
package hero.hook;

import hero.hook.BeanShellHook;
import hero.hook.InteractiveBSHook;
import hero.hook.JavaHook;
import hero.hook.TclHook;
import hero.interfaces.BnNodeLocal;
import hero.util.HeroException;
import hero.util.HeroHookException;
import java.io.Serializable;

public abstract class Hook
implements Serializable {
    private String name;
    private String event;
    private int type;
    private String script;

    public static Hook make(String name, String event, int type) throws HeroException {
        if (type == 0) {
            return new JavaHook(name, event, type);
        }
        if (type == 4) {
            return new TclHook(name, event, type);
        }
        if (type == 5) {
            return new BeanShellHook(name, event, type);
        }
        throw new HeroException("Wrong Hook Type " + type);
    }

    public static Hook make(String name, String event, int type, String script) throws HeroException {
        if (type == 6) {
            return new InteractiveBSHook(name, event, type, script);
        }
        throw new HeroException("Wrong Hook Type " + type);
    }

    protected Hook(String name, String event, int type) {
        this.name = name;
        this.event = event;
        this.type = type;
    }

    protected Hook(String name, String event, int type, String script) {
        this.name = name;
        this.event = event;
        this.type = type;
        this.script = script;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String toXML() {
        String result = new String();
        result = "<hook name=\"" + this.getName() + "\" type=\"" + this.getType() + "\" event=\"" + this.getEvent() + "\"/>";
        return result;
    }

    public abstract void execute(Object var1, String var2, BnNodeLocal var3) throws HeroHookException;
}

