/*
 * Decompiled with CFR 0.152.
 */
package hero.user;

import hero.interfaces.BnUserLocal;
import hero.interfaces.BnUserLocalHome;
import hero.interfaces.BnUserUtil;
import hero.user.ImmutableException;
import hero.user.UserBase;
import hero.user.UserBaseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class DefaultUserBase
implements UserBase {
    private String url;
    private String user;
    private String password;
    private String driver;

    public String getUserName(String userId) throws UserBaseException {
        return userId;
    }

    public Map getUserInfos(String userId) throws UserBaseException {
        Hashtable<String, String> uinfos = new Hashtable<String, String>();
        try {
            BnUserLocalHome userhome = BnUserUtil.getLocalHome();
            BnUserLocal user = userhome.findByName(userId);
            uinfos.put("name", userId);
            if (user.getPassword() != null) {
                uinfos.put("password", user.getPassword());
            }
            if (user.getEmail() != null) {
                uinfos.put("email", user.getEmail());
            }
            if (user.getJabber() != null) {
                uinfos.put("jabber", user.getJabber());
            }
            return uinfos;
        }
        catch (NamingException ne) {
            throw new UserBaseException(ne.getMessage());
        }
        catch (FinderException fe) {
            throw new UserBaseException(fe.getMessage());
        }
    }

    public Collection getUsers() throws UserBaseException {
        try {
            ArrayList allUsers = new ArrayList();
            BnUserLocalHome userhome = BnUserUtil.getLocalHome();
            Collection users = userhome.findAll();
            Iterator i = users.iterator();
            while (i.hasNext()) {
                Hashtable<String, String> uinfos = new Hashtable<String, String>();
                BnUserLocal user = (BnUserLocal)i.next();
                uinfos.put("name", user.getName());
                allUsers.add(uinfos);
            }
            return allUsers;
        }
        catch (NamingException ne) {
            throw new UserBaseException(ne.getMessage());
        }
        catch (FinderException fe) {
            throw new UserBaseException(fe.getMessage());
        }
    }

    public boolean handle(String userId) throws UserBaseException {
        return false;
    }

    public boolean isMutable() {
        return true;
    }

    public void create(String userId, String password, String userName, String userEmail, Map userInfos) throws UserBaseException, ImmutableException {
    }

    public void edit(String userId, String password, String userName, String userEmail, Map userInfos) throws UserBaseException, ImmutableException {
    }

    public void deleteUser(String userId) throws UserBaseException, ImmutableException {
    }
}

