/*
 * Decompiled with CFR 0.152.
 */
package hero.util;

import hero.net.ProjectSession.BnIterationLightValue;
import hero.net.ProjectSession.ProjectSessionServiceLocator;
import hero.net.ProjectSession.ProjectSession_PortType;
import hero.net.ProjectSession.StrutsNodeValue;
import hero.net.UserSession.BnProjectLightValue;
import hero.net.UserSession.UserSessionServiceLocator;
import hero.net.UserSession.UserSession_PortType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class BonitaClient {
    private final String userSession = "UserSession";
    private final String projectSession = "ProjectSession";
    private ProjectSession_PortType projectSessionClient;
    private UserSession_PortType userSessionClient;
    private String host;
    private int port;
    private String baseUrl = "/bonita_ws/services/";
    private String userName = null;
    private String userPassword = null;
    private Service service;
    private URL defaultUri;
    private URL userUri;
    private URL projectUri;
    private String currentProject;
    private boolean permission = false;

    private void createUserSoapCall() throws Exception {
        Stub stub = (Stub)this.userSessionClient;
        stub.setUsername(this.userName);
        stub.setPassword(this.userPassword);
    }

    private void createProjectSoapCall() throws Exception {
        Stub stub = (Stub)this.projectSessionClient;
        stub.setUsername(this.userName);
        stub.setPassword(this.userPassword);
        stub.setMaintainSession(true);
    }

    public void login(String user, String pass) throws Exception {
        this.userName = user;
        this.userPassword = pass;
        UserSessionServiceLocator serviceUS = new UserSessionServiceLocator();
        this.userSessionClient = serviceUS.getUserSession(this.userUri);
        ProjectSessionServiceLocator servicePSS = new ProjectSessionServiceLocator();
        this.projectSessionClient = servicePSS.getProjectSession(this.projectUri);
        this.createUserSoapCall();
        this.createProjectSoapCall();
    }

    public String getUser() throws Exception {
        return this.userName;
    }

    public String getProjectName() {
        return this.currentProject;
    }

    public boolean hasPermission() {
        return this.permission;
    }

    public BonitaClient(String host, int port, String urlBase) throws Exception {
        this.host = host;
        this.port = port;
        this.baseUrl = urlBase;
        this.userUri = new URL("http://" + host + ":" + port + this.baseUrl + "UserSession");
        this.projectUri = new URL("http://" + host + ":" + port + this.baseUrl + "ProjectSession");
    }

    public void initProject(String managerProject) throws Exception {
        this.currentProject = managerProject;
        this.projectSessionClient.initProject(this.currentProject);
        this.permission = this.isInRole(this.userName, "admin");
    }

    public void initModel(String managerProject) throws Exception {
        this.currentProject = managerProject;
        this.projectSessionClient.initModel(this.currentProject);
        this.permission = this.isInRole(this.userName, "admin");
    }

    public void initProject(String src, String dest) throws Exception {
        this.login(this.userName, this.userPassword);
        this.projectSessionClient.initProject(src, dest);
        this.currentProject = dest;
    }

    public void instantiateProject(String src) throws Exception {
        this.login(this.userName, this.userPassword);
        this.projectSessionClient.instantiateProject(src);
    }

    public boolean openProject(String projectName) throws Exception {
        this.initProject(projectName);
        return true;
    }

    public boolean createProject(String projectName) throws Exception {
        if (this.exists(projectName)) {
            return false;
        }
        this.initProject(projectName);
        return true;
    }

    public boolean createModel(String modelName) throws Exception {
        if (this.exists(modelName)) {
            return false;
        }
        this.initModel(modelName);
        return true;
    }

    public boolean cloneProject(String projectSrc, String projectDest) throws Exception {
        if (this.exists(projectDest)) {
            return false;
        }
        this.initProject(projectSrc, projectDest);
        return true;
    }

    private boolean exists(String name) throws Exception {
        Collection projects = this.getProjects();
        for (String prj : projects) {
            if (!prj.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Collection getProjects() throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] projects = this.userSessionClient.getProjectListNames();
        Iterator<Object> i = Arrays.asList(projects).iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public Collection getProjectsList() throws Exception {
        ArrayList<BnProjectLightValue> result = new ArrayList<BnProjectLightValue>();
        Object[] projects = this.userSessionClient.getProjectList();
        Iterator<Object> i = Arrays.asList(projects).iterator();
        while (i.hasNext()) {
            result.add((BnProjectLightValue)i.next());
        }
        return result;
    }

    public Collection getProjectInstances(String projectName) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] instances = this.userSessionClient.getProjectInstancesNames(projectName);
        Iterator<Object> i = Arrays.asList(instances).iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public Collection getInstances() throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] instances = this.userSessionClient.getInstancesListNames();
        Iterator<Object> i = Arrays.asList(instances).iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public boolean containsNode(String value) throws Exception {
        Collection nodes = this.getNodes();
        for (String nodeName : nodes) {
            if (!value.equalsIgnoreCase(nodeName)) continue;
            return true;
        }
        return false;
    }

    public String getType() throws Exception {
        return this.projectSessionClient.getType();
    }

    public String getStatus() throws Exception {
        return this.projectSessionClient.getStatus();
    }

    public void setStatus(String status) throws Exception {
        if (status.equals("Active")) {
            this.projectSessionClient.activeProcess();
        } else {
            this.projectSessionClient.hideProcess();
        }
    }

    public Collection getNodes() throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] nodes = this.projectSessionClient.getNodesNames();
        Iterator<Object> i = Arrays.asList(nodes).iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public Collection getEdges() throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] edges = this.projectSessionClient.getEdgesNames();
        Iterator<Object> i = Arrays.asList(edges).iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public void addNodeProperty(String node, String key, String value, boolean propagate) throws Exception {
        this.projectSessionClient.setNodeProperty(node, key, value, propagate);
    }

    public void addIteration(String from, String to, String condition) throws Exception {
        this.projectSessionClient.addIteration(from, to, condition);
    }

    public Collection getIterations() throws Exception {
        ArrayList<BnIterationLightValue> result = new ArrayList<BnIterationLightValue>();
        Object[] ite = this.projectSessionClient.getIterations();
        Iterator<Object> i = Arrays.asList(ite).iterator();
        while (i.hasNext()) {
            result.add((BnIterationLightValue)i.next());
        }
        return result;
    }

    public void addProjectProperty(String key, String value) throws Exception {
        this.projectSessionClient.setProperty(key, value);
    }

    public void addNodeInterHook(String node, String hook, String event, String value) throws Exception {
        this.projectSessionClient.addNodeInterHook(node, hook, event, 6, value);
    }

    public void addProjectInterHook(String hook, String event, String value) throws Exception {
        this.projectSessionClient.addInterHook(hook, event, 6, value);
    }

    public void addNode(String name, String type) throws Exception {
        int nodeType = 0;
        if (type.equals("AND JOIN")) {
            nodeType = 1;
        }
        if (type.equals("OR JOIN")) {
            nodeType = 2;
        }
        if (type.equals("AND JOIN AUTO")) {
            nodeType = 3;
        }
        if (type.equals("OR JOIN AUTO")) {
            nodeType = 4;
        }
        if (type.equals("SUB PROCESS")) {
            nodeType = 5;
        }
        this.projectSessionClient.addNode(name, nodeType);
    }

    public void addNodeSubProcess(String name, String projectName) throws Exception {
        this.projectSessionClient.addNodeSubProcess(name, projectName);
    }

    public boolean deleteNode(String node) throws Exception {
        this.projectSessionClient.deleteNode(node);
        return true;
    }

    public boolean deleteProject(String projectName) throws Exception {
        if (projectName.matches(".*_instance.*")) {
            this.userSessionClient.removeInstance(projectName);
        } else {
            this.userSessionClient.removeProject(projectName);
        }
        return true;
    }

    public void deleteEdges(Object[] edges) throws Exception {
        for (int i = 0; i < edges.length; ++i) {
            this.projectSessionClient.deleteEdge((String)edges[i]);
        }
    }

    public String addEdge(String src, String dest) throws Exception {
        String name = null;
        name = this.projectSessionClient.addEdge(src, dest);
        return name;
    }

    public String setEdgeCondition(String edgeName, String condition) throws Exception {
        this.projectSessionClient.setEdgeCondition(edgeName, condition);
        return edgeName;
    }

    public String getEdgeCondition(String edgeName) throws Exception {
        return this.projectSessionClient.getEdgeCondition(edgeName);
    }

    public String getState(String name) throws Exception {
        int state = this.getNodeState(name);
        switch (state) {
            case 0: {
                return "Initial";
            }
            case 1: {
                return "Ready";
            }
            case 3: {
                return "Anticipable";
            }
            case 5: {
                return "Anticipating";
            }
            case 6: {
                return "Executing";
            }
            case 7: {
                return "Executed";
            }
            case 10: {
                return "Terminated";
            }
            case 12: {
                return "Ant_suspended";
            }
            case 13: {
                return "Exec_suspended";
            }
        }
        return "";
    }

    public int getNodeState(String name) throws Exception {
        return this.projectSessionClient.getNodeState(name);
    }

    public int getNodeType(String name) throws Exception {
        return this.projectSessionClient.getNodeType(name);
    }

    public boolean getNodeAnticipable(String name) throws Exception {
        return this.projectSessionClient.getNodeAnticipable(name);
    }

    public String getNodeInterHookValue(String nodeName, String hookName) throws Exception {
        return this.projectSessionClient.getNodeInterHookValue(nodeName, hookName);
    }

    public void setNodeInterHookValue(String nodeName, String hookName, String value) throws Exception {
        this.projectSessionClient.setNodeInterHookValue(nodeName, hookName, value);
    }

    public String getProjectInterHookValue(String hookName) throws Exception {
        return this.projectSessionClient.getInterHookValue(hookName);
    }

    public void setProjectInterHookValue(String hookName, String value) throws Exception {
        this.projectSessionClient.setInterHookValue(hookName, value);
    }

    public String getNodeDescription(String nodeName) throws Exception {
        return this.projectSessionClient.getNodeDescription(nodeName);
    }

    public void setNodeDescription(String nodeName, String description) throws Exception {
        this.projectSessionClient.setNodeDescription(nodeName, description);
    }

    public void setNodeTraditional(String nodeName) throws Exception {
        this.projectSessionClient.setNodeTraditional(nodeName);
    }

    public void setNodeAnticipable(String nodeName) throws Exception {
        this.projectSessionClient.setNodeAnticipable(nodeName);
    }

    public String getEdgeInNode(String name) throws Exception {
        return this.projectSessionClient.getEdgeInNode(name);
    }

    public String getEdgeOutNode(String name) throws Exception {
        return this.projectSessionClient.getEdgeOutNode(name);
    }

    public boolean isActive(String name) throws Exception {
        int state = this.getNodeState(name);
        switch (state) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 3: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return false;
            }
            case 10: {
                return true;
            }
            case 12: {
                return false;
            }
            case 13: {
                return false;
            }
        }
        return false;
    }

    public String getType(String name) throws Exception {
        int type = this.projectSessionClient.getNodeType(name);
        switch (type) {
            case 1: {
                return "And Join";
            }
            case 2: {
                return "Or Join";
            }
            case 3: {
                return "And Join Automatic";
            }
            case 4: {
                return "Or Join Automatic";
            }
            case 5: {
                return "Sub Procss";
            }
        }
        return "";
    }

    public String getRole(String name) throws Exception {
        return this.projectSessionClient.getNodeRoleName(name);
    }

    public void setNodeRole(String node, String newRole) throws Exception {
        this.projectSessionClient.setNodeRole(node, newRole);
    }

    public String getDeadline(String name) throws Exception {
        return this.projectSessionClient.getNodeDeadline(name);
    }

    public void setDeadline(String node, long dl) throws Exception {
        this.projectSessionClient.setNodeDeadline(node, dl);
    }

    public Collection getRoles() throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] roles = this.projectSessionClient.getRolesNames();
        Iterator<Object> i = Arrays.asList(roles).iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public Collection getUsersInProject() throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] users = this.projectSessionClient.getUsers();
        Iterator<Object> i = Arrays.asList(users).iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public Collection getAllUsers() throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] users = this.projectSessionClient.getAllUsers();
        Iterator<Object> i = Arrays.asList(users).iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public void addUser(String name) throws Exception {
        this.projectSessionClient.addUser(name);
    }

    public void addRole(String name, String desc) throws Exception {
        this.projectSessionClient.addRole(name, desc);
    }

    public void setUserRole(String name, String role) throws Exception {
        this.projectSessionClient.setUserRole(name, role);
    }

    public void addRoleMapper(String role, String mapper, String type) throws Exception {
        int mapperType = 0;
        if (type.equals("Properties")) {
            mapperType = 1;
        }
        if (type.equals("Custom")) {
            mapperType = 2;
        }
        this.projectSessionClient.addRoleMapper(role, mapper, mapperType);
    }

    public void addNodePerformerAssigment(String node, String name, String type, String property) throws Exception {
        int performerType = 0;
        if (type.equals("Property")) {
            performerType = 1;
        }
        this.projectSessionClient.addNodePerformerAssign(node, name, performerType, property);
    }

    public boolean isInRole(String name, String role) throws Exception {
        Object[] projects = this.projectSessionClient.getUserRolesInProjectNames(name);
        for (String string : Arrays.asList(projects)) {
            if (!string.equals(role)) continue;
            return true;
        }
        return false;
    }

    public Collection getToDoList(String project) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] activity = this.userSessionClient.getToDoList(project);
        Iterator<Object> i = Arrays.asList(activity).iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public Collection getActivityList(String project) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] activity = this.userSessionClient.getActivityList(project);
        Iterator<Object> i = Arrays.asList(activity).iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public Object[] getProjectNodes() throws Exception {
        return this.projectSessionClient.getNodes();
    }

    public Collection getProperties() throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] prop = this.projectSessionClient.getPropertiesKey();
        Iterator<Object> i = Arrays.asList(prop).iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public void setEditNode(String node, String role, String description, long date) throws Exception {
        this.projectSessionClient.setEditNode(node, role, description, date);
    }

    public void startActivity(String project, String activity) throws Exception {
        this.userSessionClient.startActivity(project, activity);
    }

    public void terminateActivity(String project, String activity) throws Exception {
        this.userSessionClient.terminateActivity(project, activity);
    }

    public void cancelActivity(String project, String activity) throws Exception {
        this.userSessionClient.cancelActivity(project, activity);
    }

    public void terminateProject(String project) throws Exception {
        this.userSessionClient.terminate(project);
    }

    public StrutsNodeValue getStrutsNode(String name) throws Exception {
        return this.projectSessionClient.getStrutsNode(name);
    }
}

