/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collection;
import org.ocpsoft.common.util.Strings;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class JAASRoles
extends HttpCondition {
    private final Collection<String> roles;

    public static JAASRoles required(String ... roles) {
        return new JAASRoles(roles);
    }

    private JAASRoles(String[] roles) {
        this.roles = Arrays.asList(roles);
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        HttpServletRewrite rewrite = event;
        for (String role : this.roles) {
            if (((HttpServletRequest)rewrite.getRequest()).isUserInRole(role)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "JAASRoles.required(\"" + Strings.join(this.roles, (String)"\", \"") + "\")";
    }
}

