/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import java.net.MalformedURLException;
import java.util.Set;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternBuilder;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.servlet.config.HttpCondition;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.util.Transpositions;

public abstract class Resource
extends HttpCondition
implements Parameterized {
    private static final Logger log = Logger.getLogger(Resource.class);
    private final ParameterizedPatternParser resource;

    private Resource(String resource) {
        this.resource = new RegexParameterizedPatternParser(resource);
    }

    public boolean evaluateHttp(HttpServletRewrite event, EvaluationContext context) {
        if (this.resource != null) {
            ParameterizedPatternBuilder builder = this.resource.getBuilder();
            if (builder.isParameterComplete((Rewrite)event, context)) {
                String file = builder.build((Rewrite)event, context, Transpositions.encodePath());
                try {
                    return event.getServletContext().getResource(file) != null;
                }
                catch (MalformedURLException e) {
                    log.debug("Invalid file format [{}]", (Object)file);
                }
            } else {
                Set paths = event.getServletContext().getResourcePaths("/");
                for (String path : paths) {
                    if (!this.resource.parse(path).matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Resource exists(final String resource) {
        return new Resource(resource){

            public String toString() {
                return "Resource.exists(\"" + resource + "\")";
            }
        };
    }

    public ParameterizedPatternParser getExpression() {
        return this.resource;
    }

    public Set<String> getRequiredParameterNames() {
        return this.resource.getRequiredParameterNames();
    }

    public void setParameterStore(ParameterStore store) {
        this.resource.setParameterStore(store);
    }
}

