/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.api.TemplatePathLocator;
import org.openapitools.codegen.api.TemplateProcessor;
import org.openapitools.codegen.api.TemplatingEngineAdapter;
import org.openapitools.codegen.api.TemplatingExecutor;
import org.openapitools.codegen.templating.TemplateManagerOptions;
import org.openapitools.codegen.templating.TemplateNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateManager
implements TemplatingExecutor,
TemplateProcessor {
    private final TemplateManagerOptions options;
    private final TemplatingEngineAdapter engineAdapter;
    private final TemplatePathLocator[] templateLoaders;
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateManager.class);

    public TemplateManager(TemplateManagerOptions options, TemplatingEngineAdapter engineAdapter, TemplatePathLocator[] templateLoaders) {
        this.options = options;
        this.engineAdapter = engineAdapter;
        this.templateLoaders = templateLoaders;
    }

    private String getFullTemplateFile(String name) {
        String template = Arrays.stream(this.templateLoaders).map(i -> i.getFullTemplatePath(name)).filter(Objects::nonNull).findFirst().orElse("");
        if (StringUtils.isEmpty((CharSequence)template)) {
            throw new TemplateNotFoundException(name);
        }
        return template;
    }

    public String getFullTemplateContents(String name) {
        return this.readTemplate(this.getFullTemplateFile(name));
    }

    public Path getFullTemplatePath(String name) {
        return Paths.get(this.getFullTemplateFile(name), new String[0]);
    }

    public static String getCPResourcePath(String name) {
        if (!"/".equals(File.separator)) {
            return name.replaceAll(Pattern.quote(File.separator), "/");
        }
        return name;
    }

    public String readTemplate(String name) {
        try {
            Reader reader = this.getTemplateReader(name);
            if (reader == null) {
                throw new RuntimeException("no file found");
            }
            Scanner s = new Scanner(reader).useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException("can't load template " + name);
        }
    }

    public Reader getTemplateReader(String name) {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(TemplateManager.getCPResourcePath(name));
            if (is == null) {
                is = new FileInputStream(new File(name));
            }
            return new InputStreamReader(is, StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException("can't load template " + name);
        }
    }

    public File write(Map<String, Object> data, String template, File target) throws IOException {
        String templateContent = this.engineAdapter.compileTemplate((TemplatingExecutor)this, data, template);
        return this.writeToFile(target.getPath(), templateContent);
    }

    public void ignore(Path path, String context) {
        LOGGER.info("Ignored {} ({})", (Object)path.toString(), (Object)context);
    }

    public void skip(Path path, String context) {
        LOGGER.info("Skipped {} ({})", (Object)path.toString(), (Object)context);
    }

    public File writeToFile(String filename, String contents) throws IOException {
        return this.writeToFile(filename, contents.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeToFile(String filename, byte[] contents) throws IOException {
        File outputFile = Paths.get(filename, new String[0]).toFile();
        if (this.options.isMinimalUpdate()) {
            String tempFilename = filename + ".tmp";
            File tempFile = null;
            try {
                tempFile = this.writeToFileRaw(tempFilename, contents);
                if (!this.filesEqual(tempFile, outputFile)) {
                    LOGGER.info("writing file " + filename);
                    Files.move(tempFile.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    tempFile = null;
                }
                LOGGER.info("skipping unchanged file " + filename);
            }
            finally {
                if (tempFile != null && tempFile.exists()) {
                    try {
                        tempFile.delete();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error removing temporary file " + tempFile, (Throwable)ex);
                    }
                }
            }
        } else {
            LOGGER.info("writing file " + filename);
            outputFile = this.writeToFileRaw(filename, contents);
        }
        return outputFile;
    }

    private File writeToFileRaw(String filename, byte[] contents) throws IOException {
        File output = Paths.get(filename, new String[0]).toFile();
        if (this.options.isSkipOverwrite() && output.exists()) {
            LOGGER.info("skip overwrite of file " + filename);
            return output;
        }
        if (output.getParent() != null && !new File(output.getParent()).exists()) {
            File parent = Paths.get(output.getParent(), new String[0]).toFile();
            parent.mkdirs();
        }
        Files.write(output.toPath(), contents, new OpenOption[0]);
        return output;
    }

    private boolean filesEqual(File file1, File file2) throws IOException {
        return file1.exists() && file2.exists() && Arrays.equals(Files.readAllBytes(file1.toPath()), Files.readAllBytes(file2.toPath()));
    }
}

