/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.languages.AbstractCppCodegen;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CppQtAbstractCodegen
extends AbstractCppCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(CppQtAbstractCodegen.class);
    protected final String PREFIX = "OAI";
    protected String apiVersion = "1.0.0";
    protected static final String CPP_NAMESPACE = "cppNamespace";
    protected static final String CPP_NAMESPACE_DESC = "C++ namespace (convention: name::space::for::api).";
    protected static final String CONTENT_COMPRESSION_ENABLED = "contentCompression";
    protected static final String CONTENT_COMPRESSION_ENABLED_DESC = "Enable Compressed Content Encoding for requests and responses";
    protected Set<String> foundationClasses = new HashSet<String>();
    protected String cppNamespace = "OpenAPI";
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Set<String> systemIncludes = new HashSet<String>();
    protected boolean isContentCompressionEnabled = false;
    protected Set<String> nonFrameworkPrimitives = new HashSet<String>();

    public CppQtAbstractCodegen() {
        this.modifyFeatureSet(features -> features.excludeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.PROTOBUF}).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling, GlobalFeature.MultiServer}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            this.modelNamePrefix = "OAI";
        }
        this.addOption(CPP_NAMESPACE, CPP_NAMESPACE_DESC, this.cppNamespace);
        this.addOption("modelNamePrefix", "Prefix that will be prepended to all model names.", this.modelNamePrefix);
        this.addSwitch(CONTENT_COMPRESSION_ENABLED, CONTENT_COMPRESSION_ENABLED_DESC, this.isContentCompressionEnabled);
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties().put("prefix", "OAI");
        this.additionalProperties.put(CPP_NAMESPACE, this.cppNamespace);
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "qint32", "qint64", "float", "double"));
        this.nonFrameworkPrimitives.addAll(this.languageSpecificPrimitives);
        this.foundationClasses.addAll(Arrays.asList("QString", "QDate", "QDateTime", "QByteArray"));
        this.languageSpecificPrimitives.addAll(this.foundationClasses);
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "QDate");
        this.typeMapping.put("DateTime", "QDateTime");
        this.typeMapping.put("string", "QString");
        this.typeMapping.put("integer", "qint32");
        this.typeMapping.put("long", "qint64");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("number", "double");
        this.typeMapping.put("array", "QList");
        this.typeMapping.put("map", "QMap");
        this.typeMapping.put("set", "QSet");
        this.typeMapping.put("object", "OAIObject");
        this.typeMapping.put("ByteArray", "QByteArray");
        this.typeMapping.put("UUID", "QString");
        this.typeMapping.put("URI", "QString");
        this.typeMapping.put("file", "QByteArray");
        this.typeMapping.put("binary", "QByteArray");
        this.importMapping = new HashMap();
        this.namespaces = new HashMap<String, String>();
        this.systemIncludes.add("QString");
        this.systemIncludes.add("QList");
        this.systemIncludes.add("QMap");
        this.systemIncludes.add("QSet");
        this.systemIncludes.add("QDate");
        this.systemIncludes.add("QDateTime");
        this.systemIncludes.add("QByteArray");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CPP_NAMESPACE)) {
            this.cppNamespace = (String)this.additionalProperties.get(CPP_NAMESPACE);
        }
        this.additionalProperties.put("cppNamespaceDeclarations", this.cppNamespace.split("\\::"));
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.modelNamePrefix = (String)this.additionalProperties.get("modelNamePrefix");
            this.typeMapping.put("object", this.modelNamePrefix + "Object");
            this.additionalProperties().put("prefix", this.modelNamePrefix);
        }
        if (this.additionalProperties.containsKey(CONTENT_COMPRESSION_ENABLED)) {
            this.setContentCompressionEnabled(this.convertPropertyToBooleanAndWriteBack(CONTENT_COMPRESSION_ENABLED));
        } else {
            this.additionalProperties.put(CONTENT_COMPRESSION_ENABLED, this.isContentCompressionEnabled);
        }
    }

    @Override
    public String toModelImport(String name) {
        if (name.isEmpty()) {
            return null;
        }
        if (this.namespaces.containsKey(name)) {
            return "using " + this.namespaces.get(name) + ";";
        }
        if (this.systemIncludes.contains(name)) {
            return "#include <" + name + ">";
        }
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        String folder = this.modelPackage().replace("::", File.separator);
        if (!folder.isEmpty()) {
            folder = folder + File.separator;
        }
        return "#include \"" + folder + name + ".h\"";
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        String openAPIType = this.getSchemaType(p);
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + "<QString, " + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isBinarySchema(p)) {
            return this.getSchemaType(p);
        }
        if (ModelUtils.isFileSchema(p)) {
            return this.getSchemaType(p);
        }
        if (this.foundationClasses.contains(openAPIType)) {
            return openAPIType;
        }
        if (this.languageSpecificPrimitives.contains(openAPIType)) {
            return this.toModelName(openAPIType);
        }
        return openAPIType;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            return "false";
        }
        if (ModelUtils.isDateSchema(p)) {
            return "NULL";
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return "NULL";
        }
        if (ModelUtils.isNumberSchema(p)) {
            if ("float".equals(p.getFormat())) {
                return "0.0f";
            }
            return "0.0";
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if ("int64".equals(p.getFormat())) {
                return "0L";
            }
            return "0";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return "QMap<QString, " + this.getTypeDeclaration(inner) + ">()";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "QList<" + this.getTypeDeclaration(inner) + ">()";
        }
        if (ModelUtils.isStringSchema(p)) {
            return "QString(\"\")";
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)p.get$ref())) {
            return this.toModelName(ModelUtils.getSimpleRef(p.get$ref())) + "()";
        }
        return "NULL";
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
            if (this.foundationClasses.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toVarName(String name) {
        String varName = name;
        varName = this.sanitizeName(name);
        if (varName.matches("^[A-Z_]*$")) {
            varName = varName.toLowerCase(Locale.ROOT);
        }
        if (this.isReservedWord(varName = StringUtils.underscore(varName)) || varName.matches("^\\d.*")) {
            varName = this.escapeReservedWord(varName);
        }
        return varName;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String getTypeDeclaration(String str) {
        return str;
    }

    @Override
    protected boolean needToImport(String type) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)type) && !this.defaultIncludes.contains(type) && !this.nonFrameworkPrimitives.contains(type);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<ModelMap> allModels) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        List imports = (List)objs.get("imports");
        HashMap<String, CodegenModel> codegenModels = new HashMap<String, CodegenModel>();
        for (ModelMap moObj : allModels) {
            CodegenModel mo = moObj.getModel();
            if (!mo.isEnum) continue;
            codegenModels.put(mo.classname, mo);
        }
        for (CodegenOperation operation : operations) {
            if (operation.returnType != null && codegenModels.containsKey(operation.returnType)) {
                operation.vendorExtensions.put("x-returns-enum", true);
            }
            if (operation.returnBaseType != null && this.needToImport(operation.returnBaseType) && !this.isIncluded(operation.returnBaseType, imports)) {
                imports.add(this.createMapping("import", operation.returnBaseType));
            }
            ArrayList<CodegenParameter> params = new ArrayList<CodegenParameter>();
            if (operation.allParams != null) {
                params.addAll(operation.allParams);
            }
            for (CodegenParameter param : params) {
                if (!param.isPrimitiveType || !this.needToImport(param.baseType) || this.isIncluded(param.baseType, imports)) continue;
                imports.add(this.createMapping("import", param.baseType));
            }
            if (operation.pathParams == null || this.isIncluded("QString", imports)) continue;
            imports.add(this.createMapping("import", "QString"));
        }
        if (this.isIncluded("QMap", imports) && !this.isIncluded("QString", imports)) {
            imports.add(this.createMapping("import", "QString"));
        }
        return objs;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        return this.escapeText(value);
    }

    @Override
    public boolean isDataTypeString(String dataType) {
        return "QString".equals(dataType);
    }

    private Map<String, String> createMapping(String key, String value) {
        HashMap<String, String> customImport = new HashMap<String, String>();
        customImport.put(key, this.toModelImport(value));
        return customImport;
    }

    private boolean isIncluded(String type, List<Map<String, String>> imports) {
        boolean included = false;
        String inclStr = this.toModelImport(type);
        for (Map<String, String> importItem : imports) {
            if (!importItem.containsValue(inclStr)) continue;
            included = true;
            break;
        }
        return included;
    }

    public void setContentCompressionEnabled(boolean flag) {
        this.isContentCompressionEnabled = flag;
    }
}

